/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStreamReader;
import java.net.URI;
import org.eclipse.osee.define.api.importing.RoughArtifactCollector;
import org.eclipse.osee.define.rest.importing.parsers.AbstractArtifactExtractor;
import org.eclipse.osee.define.rest.importing.parsers.XmlDataSaxHandler;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlDataExtractor
extends AbstractArtifactExtractor {
    @Override
    protected XResultData extractFromSource(OrcsApi orcsApi, XResultData results, URI source, RoughArtifactCollector collector) throws Exception {
        ArtifactTypeToken primaryArtifactType = null;
        for (ArtifactTypeToken type : orcsApi.tokenService().getArtifactTypes()) {
            if (!type.getName().equals(Lib.removeExtension((String)new File(source).getName()))) continue;
            primaryArtifactType = type;
        }
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler((ContentHandler)((Object)new XmlDataSaxHandler(orcsApi, results, collector, primaryArtifactType)));
        xmlReader.parse(new InputSource(new InputStreamReader(source.toURL().openStream(), "UTF-8")));
        return results;
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".xml");
            }
        };
    }

    public String getName() {
        return "Excel XML Data";
    }

    public String getDescription() {
        return "Extract Data from xml of the form <row><cell></cell>*</row>* like that created by Excel data export.";
    }
}

