/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.RelationTypeCriteria;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaFollowSearch;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaPagination;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeFollow;
import org.eclipse.osee.orcs.db.internal.search.handlers.ChildrenFollowRelationSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.FollowRelationSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.FollowSearchSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.PaginationSqlHandler;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerComparator;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class SelectiveArtifactSqlWriter
extends AbstractSqlWriter {
    private final List<AbstractJoinQuery> joinTables = new ArrayList<AbstractJoinQuery>();
    private static final SqlHandlerComparator HANDLER_COMPARATOR = new SqlHandlerComparator();
    private final AbstractSqlWriter parentWriter;
    private final List<Object> parameters = new ArrayList<Object>();
    private String fieldAlias;
    private String relsAlias;
    private String rels2Alias;
    private String attrSearchAlias;

    private SelectiveArtifactSqlWriter(AbstractSqlWriter parentWriter, SqlJoinFactory sqlJoinFactory, JdbcClient jdbcClient, QueryData rootQueryData) {
        super(sqlJoinFactory, jdbcClient, rootQueryData);
        this.parentWriter = parentWriter;
    }

    public SelectiveArtifactSqlWriter(SqlJoinFactory sqlJoinFactory, JdbcClient jdbcClient, QueryData rootQueryData) {
        this(null, sqlJoinFactory, jdbcClient, rootQueryData);
    }

    public SelectiveArtifactSqlWriter(AbstractSqlWriter parentWriter) {
        this(parentWriter, parentWriter.joinFactory, parentWriter.getJdbcClient(), new QueryData(parentWriter.rootQueryData));
    }

    @Override
    public void addParameter(Object parameter) {
        if (this.parentWriter == null) {
            this.parameters.add(parameter);
        } else {
            this.parentWriter.addParameter(parameter);
        }
    }

    @Override
    protected void addJoin(AbstractJoinQuery join) {
        if (this.parentWriter == null) {
            this.joinTables.add(join);
        } else {
            this.parentWriter.addJoin(join);
        }
    }

    public void runSql(Consumer<JdbcStatement> consumer, SqlHandlerFactory handlerFactory, int numArtifacts) {
        this.runSqlorFetch(consumer, handlerFactory, numArtifacts);
    }

    public int getCount(SqlHandlerFactory handlerFactory) {
        return this.runSqlorFetch(null, handlerFactory, 1);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int runSqlorFetch(Consumer<JdbcStatement> consumer, SqlHandlerFactory handlerFactory, int numArtifacts) {
        try {
            this.build(handlerFactory);
            for (AbstractJoinQuery join : this.joinTables) {
                join.store();
            }
            if (this.rootQueryData.isCountQueryType()) {
                var7_6 = (Integer)this.getJdbcClient().fetch((Object)-1, this.toSql(), this.parameters.toArray());
                return var7_6;
            }
            this.getJdbcClient().runQuery(consumer, numArtifacts * 20, this.toSql(), this.parameters.toArray());
        }
        finally {
            ** for (join : this.joinTables)
        }
lbl-1000:
        // 1 sources

        {
            try {
                join.close();
            }
            catch (Exception v0) {}
            continue;
        }
lbl19:
        // 1 sources

        this.reset();
        return var7_6;
    }

    public String toSql() {
        return this.output.toString();
    }

    @Override
    public Options getOptions() {
        return this.queryDataCursor.getOptions();
    }

    private void follow(SqlHandlerFactory handlerFactory, List<String> artWithAliases, String sourceArtTable) {
        ArrayList handlers = new ArrayList();
        FollowRelationSqlHandler previousFollow = null;
        for (Criteria criteria : this.queryDataCursor.getOnlyCriteriaSet()) {
            if (criteria instanceof CriteriaRelationTypeFollow) {
                FollowRelationSqlHandler handlerSlim = previousFollow == null ? new FollowRelationSqlHandler(sourceArtTable) : new FollowRelationSqlHandler(previousFollow);
                handlerSlim.setData((CriteriaRelationTypeFollow)criteria);
                handlers.add(handlerSlim);
                previousFollow = handlerSlim;
                if (this.queryDataCursor.getParentQueryData() == null || !this.rootQueryData.hasCriteriaType(CriteriaPagination.class)) continue;
                PaginationSqlHandler pHandler = new PaginationSqlHandler();
                pHandler.setData(new CriteriaPagination(0L, 0L));
                handlers.add(pHandler);
                continue;
            }
            handlers.add(handlerFactory.createHandler(criteria));
        }
        if (!this.newRelationInCriteria(Collections.singletonList(this.queryDataCursor)) && this.newRelationInCriteria(this.queryDataCursor.getChildrenQueryData())) {
            handlers.add(new ChildrenFollowRelationSqlHandler());
        }
        Collections.sort(handlers, HANDLER_COMPARATOR);
        String artWithAlias = this.write(handlers, "artWith");
        artWithAliases.add(artWithAlias);
        QueryData tempQueryDataCursor = this.queryDataCursor;
        Iterator iterator = this.queryDataCursor.getChildrenQueryData().iterator();
        while (iterator.hasNext()) {
            QueryData childQueryData;
            this.queryDataCursor = childQueryData = (QueryData)iterator.next();
            this.follow(handlerFactory, artWithAliases, artWithAlias);
        }
        this.queryDataCursor = tempQueryDataCursor;
    }

    private boolean newRelationInCriteria(List<QueryData> queryDatas) {
        for (QueryData queryData : queryDatas) {
            for (Criteria criteria : queryData.getAllCriteria()) {
                if (!(criteria instanceof RelationTypeCriteria) || !((RelationTypeCriteria)criteria).getType().isNewRelationTable()) continue;
                return true;
            }
        }
        return false;
    }

    public void build(SqlHandlerFactory handlerFactory) {
        String artWithAlias;
        ArrayList<String> artWithAliases = new ArrayList<String>();
        this.follow(handlerFactory, artWithAliases, null);
        if (artWithAliases.size() == 1) {
            artWithAlias = (String)artWithAliases.get(0);
        } else {
            artWithAlias = this.startCommonTableExpression("arts");
            boolean firstAlias = true;
            for (String art : artWithAliases) {
                if (!firstAlias) {
                    this.write(" union ");
                } else {
                    firstAlias = false;
                }
                this.write("SELECT " + art + ".* from " + art);
            }
        }
        if (this.rootQueryData.isIdQueryType() || this.rootQueryData.isCountQueryType() && !this.rootQueryData.hasCriteriaType(CriteriaFollowSearch.class)) {
            this.fieldAlias = artWithAlias;
        } else {
            String attsAlias = this.writeAttsCommonTableExpression(artWithAlias);
            if (this.rootQueryData.isAttributesOnlyQueryType() || this.rootQueryData.isTokenQueryType()) {
                this.fieldAlias = attsAlias;
            } else {
                this.writeRelsCommonTableExpression(artWithAlias);
                this.writeRelsCommonTableExpression2(artWithAlias);
                if (this.rootQueryData.hasCriteriaType(CriteriaFollowSearch.class)) {
                    this.writeFollowSearchCommonTableExpression(handlerFactory, attsAlias);
                }
                this.writeFieldsCommonTableExpression(artWithAlias, attsAlias);
            }
        }
        this.finishWithClause();
        if (this.rootQueryData.isCountQueryType()) {
            if (this.rootQueryData.hasCriteriaType(CriteriaFollowSearch.class)) {
                this.write("select count(distinct " + this.fieldAlias + ".art_id) from %s", this.fieldAlias);
            } else {
                this.write("SELECT count(*) FROM %s", this.fieldAlias);
            }
        } else {
            this.write("SELECT * FROM %s", this.fieldAlias);
        }
        if (this.rootQueryData.hasCriteriaType(CriteriaFollowSearch.class)) {
            this.write(", " + this.attrSearchAlias);
            this.write(" where (" + this.getJdbcClient().getDbType().getInStringSql(String.valueOf(this.fieldAlias) + ".art_path", "','||" + this.attrSearchAlias + ".art_id||','") + " > 0 or " + this.getJdbcClient().getDbType().getInStringSql(String.valueOf(this.attrSearchAlias) + ".art_path", "','||" + this.fieldAlias + ".art_id||','") + " > 0 or " + this.getJdbcClient().getDbType().getInStringSql(String.valueOf(this.attrSearchAlias) + ".art_path", "','||" + this.fieldAlias + ".other_art_id||','") + " > 0 ) ");
        }
        if (this.rootQueryData.isCountQueryType() && this.rootQueryData.hasCriteriaType(CriteriaFollowSearch.class)) {
            this.write(" and " + this.fieldAlias + ".top = 1");
        }
        if (!this.rootQueryData.isCountQueryType()) {
            if (this.parentWriter == null && !this.rootQueryData.isSelectQueryType()) {
                this.write(" ORDER BY " + this.fieldAlias + ".art_id");
            } else if (this.rels2Alias != null) {
                this.write(" ORDER BY ");
                this.write(String.valueOf(this.fieldAlias) + ".top desc");
                if (this.rootQueryData.orderMechanism().equals("ATTRIBUTE") || this.rootQueryData.orderMechanism().equals("RELATION AND ATTRIBUTE")) {
                    this.write(", CASE WHEN " + this.fieldAlias + ".type_id = ");
                    this.write(this.rootQueryData.orderByAttribute().getIdString());
                    this.write(" THEN " + this.fieldAlias + ".VALUE ELSE \n");
                    this.write("'");
                    this.write(new String(new char[4000]).replace('\u0000', 'Z'));
                    this.write("'");
                    this.write("\nEND ASC");
                }
                if (this.rootQueryData.orderMechanism().equals("RELATION") || this.rootQueryData.orderMechanism().equals("RELATION AND ATTRIBUTE")) {
                    if (this.output.toString().contains("top_rel_type")) {
                        this.write(", " + this.fieldAlias + ".top_rel_type, " + this.fieldAlias + ".top_rel_order, " + this.fieldAlias + ".rel_order");
                    } else {
                        this.write(", case when " + this.fieldAlias + ".other_art_id = 0 then " + this.fieldAlias + ".other_art_id else 1 end, " + this.fieldAlias + ".rel_order");
                    }
                }
            }
        }
    }

    private void writeFollowSearchCommonTableExpression(SqlHandlerFactory handlerFactory, String attsAlias) {
        FollowSearchSqlHandler followSearchHandler = (FollowSearchSqlHandler)handlerFactory.createHandler((Criteria)this.rootQueryData.getCriteriaByType(CriteriaFollowSearch.class).get(0));
        boolean newRelationUsed = this.newRelationInCriteria(Collections.singletonList(this.queryDataCursor)) || this.newRelationInCriteria(this.queryDataCursor.getChildrenQueryData());
        this.attrSearchAlias = followSearchHandler.writeFollowSearchCommonTableExpression(this, attsAlias, newRelationUsed, this.rootQueryData.hasCriteriaType(CriteriaPagination.class) ? (CriteriaPagination)this.rootQueryData.getCriteriaByType(CriteriaPagination.class).get(0) : null);
    }

    private void writeFieldsCommonTableExpression(String artWithAlias, String attsAlias) {
        this.fieldAlias = this.startCommonTableExpression("fields");
        this.writeSelectAndHint();
        this.writeSelectFields(attsAlias, "*");
        this.write(", 0 as rel_type, 0 as rel_order, 0 AS other_art_type_id FROM ");
        this.write(attsAlias);
        this.write("\n UNION ALL\n ");
        SelectiveArtifactSqlWriter relWriter = new SelectiveArtifactSqlWriter(this);
        relWriter.relsAlias = this.relsAlias;
        ArrayList handlers = new ArrayList();
        handlers.add(new SqlHandler<Criteria>(){
            private String artAlias;

            @Override
            public void addTables(AbstractSqlWriter writer) {
                writer.addTable(SelectiveArtifactSqlWriter.this.relsAlias);
                this.artAlias = writer.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
            }

            @Override
            public void addPredicates(AbstractSqlWriter writer) {
                writer.writeEquals(SelectiveArtifactSqlWriter.this.relsAlias, "other_art_id", this.artAlias, "art_id");
            }

            @Override
            public int getPriority() {
                return SqlHandlerPriority.RELATED_TO_ART_IDS.ordinal();
            }
        });
        relWriter.write(handlers);
        this.write(relWriter.toSql());
        this.write("\n UNION ALL\n ");
        SelectiveArtifactSqlWriter relWriter2 = new SelectiveArtifactSqlWriter(this);
        relWriter2.rels2Alias = this.rels2Alias;
        ArrayList handlers2 = new ArrayList();
        handlers2.add(new SqlHandler<Criteria>(){
            private String artAlias;

            @Override
            public void addTables(AbstractSqlWriter writer) {
                writer.addTable(SelectiveArtifactSqlWriter.this.rels2Alias);
                this.artAlias = writer.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
            }

            @Override
            public void addPredicates(AbstractSqlWriter writer) {
                writer.writeEquals(SelectiveArtifactSqlWriter.this.rels2Alias, "other_art_id", this.artAlias, "art_id");
            }

            @Override
            public int getPriority() {
                return SqlHandlerPriority.RELATED_TO_ART_IDS.ordinal();
            }
        });
        relWriter2.write(handlers2);
        this.write(relWriter2.toSql());
    }

    private String writeAttsCommonTableExpression(String artWithAlias) {
        String attsAlias = this.startCommonTableExpression("atts");
        String attAlias = "att";
        String attTxsAlias = "txs";
        this.writeUseNlTableHint(String.valueOf(attAlias) + " " + attTxsAlias);
        this.writeSelectFields(artWithAlias, "*", attAlias, "attr_type_id AS type_id", attAlias, "value", attAlias, "uri", attAlias, "attr_id");
        this.write(", 0 AS other_art_id");
        this.write("\n FROM %s, osee_attribute att, osee_txs txs", artWithAlias);
        this.write("\n WHERE ");
        this.writeEqualsAnd(artWithAlias, attAlias, "art_id");
        AttributeTypeId attributeType = this.rootQueryData.getAttributeType();
        if (attributeType.isValid()) {
            this.writeEqualsParameterAnd(attAlias, "attr_type_id", attributeType);
        }
        this.writeEqualsAnd(attAlias, attTxsAlias, "gamma_id");
        this.writeTxBranchFilter(attTxsAlias);
        return attsAlias;
    }

    private void writeRelsCommonTableExpression(String artWithAlias) {
        this.relsAlias = this.startCommonTableExpression("rels");
        String relAlias = "rel";
        String relTxsAlias = "txs";
        this.writeUseNlTableHint(String.valueOf(relAlias) + " " + relTxsAlias);
        this.writeSelectFields(artWithAlias, "*", relAlias, "rel_link_type_id AS type_id");
        this.write(", CASE art_id WHEN a_art_id THEN 'B' ELSE 'A' END AS value, '' AS spare1, 0 AS spare2, CASE art_id WHEN a_art_id THEN b_art_id ELSE a_art_id END AS other_art_id, 0 as rel_type, 0 as rel_order");
        this.write("\n FROM %s, osee_relation_link rel, osee_txs txs", artWithAlias);
        this.write("\n WHERE ");
        this.write(artWithAlias);
        this.write(".art_id IN (a_art_id, b_art_id)");
        this.writeAnd();
        this.writeEqualsAnd(relAlias, relTxsAlias, "gamma_id");
        this.writeTxBranchFilter(relTxsAlias);
    }

    private void writeRelsCommonTableExpression2(String artWithAlias) {
        this.rels2Alias = this.startCommonTableExpression("rels");
        String relAlias = "rel";
        String relTxsAlias = "txs";
        this.writeUseNlTableHint(String.valueOf(relAlias) + " " + relTxsAlias);
        this.writeSelectFields(artWithAlias, "*", relAlias, "rel_type AS type_id");
        this.write(", CASE art_id WHEN a_art_id THEN 'B' ELSE 'A' END AS value, '' AS spare1, 0 AS spare2, CASE art_id WHEN a_art_id THEN b_art_id ELSE a_art_id END AS other_art_id, rel_type, rel_order");
        this.write("\n FROM %s, osee_relation rel, osee_txs txs", artWithAlias);
        this.write("\n WHERE ");
        this.write(artWithAlias);
        this.write(".art_id IN (a_art_id, b_art_id)");
        this.writeAnd();
        this.writeEqualsAnd(relAlias, relTxsAlias, "gamma_id");
        this.writeTxBranchFilter(relTxsAlias);
    }

    @Override
    protected void writeSelectFields() {
        String artAlias = this.getMainTableAlias(OseeDb.ARTIFACT_TABLE);
        String txAlias = this.getMainTableAlias(OseeDb.TXS_TABLE);
        if (this.relsAlias == null && this.rels2Alias == null) {
            this.writeSelectFields(artAlias, "art_id", artAlias, "art_type_id", txAlias, "app_id", txAlias, "transaction_id", txAlias, "mod_type");
            if (OptionsUtil.getIncludeApplicabilityTokens((Options)this.rootQueryData.getOptions())) {
                this.writeSelectFields(this.getMainTableAlias(OseeDb.OSEE_KEY_VALUE_TABLE), "value app_value");
            }
            this.write(", ");
            this.write(this.queryDataCursor.getParentQueryData() == null ? "1" : "0");
            this.write(" AS top");
        } else if (this.relsAlias != null) {
            this.writeSelectFields(this.relsAlias, "*", artAlias, "art_type_id");
            this.write(" AS other_art_type_id");
        } else if (this.rels2Alias != null) {
            this.writeSelectFields(this.rels2Alias, "*", artAlias, "art_type_id");
            this.write(" AS other_art_type_id");
        }
    }

    @Override
    protected void writeSelect(Iterable<SqlHandler<?>> handlers) {
        String multiHint = this.getMultiTableHintParameter();
        if (multiHint.split(" ").length > 1) {
            this.writeUseNlTableHint(multiHint);
        } else {
            this.writeSelectAndHint();
        }
        if (this.rootQueryData.isCountQueryType() && !this.rootQueryData.hasCriteriaType(CriteriaFollowSearch.class)) {
            this.writeSelectFields(this.getMainTableAlias(OseeDb.ARTIFACT_TABLE), "art_id");
        } else {
            this.writeSelectFields();
            for (SqlHandler<?> handler : handlers) {
                handler.writeSelectFields(this);
            }
        }
    }

    @Override
    public void writeGroupAndOrder(Iterable<SqlHandler<?>> handlers) {
    }

    @Override
    protected void reset() {
        super.reset();
        this.parameters.clear();
        this.joinTables.clear();
        this.rootQueryData.reset();
    }

    @Override
    public String toString() {
        if (this.parentWriter == null) {
            StringBuilder strB = new StringBuilder();
            String[] tokens = this.output.toString().split("\\?");
            int i = 0;
            while (i < tokens.length) {
                strB.append(tokens[i]);
                if (i < this.parameters.size()) {
                    Object parameter = this.parameters.get(i);
                    if (parameter instanceof Id) {
                        strB.append(((Id)parameter).getIdString());
                    } else {
                        strB.append(parameter);
                    }
                } else if (i < tokens.length - 1) {
                    strB.append("?");
                }
                ++i;
            }
            return strB.toString();
        }
        return this.toSql();
    }
}

