/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.export;

import java.io.File;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.exchange.handler.ExportItem;

public abstract class AbstractExportItem
extends CancellableCallable<Boolean> {
    private final ExportItem id;
    private final String fileName;
    private File writeLocation;
    private boolean cancel;
    private final Log logger;

    public AbstractExportItem(Log logger, ExportItem id) {
        this.logger = logger;
        this.id = id;
        this.fileName = id.getFileName();
        this.cancel = false;
    }

    protected Log getLogger() {
        return this.logger;
    }

    public String getSource() {
        return this.id.getSource();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.id.toString();
    }

    public int getPriority() {
        return this.id.getPriority();
    }

    public int getBufferSize() {
        return (int)Math.pow(2.0, 20.0);
    }

    public void setWriteLocation(File writeLocation) {
        this.writeLocation = writeLocation;
    }

    public File getWriteLocation() {
        return this.writeLocation;
    }

    public void cleanUp() {
        this.setWriteLocation(null);
    }

    public final Boolean call() throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            this.checkForCancelled();
            this.executeWork();
        }
        catch (Throwable throwable) {
            this.getLogger().info("Exported: [%s] in [%s]", new Object[]{this.getName(), Lib.getElapseString((long)startTime)});
            throw throwable;
        }
        this.getLogger().info("Exported: [%s] in [%s]", new Object[]{this.getName(), Lib.getElapseString((long)startTime)});
        return true;
    }

    protected abstract void executeWork() throws Exception;

    public void setCancel(boolean cancel) {
        super.setCancel(cancel);
        this.cancel = cancel;
    }

    public boolean isCancel() {
        return this.cancel;
    }
}

