/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.users;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class AtsUsersUtility {
    private static final Pattern addressPattern = Pattern.compile(".+?@.+?\\.[a-z]+");

    private AtsUsersUtility() {
    }

    public static Collection<AtsUser> getValidEmailUsers(Collection<? extends AtsUser> users) {
        HashSet<AtsUser> validUsers = new HashSet<AtsUser>();
        for (AtsUser atsUser : users) {
            if (!AtsUsersUtility.isEmailValid(atsUser.getEmail())) continue;
            validUsers.add(atsUser);
        }
        return validUsers;
    }

    public static Collection<AtsUser> getActiveEmailUsers(Collection<? extends AtsUser> users) {
        HashSet<AtsUser> activeUsers = new HashSet<AtsUser>();
        for (AtsUser atsUser : users) {
            if (!atsUser.isActive()) continue;
            activeUsers.add(atsUser);
        }
        return activeUsers;
    }

    public static boolean isEmailValid(String email) {
        if (Strings.isValid((String)email)) {
            return addressPattern.matcher(email).matches();
        }
        return false;
    }

    public static Collection<? extends AtsUser> getUsers(Collection<String> userIds, IAtsUserService userService) {
        HashSet<AtsUser> users = new HashSet<AtsUser>();
        for (String userId : userIds) {
            users.add(userService.getUserByUserId(userId));
        }
        return users;
    }
}

