/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api;

import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.util.AbstractArtifactUrl;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.orcs.OrcsApi;

public class ArtifactUrlServer
extends AbstractArtifactUrl {
    private final OrcsApi orcsApi;

    public ArtifactUrlServer(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public String getSessionId() {
        return null;
    }

    public String getClientName() {
        return null;
    }

    public String getClientPort() {
        return null;
    }

    public Long getTransactionId(ArtifactToken artifact) {
        return ((ArtifactReadable)artifact).getTransaction().getId();
    }

    public boolean isUseConnectedServerUrl() {
        return false;
    }

    protected boolean isDeleted(ArtifactToken artifact) {
        return ((ArtifactReadable)artifact).isDeleted();
    }

    protected boolean isHistorical(ArtifactToken artifact) {
        return ((ArtifactReadable)artifact).isHistorical();
    }

    protected String getPermanentBaseUrl() {
        String address = this.orcsApi.getSystemProperties().getValue("osee.permanent.base.url");
        return this.normalize(address);
    }

    public String getSelectedPermanentLinkUrl() {
        String address = null;
        try {
            address = this.getPermanentBaseUrl();
        }
        catch (Exception ex) {
            OseeLog.log(ArtifactUrlServer.class, (Level)Level.WARNING, (Throwable)ex);
        }
        if (!Strings.isValid((String)address)) {
            address = this.orcsApi.getSystemProperties().getValue("osee.application.server");
        }
        if (Strings.isInValid((String)address)) {
            address = "http://localhost:8089";
        }
        return this.normalize(address);
    }
}

