/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core.server;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.internal.Activator;
import org.eclipse.osee.framework.plugin.core.server.ResourceFinder;

public class ClassServer
extends Thread {
    private ServerSocket server;
    private URL hostName;
    private List<ResourceFinder> resourceFinders;
    private ExecutorService socketThreads;

    public ClassServer(int port, InetAddress address) throws IOException {
        this.server = new ServerSocket(port, 50, address);
        this.socketThreads = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable arg0) {
                Thread th = new Thread(arg0, "ClassServer Task");
                th.setDaemon(true);
                return th;
            }
        });
        this.hostName = address instanceof Inet6Address ? new URL("http://[" + address.getHostAddress() + "]:" + this.server.getLocalPort() + "/") : new URL("http://" + address.getHostAddress() + ":" + this.server.getLocalPort() + "/");
        this.setName("OSEE ClassServer");
        this.resourceFinders = new ArrayList<ResourceFinder>();
    }

    public void addResourceFinder(ResourceFinder finder) {
        this.resourceFinders.add(finder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String msg = "ClassServer started [";
        msg = String.valueOf(msg) + "port ";
        msg = String.valueOf(msg) + Integer.toString(this.getPort());
        msg = String.valueOf(msg) + "]";
        OseeLog.log(Activator.class, (Level)Level.INFO, (String)msg);
        try {
            while (true) {
                Socket socket = this.server.accept();
                this.socketThreads.submit(new Task(socket));
            }
        }
        catch (IOException e) {
            ClassServer classServer = this;
            synchronized (classServer) {
                if (!this.server.isClosed()) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"accepting connection", (Throwable)e);
                    this.terminate();
                    OseeLog.log(Activator.class, (Level)Level.WARNING, (String)"ClassServer Terminated");
                }
            }
            return;
        }
    }

    public synchronized void terminate() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {}
        for (ResourceFinder resFinder : this.resourceFinders) {
            resFinder.dispose();
        }
    }

    public int getPort() {
        return this.server.getLocalPort();
    }

    private static boolean readLine(InputStream in, StringBuffer buf) throws IOException {
        int c;
        while ((c = in.read()) >= 0) {
            if (c == 13) {
                in.mark(1);
                c = in.read();
                if (c != 10) {
                    in.reset();
                }
                return true;
            }
            if (c == 10) {
                return true;
            }
            buf.append((char)c);
        }
        return buf.length() > 0;
    }

    private static String getInput(Socket sock, boolean isRequest) throws IOException {
        BufferedInputStream in = new BufferedInputStream(sock.getInputStream(), 256);
        StringBuffer buf = new StringBuffer(80);
        do {
            if (ClassServer.readLine(in, buf)) continue;
            return null;
        } while (isRequest && buf.length() == 0);
        String initial = buf.toString();
        do {
            buf.setLength(0);
        } while (ClassServer.readLine(in, buf) && buf.length() > 0);
        return initial;
    }

    protected void fileDownloaded(String fp, InetAddress addr) {
    }

    public URL getHostName() {
        return this.hostName;
    }

    private class Task
    implements Runnable {
        private final Socket sock;

        public Task(Socket sock) {
            this.sock = sock;
        }

        private byte[] getBytes(String path) throws IOException {
            byte[] bytes = null;
            int i = 0;
            while (i < ClassServer.this.resourceFinders.size()) {
                ResourceFinder finder = ClassServer.this.resourceFinders.get(i);
                bytes = finder.find(path);
                if (bytes != null) {
                    return bytes;
                }
                ++i;
            }
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)("requested file: '" + path + "' was not found."));
            return null;
        }

        private char decode(String s, int i) {
            return (char)Integer.parseInt(s.substring(i + 1, i + 3), 16);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getCanonicalizedPath(String path) {
            try {
                int i;
                if (path.regionMatches(true, 0, "http://", 0, 7)) {
                    i = path.indexOf(47, 7);
                    path = i < 0 ? "/" : path.substring(i);
                }
                i = path.indexOf(37);
                while (i >= 0) {
                    char c = this.decode(path, i);
                    int n = 3;
                    if ((c & 0x80) != 0) {
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                n = 6;
                                c = (char)((c & 0x1F) << 6 | this.decode(path, i + 3) & 0x3F);
                                break;
                            }
                            case 14: {
                                n = 9;
                                c = (char)((c & 0xF) << 12 | (this.decode(path, i + 3) & 0x3F) << 6 | this.decode(path, i + 6) & 0x3F);
                                break;
                            }
                            default: {
                                return null;
                            }
                        }
                    }
                    path = String.valueOf(path.substring(0, i)) + c + path.substring(i + n);
                    i = path.indexOf(37, i + 1);
                }
            }
            catch (Exception exception) {
                return null;
            }
            if (path.length() != 0 && path.charAt(0) == '/') {
                return path.substring(1);
            }
            return null;
        }

        @Override
        public void run() {
            block42: {
                byte[] bytes;
                String path;
                boolean get;
                DataOutputStream out;
                block41: {
                    block40: {
                        String req;
                        block39: {
                            block38: {
                                block37: {
                                    out = new DataOutputStream(this.sock.getOutputStream());
                                    try {
                                        req = ClassServer.getInput(this.sock, true);
                                    }
                                    catch (Exception e) {
                                        OseeLog.log(Activator.class, (Level)Level.INFO, (String)"reading request", (Throwable)e);
                                        try {
                                            this.sock.close();
                                        }
                                        catch (IOException iOException) {}
                                        return;
                                    }
                                    if (req != null) break block37;
                                    try {
                                        this.sock.close();
                                    }
                                    catch (IOException iOException) {}
                                    return;
                                }
                                if (!req.startsWith("SHUTDOWN *")) break block38;
                                out.writeBytes("HTTP/1.0 403 Forbidden\r\n\r\n");
                                out.flush();
                                try {
                                    this.sock.close();
                                }
                                catch (IOException iOException) {}
                                return;
                            }
                            get = req.startsWith("GET ");
                            if (get || req.startsWith("HEAD ")) break block39;
                            OseeLog.log(Activator.class, (Level)Level.FINE, (String)"bad request \"{0}\" from {1}:{2}");
                            out.writeBytes("HTTP/1.0 400 Bad Request\r\n\r\n");
                            out.flush();
                            try {
                                this.sock.close();
                            }
                            catch (IOException iOException) {}
                            return;
                        }
                        path = req.substring(get ? 4 : 5);
                        int i = path.indexOf(32);
                        if (i > 0) {
                            path = path.substring(0, i);
                        }
                        if ((path = this.getCanonicalizedPath(path)) != null) break block40;
                        OseeLog.log(Activator.class, (Level)Level.FINE, (String)"bad request \"{0}\" from {1}:{2}");
                        out.writeBytes("HTTP/1.0 400 Bad Request\r\n\r\n");
                        out.flush();
                        try {
                            this.sock.close();
                        }
                        catch (IOException iOException) {}
                        return;
                    }
                    OseeLog.log(Activator.class, (Level)Level.FINER, (String)(get ? "{0} requested from {1}:{2}" : "{0} probed from {1}:{2}"));
                    try {
                        bytes = this.getBytes(path);
                    }
                    catch (Exception e) {
                        OseeLog.log(Activator.class, (Level)Level.WARNING, (String)"getting bytes", (Throwable)e);
                        out.writeBytes("HTTP/1.0 500 Internal Error\r\n\r\n");
                        out.flush();
                        try {
                            this.sock.close();
                        }
                        catch (IOException iOException) {}
                        return;
                    }
                    if (bytes != null) break block41;
                    OseeLog.logf(Activator.class, (Level)Level.FINE, (String)"%s not found", (Object[])new Object[]{path});
                    out.writeBytes("HTTP/1.0 404 Not Found\r\n\r\n");
                    out.flush();
                    try {
                        this.sock.close();
                    }
                    catch (IOException iOException) {}
                    return;
                }
                try {
                    try {
                        out.writeBytes("HTTP/1.0 200 OK\r\n");
                        out.writeBytes("Content-Length: " + bytes.length + "\r\n");
                        out.writeBytes("Content-Type: application/java\r\n\r\n");
                        if (get) {
                            out.write(bytes);
                        }
                        out.flush();
                        if (!get) break block42;
                        ClassServer.this.fileDownloaded(path, this.sock.getInetAddress());
                    }
                    catch (Exception e) {
                        OseeLog.log(Activator.class, (Level)Level.INFO, (String)"writing response", (Throwable)e);
                        try {
                            this.sock.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.sock.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                this.sock.close();
            }
            catch (IOException iOException) {}
        }
    }
}

