/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util;

import java.util.Collection;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.IResourceRegistry;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.graphics.FontData;

public class DataTypeTransformation {
    public static Point toDraw2dPoint(org.eclipse.graphiti.mm.algorithms.styles.Point pictogramsPoint) {
        Point ret = new Point();
        DataTypeTransformation.syncToDraw2dPoint(pictogramsPoint, ret);
        return ret;
    }

    public static Bendpoint toDraw2dBendPoint(org.eclipse.graphiti.mm.algorithms.styles.Point pictogramsPoint) {
        AbsoluteBendpoint ret = new AbsoluteBendpoint(DataTypeTransformation.toDraw2dPoint(pictogramsPoint));
        return ret;
    }

    public static void syncToDraw2dPoint(org.eclipse.graphiti.mm.algorithms.styles.Point pictogramsPoint, Point draw2dPoint) {
        if (pictogramsPoint != null) {
            draw2dPoint.x = pictogramsPoint.getX();
            draw2dPoint.y = pictogramsPoint.getY();
        }
    }

    public static org.eclipse.swt.graphics.Color toSwtColor(IResourceRegistry rr, Color pictogramsColor) {
        if (pictogramsColor != null) {
            return rr.getSwtColor(pictogramsColor.getRed(), pictogramsColor.getGreen(), pictogramsColor.getBlue());
        }
        return rr.getSwtColor(100, 100, 100);
    }

    public static org.eclipse.swt.graphics.Color toSwtColor(IResourceRegistry rr, IColorConstant color) {
        if (color != null) {
            return rr.getSwtColor(color.getRed(), color.getGreen(), color.getBlue());
        }
        return rr.getSwtColor(100, 100, 100);
    }

    public static Color toPictogramsColor(org.eclipse.swt.graphics.Color swtColor, Diagram diagram) {
        return Graphiti.getGaService().manageColor(diagram, swtColor.getRed(), swtColor.getGreen(), swtColor.getBlue());
    }

    public static PointList toDraw2dPointList(Collection<org.eclipse.graphiti.mm.algorithms.styles.Point> points) {
        PointList pointList = new PointList();
        for (org.eclipse.graphiti.mm.algorithms.styles.Point dtp : points) {
            pointList.addPoint(dtp.getX(), dtp.getY());
        }
        return pointList;
    }

    public static org.eclipse.swt.graphics.Font syncToSwtFont(Font pictogramFont, org.eclipse.swt.graphics.Font swtFont) {
        FontData fontDataFromSwtFont;
        org.eclipse.swt.graphics.Font ret = swtFont;
        FontData fontDataFromPictogramFont = DataTypeTransformation.toFontData(pictogramFont);
        if (!fontDataFromPictogramFont.equals((Object)(fontDataFromSwtFont = swtFont.getFontData()[0]))) {
            ret = DataTypeTransformation.toSwtFont(pictogramFont);
        }
        return ret;
    }

    public static Font toPictogramsFont(Diagram diagram, org.eclipse.swt.graphics.Font swtFont) {
        FontData fontData = swtFont.getFontData()[0];
        Font ret = DataTypeTransformation.toPictogramsFont(diagram, fontData);
        return ret;
    }

    public static Font toPictogramsFont(Diagram diagram, FontData fontData) {
        if (fontData == null) {
            return null;
        }
        String name = fontData.getName();
        int height = fontData.getHeight();
        boolean italic = (fontData.getStyle() & 2) != 0;
        boolean bold = (fontData.getStyle() & 1) != 0;
        Font ret = Graphiti.getGaService().manageFont(diagram, name, height, italic, bold);
        return ret;
    }

    public static org.eclipse.swt.graphics.Font toSwtFont(Font pictogramFont) {
        FontData fontData = DataTypeTransformation.toFontData(pictogramFont);
        return new org.eclipse.swt.graphics.Font(null, new FontData[]{fontData});
    }

    public static FontData toFontData(Font pictogramFont) {
        FontData fontData;
        if (pictogramFont != null) {
            int style = 0;
            if (pictogramFont.isItalic()) {
                style |= 2;
            }
            if (pictogramFont.isBold()) {
                style |= 1;
            }
            int size = pictogramFont.getSize();
            String name = pictogramFont.getName();
            fontData = new FontData(name, size, style);
        } else {
            fontData = new FontData();
        }
        return fontData;
    }

    public static int toDraw2dLineStyle(LineStyle lineStyle) {
        int draw2dLineStyle = 1;
        if (lineStyle == LineStyle.DASH) {
            draw2dLineStyle = 2;
        } else if (lineStyle == LineStyle.DASHDOT) {
            draw2dLineStyle = 4;
        } else if (lineStyle == LineStyle.DASHDOTDOT) {
            draw2dLineStyle = 5;
        } else if (lineStyle == LineStyle.DOT) {
            draw2dLineStyle = 3;
        } else if (lineStyle == LineStyle.SOLID) {
            draw2dLineStyle = 1;
        }
        return draw2dLineStyle;
    }
}

