/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ListDialogSortableFiltered
extends MessageDialog {
    protected Label statusLabel;
    protected Button okButton;
    private FilteredTree treeViewer;
    private Object input;
    private final IContentProvider contentProvider;
    private final IBaseLabelProvider labelProvider;
    protected PatternFilter patternFilter;
    private Collection<? extends Object> initialSelections;
    private ViewerComparator viewerComparator;
    private boolean multiSelect = true;
    protected final ViewerSorter viewerSorter;
    List<Object> selected = new ArrayList<Object>();

    public ListDialogSortableFiltered(String dialogTitle, String dialogMessage, PatternFilter patternFilter, IContentProvider contentProvider, IBaseLabelProvider labelProvider, ViewerSorter viewerSorter) {
        super(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, 0, new String[]{XViewerText.get("button.ok"), XViewerText.get("button.cancel")}, 0);
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.patternFilter = patternFilter;
        this.viewerSorter = viewerSorter;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void createPreCustomArea(Composite parent) {
    }

    protected void createPostCustomArea(Composite parent) {
    }

    public void setInput(Object input) {
        this.input = input;
        if (this.treeViewer != null) {
            this.treeViewer.getViewer().setInput(input);
        }
    }

    public void setInitialSelections(Collection<? extends Object> initialSelections) {
        this.initialSelections = initialSelections;
        if (this.treeViewer != null) {
            StructuredSelection selection = new StructuredSelection(initialSelections.toArray());
            this.treeViewer.getViewer().setSelection((ISelection)selection);
        }
    }

    public <T> Collection<T> getSelected() {
        return this.selected;
    }

    public <T> T getSelectedFirst() {
        if (this.selected.size() > 0) {
            return (T)this.selected.iterator().next();
        }
        return null;
    }

    protected Control createCustomArea(Composite parent) {
        this.statusLabel = new Label(parent, 0);
        this.statusLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.createPreCustomArea(parent);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)XViewerLib.getZeroMarginLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new FilteredTree(comp, (this.multiSelect ? 2 : 0) | 8 | 0x100 | 0x200 | 0x800, this.patternFilter, true);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 500;
        this.treeViewer.getViewer().getTree().setLayoutData((Object)gd);
        this.treeViewer.getViewer().setContentProvider(this.contentProvider);
        this.treeViewer.getViewer().setLabelProvider(this.labelProvider);
        this.treeViewer.getViewer().setSorter(this.viewerSorter);
        this.treeViewer.getViewer().setAutoExpandLevel(0);
        this.treeViewer.setQuickSelectionMode(true);
        if (this.viewerComparator != null) {
            this.treeViewer.getViewer().setComparator(this.viewerComparator);
        }
        this.treeViewer.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ListDialogSortableFiltered.this.updateSelected();
                ListDialogSortableFiltered.this.updateStatusLabel();
            }
        });
        final ListDialogSortableFiltered dialog = this;
        this.treeViewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ListDialogSortableFiltered.this.updateSelected();
                dialog.okPressed();
            }
        });
        this.treeViewer.getFilterControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                List<TreeItem> visibleItems = ListDialogSortableFiltered.this.getVisibleItems();
                if (visibleItems.size() == 1) {
                    ListDialogSortableFiltered.this.treeViewer.getViewer().setSelection((ISelection)new StructuredSelection(new Object[]{((TreeItem)visibleItems.iterator().next()).getData()}));
                    ListDialogSortableFiltered.this.getButton(0).setEnabled(true);
                }
            }
        });
        if (this.input != null) {
            this.treeViewer.getViewer().setInput(this.input);
        }
        if (this.initialSelections != null) {
            this.setInitialSelections(this.initialSelections);
        }
        this.updateStatusLabel();
        return parent;
    }

    public List<TreeItem> getVisibleItems() {
        ArrayList<TreeItem> toReturn = new ArrayList<TreeItem>();
        this.getVisibleItems(toReturn, this.treeViewer.getViewer().getTree().getItems());
        return toReturn;
    }

    private void getVisibleItems(List<TreeItem> toReturn, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            toReturn.add(item);
            if (item.getExpanded()) {
                this.getVisibleItems(toReturn, item.getItems());
            }
            ++n2;
        }
    }

    protected void updateSelected() {
        this.selected.clear();
        Object[] objectArray = ((StructuredSelection)this.treeViewer.getViewer().getSelection()).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.selected.add(obj);
            ++n2;
        }
    }

    protected void updateStatusLabel() {
        Boolean result = this.isComplete();
        if (!result.booleanValue()) {
            this.statusLabel.setText("Error!");
        } else {
            this.statusLabel.setText("");
        }
        this.statusLabel.getParent().layout();
        this.updateButtons();
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
        return c;
    }

    protected Boolean isComplete() {
        return Boolean.TRUE;
    }

    private void updateButtons() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.isComplete().booleanValue());
        }
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public void setPatternFilter(PatternFilter patternFilter) {
        this.patternFilter = patternFilter;
    }

    public FilteredTree getTreeViewer() {
        return this.treeViewer;
    }

    public void setComparator(ViewerComparator viewerComparator) {
        this.viewerComparator = viewerComparator;
    }
}

