/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.publishing.DataRightContentBuilder;
import org.eclipse.osee.framework.core.publishing.DataRightResult;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Message;

public class WordRenderUtil {
    public static Optional<DataRightContentBuilder> getDataRights(List<PublishingArtifact> artifacts, BranchId branchId, boolean recurse, boolean notHistorical, String overrideClassification, ArtifactAcceptor descendantArtifactAcceptor, DataRightsProvider dataRightsProvider) {
        assert (Objects.nonNull(branchId)) : "WordRenderUtil::getDataRights, parameter \"branchId\" cannot be null.";
        assert (Objects.nonNull(dataRightsProvider)) : "WordRenderUtil::getDataRights, parameter \"dataRightsProvider\" cannot be null.";
        try {
            if (Objects.isNull(artifacts) || artifacts.isEmpty()) {
                return Optional.empty();
            }
            List<PublishingArtifact> allArtifacts = WordRenderUtil.getPublishArtifacts(artifacts, recurse, notHistorical, descendantArtifactAcceptor);
            if (allArtifacts.isEmpty()) {
                return Optional.empty();
            }
            DataRightResult dataRightResult = dataRightsProvider.getDataRights(branchId, overrideClassification, allArtifacts.stream().map(ArtifactId::create).collect(Collectors.toList()));
            DataRightContentBuilder dataRightContentBuilder = new DataRightContentBuilder(dataRightResult);
            return Optional.of(dataRightContentBuilder);
        }
        catch (Exception e) {
            throw new OseeCoreException(new Message().title((CharSequence)"WordRenderUtil::getDataRights, failed to obtain data rights for publishing artifacts.").indentInc().segment((CharSequence)"Publishing Branch Identifier", (Object)branchId).segment((CharSequence)"Recursive", (Object)recurse).segment((CharSequence)"Not Historical", (Object)notHistorical).segment((CharSequence)"Override Classification", (Object)overrideClassification).segment((CharSequence)"Top Level Publishing Artifacts", artifacts, Id::getId).reasonFollows((Throwable)e).toString(), (Throwable)e);
        }
    }

    public static WordCoreUtil.pageType getPageOrientation(PublishingArtifact artifact) {
        WordCoreUtil.pageType defaultPageType = WordCoreUtil.pageType.getDefault();
        try {
            if (Objects.isNull(artifact) || artifact.isInvalid()) {
                return defaultPageType;
            }
            if (!artifact.isAttributeTypeValid(CoreAttributeTypes.PageOrientation)) {
                return defaultPageType;
            }
            String pageTypeString = artifact.getSoleAttributeAsString(CoreAttributeTypes.PageOrientation, defaultPageType.name());
            return WordCoreUtil.pageType.fromString(pageTypeString);
        }
        catch (Exception exception) {
            return defaultPageType;
        }
    }

    public static List<PublishingArtifact> getPublishArtifacts(List<PublishingArtifact> artifacts, boolean recursive, boolean notHistorical, ArtifactAcceptor descendantArtifactAcceptor) {
        if (Objects.isNull(artifacts) || artifacts.isEmpty()) {
            return null;
        }
        Iterator<PublishingArtifact> artifactIterator = artifacts.iterator();
        PublishingArtifact artifact = artifacts.iterator().next();
        artifact.setStartOfSection();
        artifact.clearEndOfSection();
        artifact.setOutlineLevel(0);
        while (artifactIterator.hasNext()) {
            artifact = artifactIterator.next();
            artifact.setStartOfSection();
            artifact.clearEndOfSection();
            artifact.setOutlineLevel(0);
        }
        artifact.setEndOfSection();
        LinkedList<PublishingArtifact> allArtifacts = new LinkedList<PublishingArtifact>();
        HashSet<ArtifactId> checkSet = recursive ? new HashSet<ArtifactId>() : null;
        WordRenderUtil.loadChildrenRecursive(allArtifacts, checkSet, artifacts, 0, recursive, notHistorical, descendantArtifactAcceptor);
        return allArtifacts;
    }

    private static void loadChildrenRecursive(List<PublishingArtifact> allArtifacts, Set<ArtifactId> checkSet, List<PublishingArtifact> levelArtifacts, int outlineLevel, boolean recurse, boolean notHistorical, ArtifactAcceptor descendantArtifactAcceptor) {
        Iterator<PublishingArtifact> artifactIterator = levelArtifacts.iterator();
        PublishingArtifact artifact = null;
        while (artifactIterator.hasNext()) {
            artifact = artifactIterator.next();
            if (Objects.isNull(artifact) || artifact.isInvalid() || Objects.nonNull(checkSet) && checkSet.contains(artifact)) continue;
            if (outlineLevel > 0 && Objects.nonNull(descendantArtifactAcceptor) && !descendantArtifactAcceptor.isOk(artifact)) {
                checkSet.add(artifact);
                continue;
            }
            if (Objects.nonNull(checkSet)) {
                checkSet.add(artifact);
            }
            allArtifacts.add(artifact);
            if (!recurse || notHistorical && artifact.isHistorical()) continue;
            WordRenderUtil.loadChildrenRecursive(allArtifacts, checkSet, artifact.getChildrenAsPublishingArtifacts(), outlineLevel + 1, recurse, notHistorical, descendantArtifactAcceptor);
        }
    }

    @FunctionalInterface
    public static interface ArtifactAcceptor {
        default public ArtifactAcceptor isKo(ArtifactAcceptor baseArtifactAcceptor) {
            Objects.requireNonNull(baseArtifactAcceptor);
            return t -> !this.isOk(t);
        }

        public boolean isOk(ArtifactReadable var1);
    }

    @FunctionalInterface
    public static interface DataRightsProvider {
        public DataRightResult getDataRights(BranchId var1, String var2, List<ArtifactId> var3);
    }
}

