/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.resources.AnnotationResource;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;

@Swagger
public class DispoItemResource {
    private final DispoApi dispoApi;
    private final BranchId branch;
    private final String setId;

    public DispoItemResource(DispoApi dispoApi, BranchId branch, String setId) {
        this.dispoApi = dispoApi;
        this.branch = branch;
        this.setId = setId;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get all Dispo Items")
    @Tag(name="items")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public Iterable<DispoItem> getAllDispoItems(@Parameter(description="Is detailed", required=true) @QueryParam(value="isDetailed") Boolean isDetailed) {
        List<DispoItem> allDispoItems = this.dispoApi.getDispoItems(this.branch, this.setId, isDetailed);
        return allDispoItems;
    }

    @Path(value="{itemId}")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get a specific Dispositionable Item given a itemId")
    @Tag(name="item")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Found Dispositionable Item"), @ApiResponse(responseCode="404", description="Not Found. Could not find any Dispositionable Items")})
    public DispoItem getDispoItemsById(@Parameter(description="TThe Id of the Dispositionable Item to search for", required=true) @PathParam(value="itemId") String itemId) {
        return this.dispoApi.getDispoItemById(this.branch, itemId);
    }

    @Path(value="getDispoItemId")
    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Operation(summary="Get an Dispo Item ID given an Item name")
    @Tag(name="item")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Found Item ID"), @ApiResponse(responseCode="404", description="Not Found. Could not find Item ID")})
    public String getDispoItemId(@Parameter(description="The Item name", required=true) @FormParam(value="name") String itemName) {
        return this.dispoApi.getDispoItemIdByName(this.branch, this.setId, itemName);
    }

    @Path(value="{itemId}")
    @PUT
    @Consumes(value={"application/json"})
    @Operation(summary="Edit a specific Dispositionable Item given a itemId and new Dispositionable Item Data")
    @Tag(name="item")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Found Dispositionable Item"), @ApiResponse(responseCode="404", description="Not Found. Could not any Dispositionable Items")})
    public Response putDispoItem(@PathParam(value="itemId") String itemId, DispoItemData newDispoItem, @Parameter(description="The Username", required=true) @QueryParam(value="userName") String userName, @Parameter(description="Assign User", required=true) @QueryParam(value="assignUser") boolean assignUser) {
        boolean wasEdited = this.dispoApi.editDispoItem(this.branch, itemId, newDispoItem, userName, assignUser);
        Response response = wasEdited ? Response.status((Response.Status)Response.Status.OK).build() : Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)"Dispositonable Item was not found").build();
        return response;
    }

    @Path(value="{itemId}")
    @DELETE
    @Operation(summary="Delete a specific Dispositionable Item given a itemId")
    @Tag(name="item")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK. Deleted Dispositionable Item"), @ApiResponse(responseCode="404", description="Not Found. Could not any Dispositionable Items")})
    public Response deleteDispoItem(@Parameter(description="The Id of the Dispositionable Item to search for", required=true) @PathParam(value="itemId") String itemId, @Parameter(description="The Username", required=true) @QueryParam(value="userName") String userName) {
        boolean wasEdited = this.dispoApi.deleteDispoItem(this.branch, itemId, userName);
        Response response = wasEdited ? Response.status((Response.Status)Response.Status.OK).build() : Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Dispositonable Item was not found").build();
        return response;
    }

    @Path(value="{itemId}/annotation/")
    @Operation(summary="Get Annotation")
    @Tag(name="annotation")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public AnnotationResource getAnnotation(@Parameter(description="The Id of the Dispositionable Item", required=true) @PathParam(value="itemId") String itemId) {
        return new AnnotationResource(this.dispoApi, this.branch, this.setId, itemId);
    }
}

