/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.state;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.WorkState;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.api.workflow.state.IAtsWorkStateFactory;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.Id;

public class StateManagerUtility {
    public static void initializeStateMachine(IAtsStateManager stateMgr, IStateToken workPage, List<? extends AtsUser> assignees, AtsUser currentUser, IAtsChangeSet changes) {
        stateMgr.createState(workPage.getName());
        stateMgr.setCurrentStateName(workPage.getName());
        if (assignees == null) {
            assignees = new LinkedList<AtsUser>();
        }
        if (workPage.isWorking()) {
            if (assignees.isEmpty()) {
                if (currentUser.notEqual((Id)AtsCoreUsers.SYSTEM_USER)) {
                    stateMgr.setAssignees(workPage.getName(), workPage.getStateType(), Arrays.asList(currentUser));
                } else {
                    stateMgr.setAssignees(workPage.getName(), workPage.getStateType(), Arrays.asList(AtsCoreUsers.UNASSIGNED_USER));
                }
            } else if (currentUser.equals((Object)AtsCoreUsers.UNASSIGNED_USER)) {
                stateMgr.setAssignees(workPage.getName(), workPage.getStateType(), Arrays.asList(AtsCoreUsers.UNASSIGNED_USER));
            } else {
                stateMgr.setAssignees(workPage.getName(), workPage.getStateType(), assignees);
            }
        }
    }

    public static Result isDirtyResult(IAtsWorkItem workItem, IAtsStateManager stateMgr, IAttributeResolver attrResolver, IAtsWorkStateFactory workStateFactory) {
        if (attrResolver.getAttributeCount(workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentState) == 0) {
            return new Result(true, "StateManager: Current State new");
        }
        if (!workStateFactory.toStoreStr(stateMgr, stateMgr.getCurrentStateNameInternal()).equals(attrResolver.getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentState, null))) {
            return new Result(true, "StateManager: Current State modified");
        }
        for (String stateName : stateMgr.getVisitedStateNames()) {
            if (stateName.equals(stateMgr.getCurrentStateNameInternal())) continue;
            boolean found = false;
            for (String storedStateXml : attrResolver.getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.State)) {
                WorkState storedState = workStateFactory.fromStoreStr(storedStateXml);
                if (!stateName.equals(storedState.getName())) continue;
                found = true;
                String currentStateXml = workStateFactory.toStoreStr(stateMgr, stateName);
                if (currentStateXml.equals(storedStateXml)) continue;
                return new Result(true, String.format("StateManager: State [%s] modified was [%s] is [%s]", stateName, storedStateXml, currentStateXml));
            }
            if (found) continue;
            return new Result(true, String.format("StateManager: State [%s] added", stateName));
        }
        return Result.FalseResult;
    }
}

