/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.notify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationCollector;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.notify.AtsWorkItemNotificationEvent;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewRoleManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.ReviewRoleType;
import org.eclipse.osee.ats.api.review.UserRole;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.users.AtsUsersUtility;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.EmailUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class WorkItemNotificationProcessor {
    private final Log logger;
    private final IAtsUserService userService;
    private final IAttributeResolver attrResolver;
    private final AtsApi atsApi;

    public WorkItemNotificationProcessor(AtsApi atsApi) {
        this.logger = atsApi.getLogger();
        this.atsApi = atsApi;
        this.userService = atsApi.getUserService();
        this.attrResolver = atsApi.getAttributeResolver();
    }

    public void run(AtsNotificationCollector notifications, AtsWorkItemNotificationEvent event) {
        Set types = event.getNotifyTypes();
        ArrayList<AtsUser> notifyUsers = new ArrayList<AtsUser>();
        AtsUser fromUser = AtsCoreUsers.SYSTEM_USER;
        if (Strings.isValid((String)event.getFromUserId())) {
            fromUser = this.userService.getUserByUserId(event.getFromUserId());
        }
        for (String userId : event.getUserIds()) {
            notifyUsers.add(this.userService.getUserByUserId(userId));
        }
        for (Long id : event.getIds()) {
            IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(id);
            if (workItem == null) {
                this.logger.error("In WorkItemNotificationProcessor.run, the local variable \\\"workItem\\\" is null which is dereferenced", new Object[0]);
                continue;
            }
            if (types.contains(AtsNotifyType.Originator)) {
                try {
                    AtsUser originator = workItem.getCreatedBy();
                    if (originator != null && originator.isActive()) {
                        if (!EmailUtil.isEmailValid((String)originator.getEmail()) && !AtsCoreUsers.isAtsCoreUser((AtsUser)originator)) {
                            this.logger.info("Email [%s] invalid for user [%s]", new Object[]{originator.getEmail(), originator.getName()});
                        } else if (fromUser.notEqual((Id)originator)) {
                            String cancelUrl = this.getCancelUrl(notifications, workItem, this.atsApi);
                            String url = this.getUrl(workItem, this.atsApi);
                            notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((AtsUser)this.getFromUser(event), Arrays.asList(originator), (String)this.getIdString(workItem), (String)AtsNotifyType.Originator.name(), (String)url, (String)cancelUrl, (String)String.format("You have been set as the originator of [%s] state [%s] titled [%s]", workItem.getArtifactTypeName(), workItem.getCurrentStateName(), workItem.getName())));
                        }
                    }
                }
                catch (OseeCoreException ex) {
                    this.logger.error((Throwable)ex, "Error processing Originator for workItem [%s] and event [%s]", new Object[]{workItem.toStringWithId(), event.toString()});
                }
            }
            if (types.contains(AtsNotifyType.Assigned)) {
                try {
                    Collection<Object> assignees = new HashSet<AtsUser>();
                    if (!notifyUsers.isEmpty()) {
                        assignees.addAll(notifyUsers);
                    } else {
                        assignees.addAll(workItem.getStateMgr().getAssignees());
                    }
                    assignees.remove(fromUser);
                    assignees = AtsUsersUtility.getValidEmailUsers(assignees);
                    assignees = AtsUsersUtility.getActiveEmailUsers(assignees);
                    if (assignees.size() > 0) {
                        notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((AtsUser)this.getFromUser(event), assignees, (String)this.getIdString(workItem), (String)AtsNotifyType.Assigned.name(), (String)this.getUrl(workItem, this.atsApi), (String)this.getCancelUrl(notifications, workItem, this.atsApi), (String)String.format("You have been set as the assignee of [%s] in state [%s] titled [%s]", workItem.getArtifactTypeName(), workItem.getCurrentStateName(), workItem.getName())));
                    }
                }
                catch (OseeCoreException ex) {
                    this.logger.error((Throwable)ex, "Error processing Assigned for workItem [%s] and event [%s]", new Object[]{workItem.toStringWithId(), event.toString()});
                }
            }
            if (types.contains(AtsNotifyType.Subscribed)) {
                try {
                    Collection<Object> subscribed = new HashSet<AtsUser>();
                    subscribed.addAll(this.getSubscribed(workItem));
                    subscribed = AtsUsersUtility.getValidEmailUsers(subscribed);
                    subscribed = AtsUsersUtility.getActiveEmailUsers(subscribed);
                    if (subscribed.size() > 0) {
                        notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((AtsUser)this.getFromUser(event), subscribed, (String)this.getIdString(workItem), (String)AtsNotifyType.Subscribed.name(), (String)this.getUrl(workItem, this.atsApi), (String)this.getCancelUrl(notifications, workItem, this.atsApi), (String)String.format("[%s] titled [%s] transitioned to [%s] and you subscribed for notification.", workItem.getArtifactTypeName(), workItem.getName(), workItem.getCurrentStateName())));
                    }
                }
                catch (OseeCoreException ex) {
                    this.logger.error((Throwable)ex, "Error processing Subscribed for workItem [%s] and event [%s]", new Object[]{workItem.toStringWithId(), event.toString()});
                }
            }
            try {
                AtsUser originator;
                boolean stateTypeIsCompletedOrCancelled;
                StateDefinition stateDefinition = workItem.getStateDefinition();
                StateType stateType = stateDefinition.getStateType();
                boolean notificationTypeIsCompletedOrCancelled = types.contains(AtsNotifyType.Cancelled) || types.contains(AtsNotifyType.Completed);
                boolean bl = stateTypeIsCompletedOrCancelled = stateType.isCompleted() || stateType.isCancelled();
                if (notificationTypeIsCompletedOrCancelled && !workItem.isTask() && stateTypeIsCompletedOrCancelled && (originator = workItem.getCreatedBy()).isActive()) {
                    if (!EmailUtil.isEmailValid((String)originator.getEmail())) {
                        this.logger.info("Email [%s] invalid for user [%s]", new Object[]{originator.getEmail(), originator.getName()});
                    } else if (this.isOriginatorDifferentThanCancelledOrCompletedBy(workItem, fromUser, originator)) {
                        if (stateType.isCompleted()) {
                            notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((AtsUser)this.getFromUser(event), Arrays.asList(originator), (String)this.getIdString(workItem), (String)workItem.getCurrentStateName(), (String)this.getUrl(workItem, this.atsApi), (String)this.getCancelUrl(notifications, workItem, this.atsApi), (String)String.format("[%s] titled [%s] is [%s]", workItem.getArtifactTypeName(), workItem.getName(), workItem.getCurrentStateName())));
                        }
                        if (stateType.isCancelled()) {
                            notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((AtsUser)this.getFromUser(event), Arrays.asList(originator), (String)this.getIdString(workItem), (String)workItem.getCurrentStateName(), (String)this.getUrl(workItem, this.atsApi), (String)this.getCancelUrl(notifications, workItem, this.atsApi), (String)String.format("[%s] titled [%s] was [%s] from the [%s] state on [%s].<br>Reason: [%s]", workItem.getArtifactTypeName(), workItem.getName(), workItem.getCurrentStateName(), workItem.getCancelledFromState(), DateUtil.getMMDDYYHHMM((Date)workItem.getCancelledDate()), workItem.getCancelledReason())));
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex, "Error processing Completed or Cancelled for workItem [%s] and event [%s]", new Object[]{workItem.toStringWithId(), event.toString()});
            }
            if (types.contains(AtsNotifyType.Peer_Reviewers_Completed) && workItem instanceof IAtsPeerToPeerReview) {
                try {
                    IAtsPeerReviewRoleManager roleMgr = ((IAtsPeerToPeerReview)workItem).getRoleManager();
                    Collection<Object> authorModerator = new ArrayList();
                    for (UserRole role : roleMgr.getUserRoles()) {
                        if (!role.getRole().getReviewRoleType().matches(new Id[]{ReviewRoleType.Author, ReviewRoleType.Moderator})) continue;
                        authorModerator.add(this.userService.getUserByUserId(role.getUserId()));
                    }
                    authorModerator = AtsUsersUtility.getValidEmailUsers(authorModerator);
                    if ((authorModerator = AtsUsersUtility.getActiveEmailUsers(authorModerator)).size() > 0) {
                        notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((AtsUser)this.getFromUser(event), authorModerator, (String)this.getIdString(workItem), (String)AtsNotifyType.Peer_Reviewers_Completed.name(), (String)String.format("You are Author/Moderator of [%s] titled [%s] which has been reviewed by all reviewers", workItem.getArtifactTypeName(), workItem.getName())));
                    }
                }
                catch (OseeCoreException ex) {
                    this.logger.error((Throwable)ex, "Error processing Peer_Reviewers_Completed for workItem [%s] and event [%s]", new Object[]{workItem.toStringWithId(), event.toString()});
                }
            }
            if (!types.contains(AtsNotifyType.SubscribedTeamOrAi)) continue;
            try {
                if (!workItem.isTeamWorkflow()) continue;
                IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
                Collection subscribedUsers = new HashSet();
                IAtsTeamDefinition teamDef = teamWf.getTeamDefinition();
                subscribedUsers.addAll(this.atsApi.getTeamDefinitionService().getSubscribed(teamDef));
                if (subscribedUsers.size() > 0) {
                    notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((AtsUser)AtsCoreUsers.SYSTEM_USER, subscribedUsers, (String)this.getIdString((IAtsWorkItem)teamWf), (String)"Workflow Creation", (String)this.getUrl(workItem, this.atsApi), (String)this.getCancelUrl(notifications, workItem, this.atsApi), (String)("You have subscribed for email notification for Team \"" + teamWf.getTeamDefinition().getName() + "\"; New Team Workflow created with title \"" + teamWf.getName() + "\"")));
                }
                for (IAtsActionableItem aia : teamWf.getActionableItems()) {
                    subscribedUsers = this.atsApi.getActionableItemService().getSubscribed(aia);
                    if (subscribedUsers.size() <= 0) continue;
                    notifications.addNotificationEvent(AtsNotificationEventFactory.getNotificationEvent((AtsUser)AtsCoreUsers.SYSTEM_USER, subscribedUsers, (String)this.getIdString((IAtsWorkItem)teamWf), (String)"Workflow Creation", (String)this.getUrl(workItem, this.atsApi), (String)this.getCancelUrl(notifications, workItem, this.atsApi), (String)("You have subscribed for email notification for Actionable Item \"" + teamWf.getTeamDefinition().getName() + "\"; New Team Workflow created with title \"" + teamWf.getName() + "\"")));
                }
            }
            catch (OseeCoreException ex) {
                this.logger.error((Throwable)ex, "Error processing SubscribedTeamOrAi for workItem [%s] and event [%s]", new Object[]{workItem.toStringWithId(), event.toString()});
            }
        }
    }

    public List<AtsUser> getSubscribed(IAtsWorkItem workItem) {
        ArrayList<AtsUser> arts = new ArrayList<AtsUser>();
        for (ArtifactId art : this.atsApi.getRelationResolver().getRelated((ArtifactId)workItem.getStoreObject(), AtsRelationTypes.SubscribedUser_User)) {
            arts.add(this.userService.getUserByUserId((String)this.atsApi.getAttributeResolver().getSoleAttributeValue(art, (AttributeTypeToken)CoreAttributeTypes.UserId, null)));
        }
        return arts;
    }

    private boolean isOriginatorDifferentThanCancelledOrCompletedBy(IAtsWorkItem workItem, AtsUser fromUser, AtsUser originator) {
        boolean different = true;
        if (fromUser.equals((Object)originator)) {
            different = false;
        } else if (workItem.getCancelledBy() != null && originator.equals((Object)workItem.getCancelledBy())) {
            different = false;
        } else if (workItem.getCompletedBy() != null && originator.equals((Object)workItem.getCompletedBy())) {
            different = false;
        }
        return different;
    }

    private String getCancelUrl(AtsNotificationCollector notifications, IAtsWorkItem workItem, AtsApi atsApi) {
        if (notifications.isIncludeCancelHyperlink()) {
            return atsApi.getWorkItemService().getCancelUrl(workItem, atsApi);
        }
        return "";
    }

    private String getUrl(IAtsWorkItem workItem, AtsApi atsApi) {
        String url = atsApi.getWorkItemService().getHtmlUrl(workItem, atsApi);
        if (Strings.isInValid((String)url)) {
            return "Not Configured";
        }
        return url;
    }

    private AtsUser getFromUser(AtsWorkItemNotificationEvent event) {
        AtsUser fromUser = AtsCoreUsers.SYSTEM_USER;
        if (Strings.isValid((String)event.getFromUserId())) {
            fromUser = this.userService.getUserByUserId(event.getFromUserId());
        }
        return fromUser;
    }

    private String getIdString(IAtsWorkItem workItem) {
        try {
            String legacyPcrId = (String)this.attrResolver.getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.LegacyPcrId, (Object)"");
            if (!legacyPcrId.equals("")) {
                return "ID: " + workItem.getAtsId() + " / LegacyId: " + legacyPcrId;
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Error getting legacyId pcr for workItem [%s]", new Object[]{workItem});
        }
        return "ID: " + workItem.getAtsId();
    }
}

