/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.action;

import com.fasterxml.jackson.core.JsonFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionToken;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workdef.IRelationResolver;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsActionService;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.api.workflow.IWorkItemListener;
import org.eclipse.osee.ats.api.workflow.NewActionData;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.core.action.ActionServiceOperations;
import org.eclipse.osee.ats.core.internal.state.StateManager;
import org.eclipse.osee.ats.core.internal.util.AtsIdProvider;
import org.eclipse.osee.ats.core.workflow.state.StateManagerUtility;
import org.eclipse.osee.ats.core.workflow.transition.TransitionManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsActionService
implements IAtsActionService {
    private final AtsApi atsApi;
    private IAtsTeamDefinition topTeamDefinition;
    private JsonFactory jsonFactory;
    private IWorkItemListener workItemListener;
    private static final Collection<INewActionListener> actionListeners = new ArrayList<INewActionListener>();

    public AtsActionService() {
        this(null);
    }

    public AtsActionService(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public ActionResult createAction(NewActionData data, IAtsChangeSet changes) {
        ActionResult result = null;
        try {
            AtsUser originator;
            String agileTeamStr;
            Object aTeam3;
            String sprintStr;
            String featureGroup;
            AtsUser asUser = this.atsApi.getUserService().getUserByUserId(data.getAsUserId());
            Conditions.assertNotNull((Object)asUser, (String)"As-User must be specified.", (Object[])new Object[0]);
            AtsUser createdBy = null;
            if (Strings.isValid((String)data.getCreatedByUserId())) {
                createdBy = this.atsApi.getUserService().getUserByUserId(data.getCreatedByUserId());
            }
            if (createdBy == null && Strings.isValid((String)data.getCreatedByUserId())) {
                createdBy = this.atsApi.getUserService().getUserByUserId(data.getCreatedByUserId());
            }
            Conditions.assertNotNull((Object)createdBy, (String)"Created-By must be specified.", (Object[])new Object[0]);
            Conditions.assertNotNullOrEmpty((Collection)data.getAiIds(), (String)"Actionable Items must be specified", (Object[])new Object[0]);
            LinkedList<IAtsActionableItem> ais = new LinkedList<IAtsActionableItem>();
            for (String aiId : data.getAiIds()) {
                IAtsActionableItem ai = (IAtsActionableItem)this.atsApi.getQueryService().getConfigItem(Long.valueOf(aiId));
                Conditions.assertNotNull((Object)ai, (String)"Actionable Item must be specified.", (Object[])new Object[0]);
                ais.add(ai);
            }
            Date needByDate = null;
            if (Strings.isNumeric((String)data.getNeedByDateLong())) {
                needByDate = new Date(Long.valueOf(data.getNeedByDateLong()));
            } else if (Strings.isValid((String)data.getNeedByDate())) {
                try {
                    needByDate = DateUtil.getDate((String)"yyyy-MM-dd", (String)data.getNeedByDate());
                }
                catch (Exception ex) {
                    throw new OseeCoreException("Error parsing date.  Must be mm/dd/yyyy.", (Throwable)ex);
                }
            }
            Date createdDate = null;
            createdDate = Strings.isNumeric((String)data.getCreatedDateLong()) ? new Date(Long.valueOf(data.getCreatedDateLong())) : new Date();
            result = this.createAction(asUser, data.getTitle(), data.getDescription(), data.getChangeType(), data.getPriority(), data.isValidationRequired(), needByDate, ais, createdDate, createdBy, Collections.emptyList(), changes);
            if (result.getResults().isErrors()) {
                return result;
            }
            if (Strings.isValid((String)data.getPoints())) {
                for (IAtsTeamWorkflow teamWf : result.getTeamWfs()) {
                    Object pointsAttrType;
                    IAgileTeam agileTeam = null;
                    if (Strings.isNumeric((String)data.getAgileTeam())) {
                        agileTeam = (IAgileTeam)this.atsApi.getQueryService().getConfigItem(ArtifactId.valueOf((String)data.getAgileTeam()));
                    }
                    if (agileTeam == null) {
                        IAtsTeamDefinition teamDef = teamWf.getTeamDefinition();
                        agileTeam = this.atsApi.getAgileService().getAgileTeam(teamDef);
                    }
                    if (Strings.isInValid((String)(pointsAttrType = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)agileTeam, (AttributeTypeToken)AtsAttributeTypes.PointsAttributeType, null)))) {
                        pointsAttrType = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamWf.getTeamDefinition(), (AttributeTypeToken)AtsAttributeTypes.PointsAttributeType, null);
                    }
                    if (!Strings.isValid((String)pointsAttrType)) {
                        throw new OseeArgumentException("Points Attribute Type must be specified on either Agile Team or Team Defintion to set Points", new Object[]{agileTeam.toStringWithId()});
                    }
                    AttributeTypeGeneric attributeType = this.atsApi.tokenService().getAttributeType((String)pointsAttrType);
                    changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)attributeType, data.getPoints());
                }
            }
            if (data.isUnplanned()) {
                for (IAtsTeamWorkflow teamWf : result.getTeamWfs()) {
                    changes.setSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.UnplannedWork, (Object)true);
                }
            }
            if (Strings.isValid((String)(featureGroup = data.getFeatureGroup()))) {
                IAgileFeatureGroup group = null;
                for (IAtsTeamWorkflow teamWf : result.getTeamWfs()) {
                    if (Strings.isNumeric((String)featureGroup)) {
                        group = this.atsApi.getAgileService().getAgileFeatureGroup(ArtifactId.valueOf((String)featureGroup));
                    } else {
                        IAgileTeam aTeam2 = this.atsApi.getAgileService().getAgileTeam(teamWf.getTeamDefinition());
                        if (aTeam2 != null) {
                            for (IAgileFeatureGroup grp : this.atsApi.getAgileService().getAgileFeatureGroups(aTeam2)) {
                                if (!grp.getName().equals(featureGroup)) continue;
                                group = grp;
                                break;
                            }
                        }
                    }
                    if (group == null) continue;
                    changes.relate((Object)teamWf, AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup, (Object)group);
                }
            }
            if (Strings.isValid((String)(sprintStr = data.getSprint()))) {
                for (IAtsTeamWorkflow teamWf : result.getTeamWfs()) {
                    IAgileSprint sprint = null;
                    if (Strings.isNumeric((String)sprintStr)) {
                        sprint = this.atsApi.getAgileService().getAgileSprint(Long.valueOf(sprintStr).longValue());
                    } else {
                        aTeam3 = this.atsApi.getAgileService().getAgileTeam(sprint);
                        for (IAgileSprint aSprint : this.atsApi.getAgileService().getAgileSprints((IAgileTeam)aTeam3)) {
                            if (!aSprint.getName().equals(sprintStr)) continue;
                            sprint = aSprint;
                            break;
                        }
                    }
                    if (sprint == null) continue;
                    changes.relate((Object)sprint, AtsRelationTypes.AgileSprintToItem_AtsItem, (Object)teamWf);
                }
            }
            if (Strings.isValid((String)(agileTeamStr = data.getAgileTeam()))) {
                for (IAtsTeamWorkflow teamWf : result.getTeamWfs()) {
                    IAgileBacklog backlog;
                    aTeam3 = null;
                    if (Strings.isNumeric((String)agileTeamStr)) {
                        aTeam3 = this.atsApi.getAgileService().getAgileTeam(Long.valueOf(agileTeamStr).longValue());
                    } else {
                        ArtifactToken aTeamArt = this.atsApi.getQueryService().getArtifactByNameOrSentinel(AtsArtifactTypes.AgileTeam, agileTeamStr);
                        if (aTeamArt.isValid()) {
                            aTeam3 = this.atsApi.getAgileService().getAgileTeam((ArtifactId)aTeamArt);
                        }
                    }
                    if (aTeam3 == null || (backlog = this.atsApi.getAgileService().getBacklogForTeam(aTeam3.getId().longValue())) == null || this.atsApi.getRelationResolver().areRelated((IAtsObject)backlog, AtsRelationTypes.Goal_Member, (IAtsObject)teamWf)) continue;
                    changes.relate((Object)backlog, AtsRelationTypes.Goal_Member, (Object)teamWf);
                }
            }
            if (Strings.isNumeric((String)data.getOriginatorStr()) && (originator = this.atsApi.getUserService().getUserById(ArtifactId.valueOf((String)data.getOriginatorStr()))) != null) {
                for (IAtsTeamWorkflow teamWf : result.getTeamWfs()) {
                    changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)AtsAttributeTypes.CreatedBy, originator.getUserId());
                }
            }
            if (Strings.isValid((String)data.getAssigneeStr())) {
                LinkedList<AtsUser> assignees = new LinkedList<AtsUser>();
                String[] stringArray = data.getAssigneeStr().split(",");
                int backlog = stringArray.length;
                int aTeam3 = 0;
                while (aTeam3 < backlog) {
                    Object id = stringArray[aTeam3];
                    AtsUser user = this.atsApi.getUserService().getUserById(ArtifactId.valueOf((String)id));
                    if (user != null) {
                        assignees.add(user);
                    }
                    ++aTeam3;
                }
                if (!assignees.isEmpty()) {
                    for (IAtsTeamWorkflow teamWf : result.getTeamWfs()) {
                        teamWf.getStateMgr().setAssignees(assignees);
                        changes.add((Object)teamWf);
                    }
                }
            }
            if (Strings.isValid((String)data.getWorkPackage())) {
                IAtsWorkPackage workPkg = null;
                if (Strings.isNumeric((String)data.getWorkPackage())) {
                    workPkg = this.atsApi.getEarnedValueService().getWorkPackage(ArtifactId.valueOf((String)data.getWorkPackage()));
                } else {
                    ArtifactToken art = this.atsApi.getQueryService().getArtifactByNameOrSentinel(AtsArtifactTypes.WorkPackage, data.getWorkPackage());
                    if (art.isValid()) {
                        workPkg = this.atsApi.getEarnedValueService().getWorkPackage((ArtifactId)art);
                    }
                }
                if (workPkg != null) {
                    for (IAtsTeamWorkflow teamWf : result.getTeamWfs()) {
                        this.atsApi.getEarnedValueService().setWorkPackage(workPkg, (IAtsWorkItem)teamWf, changes);
                    }
                } else {
                    result.getResults().errorf("Inavlid Work Package id or name [%s]", new Object[]{data.getWorkPackage()});
                }
            }
            for (Map.Entry attr : data.getAttrValues().entrySet()) {
                if (!Strings.isNumeric((String)((String)attr.getKey()))) {
                    throw new OseeArgumentException("Invalid attribute type id %s", new Object[]{attr.getKey()});
                }
                AttributeTypeGeneric attributeType = this.atsApi.tokenService().getAttributeType(Long.valueOf((String)attr.getKey()));
                if (attributeType == null) {
                    throw new OseeArgumentException("Invalid attribute type id %s", new Object[]{attr.getKey()});
                }
                for (IAtsTeamWorkflow teamWf : result.getTeamWfs()) {
                    changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)attributeType, (String)attr.getValue());
                }
            }
        }
        catch (Exception ex) {
            result = new ActionResult(null, null);
            result.getResults().errorf("Exception creating Action %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return result;
    }

    public ActionResult createAction(AtsUser user, String title, String desc, ChangeTypes changeType, String priority, boolean validationRequired, Date needByDate, Collection<IAtsActionableItem> actionableItems, Date createdDate, AtsUser createdBy, Collection<INewActionListener> newActionListeners, IAtsChangeSet changes) {
        ActionResult result = null;
        try {
            Conditions.checkNotNullOrEmptyOrContainNull(actionableItems, (String)"actionableItems");
            Conditions.assertNotNullOrEmpty((String)title, (String)"Title must be specified", (Object[])new Object[0]);
            IAtsAction action = this.createAction(title, desc, changeType, priority, validationRequired, needByDate, changes);
            Collection teamDefs = this.atsApi.getTeamDefinitionService().getImpactedTeamDefs(actionableItems);
            if (teamDefs.isEmpty()) {
                StringBuffer sb = new StringBuffer("No teams returned for Action's selected Actionable Items\n");
                for (IAtsActionableItem aia : actionableItems) {
                    sb.append("Selected AI \"" + aia + "\" " + aia.getIdString() + "\n");
                }
                throw new OseeStateException(sb.toString(), new Object[0]);
            }
            ArrayList<IAtsTeamWorkflow> teamWfs = new ArrayList<IAtsTeamWorkflow>();
            for (IAtsTeamDefinition teamDef : teamDefs) {
                LinkedList<AtsUser> leads = new LinkedList<AtsUser>(this.atsApi.getTeamDefinitionService().getLeads(teamDef, actionableItems));
                if (leads.isEmpty()) {
                    leads.add(AtsCoreUsers.UNASSIGNED_USER);
                }
                IAtsTeamWorkflow teamWf = this.createTeamWorkflow(action, teamDef, actionableItems, leads, changes, createdDate, createdBy, newActionListeners, new CreateTeamOption[0]);
                teamWfs.add(teamWf);
                changes.add((Object)teamWf);
            }
            if (newActionListeners != null) {
                for (INewActionListener listener : newActionListeners) {
                    listener.actionCreated(action);
                }
            }
            changes.add((Object)action);
            result = new ActionResult(action, teamWfs);
        }
        catch (Exception ex) {
            result = new ActionResult(null, null);
            result.getResults().errorf("Exception creating Action %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return result;
    }

    public IAtsAction createAction(String title, String desc, ChangeTypes changeType, String priority, boolean validationRequired, Date needByDate, IAtsChangeSet changes) {
        ArtifactToken actionArt = changes.createArtifact(AtsArtifactTypes.Action, title);
        IAtsAction action = this.atsApi.getWorkItemService().getAction(actionArt);
        IAtsTeamDefinition topTeamDefinition = this.getTopTeamDef();
        this.atsApi.getActionService().setAtsId((IAtsObject)action, topTeamDefinition, this.workItemListener, changes);
        changes.add((Object)action);
        this.setArtifactIdentifyData((IAtsObject)action, title, desc, changeType, priority, validationRequired, needByDate, changes);
        return action;
    }

    private IAtsTeamDefinition getTopTeamDef() {
        if (this.topTeamDefinition == null) {
            this.topTeamDefinition = this.atsApi.getTeamDefinitionService().getTopTeamDefinition();
        }
        return this.topTeamDefinition;
    }

    public IAtsTeamWorkflow createTeamWorkflow(IAtsAction action, IAtsTeamDefinition teamDef, Collection<IAtsActionableItem> actionableItems, List<AtsUser> assignees, IAtsChangeSet changes, Date createdDate, AtsUser createdBy, Collection<INewActionListener> newActionListeners, CreateTeamOption ... createTeamOption) {
        Conditions.assertNotNull((Object)teamDef, (String)"Team Definition can not be null", (Object[])new Object[0]);
        WorkDefinition workDef = this.atsApi.getWorkDefinitionService().computeWorkDefinitionForTeamWfNotYetCreated(teamDef, newActionListeners);
        Conditions.assertNotNull((Object)workDef, (String)"Work Definition can not be null", (Object[])new Object[0]);
        ArtifactTypeToken teamWorkflowArtifactType = null;
        if (newActionListeners != null) {
            for (INewActionListener listener : newActionListeners) {
                ArtifactTypeToken artType = listener.getOverrideArtifactType(teamDef);
                if (!artType.isValid()) continue;
                if (teamWorkflowArtifactType != null) {
                    throw new OseeArgumentException("Provided listeners can not provide override art type", new Object[0]);
                }
                teamWorkflowArtifactType = artType;
            }
        }
        if (teamWorkflowArtifactType == null) {
            ArtifactTypeToken artifactTypeToken = teamWorkflowArtifactType = workDef != null ? workDef.getArtType() : null;
        }
        if (teamWorkflowArtifactType == null) {
            teamWorkflowArtifactType = this.getTeamWorkflowArtifactType(teamDef);
        }
        Conditions.assertNotNull((Object)teamWorkflowArtifactType, (String)"Team Workflow Artifact Type can not be null", (Object[])new Object[0]);
        IAtsTeamWorkflow teamWf = this.createTeamWorkflow(action, teamDef, actionableItems, assignees, createdDate, createdBy, teamWorkflowArtifactType, newActionListeners, changes, createTeamOption);
        return teamWf;
    }

    public ArtifactTypeToken getTeamWorkflowArtifactType(IAtsTeamDefinition teamDef) {
        return AtsActionService.getTeamWorkflowArtifactType(teamDef, this.atsApi);
    }

    public static ArtifactTypeToken getTeamWorkflowArtifactType(IAtsTeamDefinition teamDef, AtsApi atsApi) {
        String artifactTypeName;
        Conditions.checkNotNull((Object)teamDef, (String)"teamDef");
        ArtifactTypeToken teamWorkflowArtifactType = AtsArtifactTypes.TeamWorkflow;
        if (teamDef.getStoreObject() != null && Strings.isValid((String)(artifactTypeName = (String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.TeamWorkflowArtifactType, null)))) {
            boolean found = false;
            for (ArtifactTypeToken type : atsApi.getArtifactTypes()) {
                if (!type.getName().equals(artifactTypeName)) continue;
                teamWorkflowArtifactType = type;
                found = true;
                break;
            }
            if (!found) {
                throw new OseeArgumentException("Team Workflow Artifact Type name [%s] off Team Definition %s could not be found.", new Object[]{artifactTypeName, teamDef.toStringWithId()});
            }
        }
        return teamWorkflowArtifactType;
    }

    public IAtsTeamWorkflow createTeamWorkflow(IAtsAction action, IAtsTeamDefinition teamDef, Collection<IAtsActionableItem> actionableItems, List<? extends AtsUser> assignees, Date createdDate, AtsUser createdBy, ArtifactTypeToken artifactType, Collection<INewActionListener> newActionListeners, IAtsChangeSet changes, CreateTeamOption ... createTeamOption) {
        WorkDefinition workDef = null;
        if (actionListeners != null) {
            for (INewActionListener listener : actionListeners) {
                AtsWorkDefinitionToken overrideWorkDefinitionId = listener.getOverrideWorkDefinitionId(teamDef);
                if (overrideWorkDefinitionId == null) continue;
                workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)overrideWorkDefinitionId);
                break;
            }
        }
        if (workDef == null) {
            workDef = this.atsApi.getWorkDefinitionService().computeWorkDefinitionForTeamWfNotYetCreated(teamDef, newActionListeners);
        }
        Conditions.assertNotNull(workDef, (String)"Work Definition can no be null", (Object[])new Object[0]);
        if (!Arrays.asList(createTeamOption).contains(CreateTeamOption.Duplicate_If_Exists)) {
            for (IAtsTeamWorkflow teamArt : action.getTeamWorkflows()) {
                if (!teamArt.getTeamDefinition().equals(teamDef)) continue;
                throw new OseeArgumentException("Team [%s] already exists for Action [%s]", new Object[]{teamDef, this.atsApi.getAtsId((IAtsObject)action)});
            }
        }
        LinkedList<IAtsActionableItem> applicableAis = new LinkedList<IAtsActionableItem>();
        for (IAtsActionableItem ai : actionableItems) {
            IAtsTeamDefinition teamDefinitionInherited = ai.getAtsApi().getActionableItemService().getTeamDefinitionInherited(ai);
            if (teamDefinitionInherited == null || !teamDef.getId().equals(teamDefinitionInherited.getId())) continue;
            applicableAis.add(ai);
        }
        IAtsTeamWorkflow teamWf = null;
        ArtifactToken artToken = null;
        if (newActionListeners != null) {
            for (INewActionListener listener : newActionListeners) {
                artToken = listener.getArtifactToken(applicableAis);
            }
        }
        teamWf = artToken == null ? this.atsApi.getWorkItemService().getTeamWf(changes.createArtifact(artifactType, "")) : this.atsApi.getWorkItemService().getTeamWf(changes.createArtifact(artToken));
        this.atsApi.getWorkDefinitionService().setWorkDefinitionAttrs((IAtsWorkItem)teamWf, workDef, changes);
        this.setArtifactIdentifyData(action, teamWf, changes);
        for (IAtsActionableItem aia : applicableAis) {
            this.atsApi.getActionableItemService().addActionableItem((IAtsWorkItem)teamWf, aia, changes);
        }
        changes.setSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, (Object)teamDef.getStoreObject());
        this.setAtsId((IAtsObject)teamWf, teamWf.getTeamDefinition(), this.workItemListener, changes);
        this.initializeNewStateMachine((IAtsWorkItem)teamWf, assignees, createdDate, createdBy, workDef, changes);
        if (newActionListeners != null) {
            for (INewActionListener listener : newActionListeners) {
                listener.teamCreated(action, teamWf, changes);
            }
        }
        if (actionListeners != null) {
            for (INewActionListener listener : actionListeners) {
                listener.teamCreated(action, teamWf, changes);
            }
        }
        changes.relate((Object)action, AtsRelationTypes.ActionToWorkflow_TeamWorkflow, (Object)teamWf);
        this.addActionToConfiguredGoal(teamDef, teamWf, actionableItems, null, changes);
        changes.add((Object)teamWf);
        changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((AtsUser)AtsCoreUsers.SYSTEM_USER, (IAtsWorkItem)teamWf, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.SubscribedTeamOrAi}));
        changes.addWorkflowCreated(teamWf);
        return teamWf;
    }

    public void initializeNewStateMachine(IAtsWorkItem workItem, List<? extends AtsUser> assignees, Date createdDate, AtsUser createdBy, WorkDefinition workDefinition, IAtsChangeSet changes) {
        Conditions.checkNotNull((Object)createdDate, (String)"createdDate");
        Conditions.checkNotNull((Object)createdBy, (String)"createdBy");
        Conditions.checkNotNull((Object)changes, (String)"changes");
        Conditions.checkNotNull((Object)workDefinition, (String)"workDefinition");
        this.atsApi.getWorkDefinitionService().internalSetWorkDefinition(workItem, workDefinition);
        StateDefinition startState = workDefinition.getStartState();
        StateManager stateMgr = new StateManager(workItem, this.atsApi);
        workItem.setStateMgr((IAtsStateManager)stateMgr);
        changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, startState.getStateType().name());
        StateManagerUtility.initializeStateMachine(stateMgr, (IStateToken)startState, assignees, createdBy, changes);
        AtsUser user = createdBy;
        this.setCreatedBy(workItem, user, true, createdDate, changes);
        TransitionManager.logStateStartedEvent(workItem, (IStateToken)startState, createdDate, user);
    }

    private void logCreatedByChange(IAtsWorkItem workItem, AtsUser user, Date date, AtsUser asUser) {
        if (this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy, null) == null) {
            workItem.getLog().addLog(LogType.Originated, "", "", date, user.getUserId());
        } else {
            workItem.getLog().addLog(LogType.Originated, "", "Changed by " + asUser.getName(), date, user.getUserId());
        }
    }

    public void setCreatedBy(IAtsWorkItem workItem, AtsUser user, boolean logChange, Date date, IAtsChangeSet changes) {
        if (logChange) {
            this.logCreatedByChange(workItem, user, date, changes.getAsUser());
        }
        if (this.atsApi.getAttributeResolver().isAttributeTypeValid(workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy)) {
            changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy, user.getUserId());
        }
        if (this.atsApi.getAttributeResolver().isAttributeTypeValid(workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedDate)) {
            changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedDate, (Object)date);
        }
        changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((AtsUser)changes.getAsUser(), (IAtsWorkItem)workItem, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.Originator}));
    }

    public void addActionToConfiguredGoal(IAtsTeamDefinition teamDef, IAtsTeamWorkflow teamWf, Collection<IAtsActionableItem> actionableItems, IAtsGoal handledGoal, IAtsChangeSet changes) {
        IRelationResolver relationResolver = this.atsApi.getRelationResolver();
        for (IAtsGoal goal : relationResolver.getRelated((IAtsObject)teamDef, AtsRelationTypes.AutoAddActionToGoal_Goal, IAtsGoal.class)) {
            if (goal.equals(handledGoal) || relationResolver.areRelated((IAtsObject)goal, AtsRelationTypes.Goal_Member, (IAtsObject)teamWf)) continue;
            changes.relate((Object)goal, AtsRelationTypes.Goal_Member, (Object)teamWf);
            changes.add((Object)goal);
        }
        for (IAtsActionableItem aia : actionableItems) {
            for (IAtsGoal goal : relationResolver.getRelated((IAtsObject)aia, AtsRelationTypes.AutoAddActionToGoal_Goal, IAtsGoal.class)) {
                if (goal.equals(handledGoal) || relationResolver.areRelated((IAtsObject)goal, AtsRelationTypes.Goal_Member, (IAtsObject)teamWf)) continue;
                changes.relate((Object)goal, AtsRelationTypes.Goal_Member, (Object)teamWf);
                changes.add((Object)goal);
            }
        }
    }

    public void setArtifactIdentifyData(IAtsAction fromAction, IAtsTeamWorkflow toTeam, IAtsChangeSet changes) {
        Conditions.checkNotNull((Object)fromAction, (String)"fromAction");
        Conditions.checkNotNull((Object)toTeam, (String)"toTeam");
        Conditions.checkNotNull((Object)changes, (String)"changes");
        ChangeTypes changeType = ChangeTypes.valueOf((String)((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)fromAction, (AttributeTypeToken)AtsAttributeTypes.ChangeType, (Object)"None")));
        this.setArtifactIdentifyData((IAtsObject)toTeam, fromAction.getName(), (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)fromAction, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)""), changeType, (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)fromAction, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)""), (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)fromAction, (AttributeTypeToken)AtsAttributeTypes.ValidationRequired, (Object)false), (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)fromAction, (AttributeTypeToken)AtsAttributeTypes.NeedBy, null), changes);
    }

    public void setArtifactIdentifyData(IAtsObject atsObject, String title, String desc, ChangeTypes changeType, String priority, Boolean validationRequired, Date needByDate, IAtsChangeSet changes) {
        changes.setSoleAttributeValue(atsObject, (AttributeTypeToken)CoreAttributeTypes.Name, (Object)title);
        if (Strings.isValid((String)desc)) {
            changes.addAttribute(atsObject, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)desc);
        }
        if (changeType != null) {
            changes.setSoleAttributeValue(atsObject, (AttributeTypeToken)AtsAttributeTypes.ChangeType, (Object)changeType.name());
        }
        if (Strings.isValid((String)priority)) {
            changes.addAttribute(atsObject, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)priority);
        }
        if (needByDate != null) {
            changes.addAttribute(atsObject, (AttributeTypeToken)AtsAttributeTypes.NeedBy, (Object)needByDate);
        }
        if (validationRequired.booleanValue()) {
            changes.addAttribute(atsObject, (AttributeTypeToken)AtsAttributeTypes.ValidationRequired, (Object)true);
        }
    }

    public Collection<IAtsTeamWorkflow> getSiblingTeamWorkflows(IAtsTeamWorkflow teamWf) {
        LinkedList<IAtsTeamWorkflow> teams = new LinkedList<IAtsTeamWorkflow>();
        IAtsAction action = this.getAction(teamWf);
        for (IAtsTeamWorkflow teamChild : this.atsApi.getRelationResolver().getRelated((IAtsObject)action, AtsRelationTypes.ActionToWorkflow_TeamWorkflow, IAtsTeamWorkflow.class)) {
            if (!teamChild.notEqual((Id)teamWf)) continue;
            teams.add(teamChild);
        }
        return teams;
    }

    public IAtsAction getAction(IAtsTeamWorkflow teamWf) {
        return (IAtsAction)this.atsApi.getRelationResolver().getRelatedOrNull((IAtsObject)teamWf, AtsRelationTypes.ActionToWorkflow_Action, IAtsAction.class);
    }

    public void setAtsId(IAtsObject newObject, IAtsTeamDefinition teamDef, IWorkItemListener workItemListener, IAtsChangeSet changes) {
        AtsIdProvider atsIdProvider = new AtsIdProvider(this.atsApi.getSequenceProvider(), this.atsApi.getAttributeResolver(), newObject, teamDef);
        atsIdProvider.setWorkItemListener(workItemListener);
        atsIdProvider.setAtsId(changes);
    }

    public String getActionStateJson(Collection<IAtsWorkItem> workItems) {
        try {
            ActionServiceOperations ops = new ActionServiceOperations(this.atsApi);
            return ops.getActionStateJson(workItems, this.getJsonFactory());
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private JsonFactory getJsonFactory() {
        if (this.jsonFactory == null) {
            this.jsonFactory = JsonUtil.getFactory();
        }
        return this.jsonFactory;
    }

    public IWorkItemListener getWorkItemListener() {
        return this.workItemListener;
    }

    public void setWorkItemListener(IWorkItemListener workItemListener) {
        this.workItemListener = workItemListener;
    }

    public void addActionListener(INewActionListener listener) {
        actionListeners.add(listener);
    }

    public IAtsGoal createGoal(String title, IAtsChangeSet changes) {
        WorkDefinition workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Goal);
        return this.createGoal(title, AtsArtifactTypes.Goal, workDef, this.atsApi.getTeamDefinitionService().getTopTeamDefinition(), changes, null);
    }

    public IAtsGoal createGoal(String title, ArtifactTypeToken artifactType, WorkDefinition workDefinition, IAtsTeamDefinition teamDef, IAtsChangeSet changes, IWorkItemListener workItemListener) {
        ArtifactToken art = changes.createArtifact(artifactType, title);
        IAtsGoal goal = this.atsApi.getWorkItemService().getGoal(art);
        if (goal == null) {
            throw new OseeCoreException("In AtsActionService.createGoal, the local vairable \"goal\" is null which is dereferenced", new Object[0]);
        }
        Conditions.assertNotNull((Object)teamDef, (String)"Team Definition can not be null for %s", (Object[])new Object[]{goal.toStringWithId()});
        this.atsApi.getActionService().setAtsId((IAtsObject)goal, teamDef, workItemListener, changes);
        WorkDefinition useWorkDefinition = workDefinition;
        if (useWorkDefinition == null) {
            useWorkDefinition = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)AtsWorkDefinitionTokens.WorkDef_Goal);
        }
        Conditions.assertNotNull((Object)workDefinition, (String)"Work Definition can not be null for %s", (Object[])new Object[]{goal.toStringWithId()});
        this.atsApi.getWorkDefinitionService().setWorkDefinitionAttrs((IAtsWorkItem)goal, workDefinition, changes);
        this.atsApi.getActionService().initializeNewStateMachine((IAtsWorkItem)goal, Arrays.asList(this.atsApi.getUserService().getCurrentUser()), new Date(), this.atsApi.getUserService().getCurrentUser(), workDefinition, changes);
        return goal;
    }
}

