/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import java.util.Arrays;
import org.eclipse.osee.framework.resource.management.DataResource;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.orcs.db.internal.proxy.AbstractDataProxy;

public class Storage
extends DataResource {
    private final IResourceManager resourceManager;
    private final AbstractDataProxy dataProxy;
    private byte[] rawContent;
    private volatile boolean initialized;

    public Storage(IResourceManager resourceManager, AbstractDataProxy dataProxy) {
        this.resourceManager = resourceManager;
        this.dataProxy = dataProxy;
        this.clear();
        this.setInitialized(false);
    }

    public void setLocator(String locator) {
        super.setLocator(locator);
        this.setInitialized(false);
    }

    public boolean isDataValid() {
        return this.rawContent != null && this.rawContent.length > 0;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isLoadingAllowed() {
        return !this.isInitialized() && this.isLocatorValid();
    }

    public byte[] getContent() {
        if (this.isLoadingAllowed()) {
            this.rawContent = this.resourceManager.acquire((DataResource)this);
            this.setInitialized(true);
        }
        return this.rawContent;
    }

    public void persist(long storageId) {
        if (this.isDataValid()) {
            this.resourceManager.save(storageId, this.dataProxy.getResolver().getStorageName(), (DataResource)this, this.rawContent);
        }
    }

    public void purge() {
        if (this.isLocatorValid()) {
            this.resourceManager.purge((DataResource)this);
        }
    }

    public void setContent(byte[] rawContent, String extension, String contentType, String encoding) {
        this.rawContent = rawContent;
        this.setContentType(contentType);
        this.setEncoding(encoding);
        this.setExtension(extension);
    }

    public void copyTo(Storage other) {
        other.rawContent = (byte[])(this.rawContent != null ? Arrays.copyOf(this.rawContent, this.rawContent.length) : null);
        other.setContentType(this.getContentType());
        other.setEncoding(this.getEncoding());
        other.setExtension(this.getExtension());
    }

    public void clear() {
        this.setContent(null, "txt", "txt/plain", "UTF-8");
        this.setLocator("");
    }
}

