/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.internal.InterfaceSubMessageAccessor;
import org.eclipse.osee.mim.types.ArtifactMatch;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.orcs.OrcsApi;

public class InterfaceSubMessageApiImpl
implements InterfaceSubMessageApi {
    private ArtifactAccessor<InterfaceSubMessageToken> accessor;
    private final List<AttributeTypeId> subMessageAttributes;
    private final List<RelationTypeSide> affectedRelations;

    InterfaceSubMessageApiImpl(OrcsApi orcsApi) {
        this.setAccessor(new InterfaceSubMessageAccessor(orcsApi));
        this.subMessageAttributes = this.createSubmessageAttributes();
        this.affectedRelations = this.createAffectedRelations();
    }

    private List<RelationTypeSide> createAffectedRelations() {
        LinkedList<RelationTypeSide> relations = new LinkedList<RelationTypeSide>();
        relations.add(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage);
        return relations;
    }

    private void setAccessor(InterfaceSubMessageAccessor interfaceSubMessageAccessor) {
        this.accessor = interfaceSubMessageAccessor;
    }

    private List<AttributeTypeId> createSubmessageAttributes() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceSubMessageNumber);
        return attributes;
    }

    @Override
    public ArtifactAccessor<InterfaceSubMessageToken> getAccessor() {
        return this.accessor;
    }

    @Override
    public Collection<InterfaceSubMessageToken> query(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, false);
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAllByRelation(BranchId branch, ArtifactId messageId) {
        return this.getAllByRelation(branch, messageId, 0L, 0L);
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAllByFilter(BranchId branch, String filter) {
        return this.getAllByFilter(branch, filter, 0L, 0L);
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAllByRelationAndFilter(BranchId branch, ArtifactId messageId, String filter) {
        try {
            return this.getAccessor().getAllByRelationAndFilter(branch, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, messageId, filter, this.subMessageAttributes, InterfaceSubMessageToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceSubMessageToken>();
        }
    }

    @Override
    public InterfaceSubMessageToken get(BranchId branch, ArtifactId subMessageId) {
        try {
            return this.getAccessor().get(branch, subMessageId, InterfaceSubMessageToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return InterfaceSubMessageToken.SENTINEL;
        }
    }

    @Override
    public List<InterfaceSubMessageToken> getAllRelatedFromStructure(InterfaceStructureToken structure) {
        return structure.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceSubMessageContent_SubMessage).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceSubMessageToken((ArtifactReadable)a)).collect(Collectors.toList());
    }

    @Override
    public InterfaceSubMessageToken getWithAllParentRelations(BranchId branch, ArtifactId subMessageId) {
        try {
            List<RelationTypeSide> parentRelations = Arrays.asList(CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionMessage_Connection, CoreRelationTypes.InterfaceConnectionTransportType_TransportType);
            return this.getAccessor().get(branch, subMessageId, parentRelations, InterfaceSubMessageToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return InterfaceSubMessageToken.SENTINEL;
        }
    }

    @Override
    public Collection<InterfaceSubMessageToken> queryExact(BranchId branch, MimAttributeQuery query) {
        return this.query(branch, query, true);
    }

    @Override
    public Collection<InterfaceSubMessageToken> query(BranchId branch, MimAttributeQuery query, boolean isExact) {
        return this.query(branch, query, isExact, 0L, 0L);
    }

    @Override
    public Collection<ArtifactMatch> getAffectedArtifacts(BranchId branch, ArtifactId relatedId) {
        try {
            return this.getAccessor().getAffectedArtifacts(branch, relatedId, this.affectedRelations);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<ArtifactMatch>();
        }
    }

    @Override
    public Collection<InterfaceSubMessageToken> query(BranchId branch, MimAttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, false, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceSubMessageToken> queryExact(BranchId branch, MimAttributeQuery query, long pageNum, long pageSize) {
        return this.query(branch, query, true, pageNum, pageSize);
    }

    @Override
    public Collection<InterfaceSubMessageToken> query(BranchId branch, MimAttributeQuery query, boolean isExact, long pageNum, long pageSize) {
        try {
            return this.getAccessor().getAllByQuery(branch, query, isExact, pageNum, pageSize);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceSubMessageToken>();
        }
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAllByRelation(BranchId branch, ArtifactId messageId, long pageNum, long pageSize) {
        return this.getAllByRelation(branch, messageId, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAllByFilter(BranchId branch, String filter, long pageNum, long pageSize) {
        return this.getAllByFilter(branch, filter, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAllByRelation(BranchId branch, ArtifactId messageId, AttributeTypeId orderByAttribute) {
        return this.getAllByRelation(branch, messageId, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAllByFilter(BranchId branch, String filter, AttributeTypeId orderByAttribute) {
        return this.getAllByFilter(branch, filter, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAllByRelation(BranchId branch, ArtifactId messageId, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            return this.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, messageId, pageNum, pageSize);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceSubMessageToken>();
        }
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAllByFilter(BranchId branch, String filter, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            return this.getAccessor().getAllByFilter(branch, filter, this.subMessageAttributes, pageNum, pageSize, orderByAttribute);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceSubMessageToken>();
        }
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAll(BranchId branch) {
        return this.getAll(branch, 0L, 0L);
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAll(BranchId branch, AttributeTypeId orderByAttribute) {
        return this.getAll(branch, 0L, 0L, orderByAttribute);
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAll(BranchId branch, long pageNum, long pageSize) {
        return this.getAll(branch, pageNum, pageSize, AttributeTypeId.SENTINEL);
    }

    @Override
    public Collection<InterfaceSubMessageToken> getAll(BranchId branch, long pageNum, long pageSize, AttributeTypeId orderByAttribute) {
        try {
            return this.getAccessor().getAll(branch, pageNum, pageSize, orderByAttribute);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceSubMessageToken>();
        }
    }

    @Override
    public List<InterfaceSubMessageToken> getAllByName(BranchId branch, String name, long pageNum, long pageSize) {
        try {
            return (List)this.getAccessor().getAll(branch, new LinkedList<RelationTypeSide>(), name, Arrays.asList(CoreAttributeTypes.Name), pageNum, pageSize, (AttributeTypeId)CoreAttributeTypes.Name);
        }
        catch (Exception ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceSubMessageToken>();
        }
    }

    @Override
    public int getAllByNameCount(BranchId branch, String name) {
        return this.getAccessor().getAllByFilterAndCount(branch, name, Arrays.asList(CoreAttributeTypes.Name));
    }
}

