/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.task.create;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.task.create.ArtifactIncluded;
import org.eclipse.osee.ats.api.task.create.AutoTaskGenType;
import org.eclipse.osee.ats.api.task.create.ChangeReportModDelArts;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskMatch;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskMatchType;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskNameProviderToken;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskTeamWfData;
import org.eclipse.osee.ats.api.task.create.StaticTaskDefinition;
import org.eclipse.osee.ats.api.task.create.TaskChangeType;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeItemData;
import org.eclipse.osee.framework.core.model.change.ChangeItemUtil;
import org.eclipse.osee.framework.core.model.change.ChangeReportRollup;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.model.change.ChangeVersion;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public interface IAtsChangeReportTaskNameProvider {
    public ChangeReportTaskNameProviderToken getId();

    default public Map<ArtifactId, ArtifactToken> getTasksComputedAsNeeded(ChangeReportTaskData crtd, ChangeReportTaskTeamWfData crttwd, AtsApi atsApi) {
        return this.getTasksComputedAsNeeded(crtd, crttwd, atsApi, this.isAddTaskMatch());
    }

    default public boolean isAddTaskMatch() {
        return true;
    }

    default public Map<ArtifactId, ArtifactToken> getTasksComputedAsNeeded(ChangeReportTaskData crtd, ChangeReportTaskTeamWfData crttwd, AtsApi atsApi, boolean addTaskMatch) {
        HashMap<ArtifactId, ArtifactToken> idToArtifact = new HashMap<ArtifactId, ArtifactToken>();
        this.getModifiedArifactNames(crtd, crttwd, idToArtifact, atsApi, addTaskMatch);
        this.getRelArtifactNames(crtd, crttwd, idToArtifact, atsApi, addTaskMatch);
        this.getExtensionNames(crtd, crttwd, idToArtifact, atsApi, addTaskMatch);
        this.getApiAndTaskNames(crtd, crttwd, idToArtifact, atsApi, addTaskMatch);
        return idToArtifact;
    }

    default public void getApiAndTaskNames(ChangeReportTaskData crtd, ChangeReportTaskTeamWfData crttwd, Map<ArtifactId, ArtifactToken> idToArtifact, AtsApi atsApi, boolean addTaskMatch) {
        for (StaticTaskDefinition taskDef : crtd.getSetDef().getStaticTaskDefs()) {
            ChangeReportTaskMatch match = new ChangeReportTaskMatch();
            match.setTaskName(taskDef.getName());
            match.setCreateTaskDef(taskDef);
            match.setType(ChangeReportTaskMatchType.StaticTskCompAsNeeded);
            match.setAutoTaskGenType(AutoTaskGenType.Static.name());
            crttwd.getTaskMatches().add(match);
        }
    }

    default public void getExtensionNames(ChangeReportTaskData crtd, ChangeReportTaskTeamWfData crttwd, Map<ArtifactId, ArtifactToken> idToArtifact, AtsApi atsApi, boolean addTaskMatch) {
    }

    default public void getRelArtifactNames(ChangeReportTaskData crtd, ChangeReportTaskTeamWfData crttwd, Map<ArtifactId, ArtifactToken> idToArtifact, AtsApi atsApi, boolean addTaskMatch) {
        for (ArtifactId chgRptArt : this.getRelArts(crtd, crttwd, atsApi)) {
            this.logAndAddTaskName(crtd, crttwd, atsApi, ArtifactToken.valueOf((ArtifactId)chgRptArt, (String)""), idToArtifact, TaskChangeType.Relation.name(), addTaskMatch);
        }
    }

    default public void getModifiedArifactNames(ChangeReportTaskData crtd, ChangeReportTaskTeamWfData crttwd, Map<ArtifactId, ArtifactToken> idToArtifact, AtsApi atsApi, boolean addTaskMatch) {
        this.processModifiedDeletedArts(crtd, crttwd, idToArtifact, atsApi, addTaskMatch);
    }

    default public ChangeReportTaskMatch logAndAddTaskName(ChangeReportTaskData crtd, ChangeReportTaskTeamWfData crttwd, AtsApi atsApi, ArtifactToken chgRptArt, Map<ArtifactId, ArtifactToken> idToArtifact, String chgType, boolean addTaskMatch) {
        String safeName;
        ArtifactToken art = atsApi.getQueryService().getArtifact((ArtifactId)chgRptArt, crtd.getWorkOrParentBranchId(), DeletionFlag.INCLUDE_DELETED);
        idToArtifact.put((ArtifactId)art, art);
        if (addTaskMatch && Strings.isValid((String)(safeName = this.getTaskName(atsApi, chgType, art)))) {
            ChangeReportTaskMatch match = new ChangeReportTaskMatch();
            match.setChgRptArt(chgRptArt);
            match.setChgRptArtName(art.getName());
            boolean deleted = IAtsChangeReportTaskNameProvider.isChangeItemDeleted(art, crtd.getChangeItems());
            match.setChgRptArtDeleted(deleted);
            match.setTaskName(safeName);
            match.setType(ChangeReportTaskMatchType.ChgRptTskCompAsNeeded);
            if (chgType.equals(TaskChangeType.Deleted.name())) {
                match.setAutoTaskGenType(AutoTaskGenType.ChgRptDelete.name());
            } else if (chgType.equals(TaskChangeType.Add.name())) {
                match.setAutoTaskGenType(AutoTaskGenType.ChgRptAdd.name());
            } else if (chgType.equals(TaskChangeType.Mod.name())) {
                match.setAutoTaskGenType(AutoTaskGenType.ChgRptMod.name());
            }
            crttwd.getTaskMatches().add(match);
            return match;
        }
        return null;
    }

    public static boolean isChangeItemAdded(ArtifactToken reqArt, Collection<ChangeItem> changeItems) {
        boolean added = false;
        if (changeItems != null && !changeItems.isEmpty()) {
            for (ChangeItem change : changeItems) {
                if (!change.getArtId().equals(reqArt) || !change.getChangeType().isAttributeChange() || change.getNetChange().getModType() != ModificationType.NEW) continue;
                added = true;
            }
        }
        return added;
    }

    public static boolean isChangeItemModified(ArtifactToken reqArt, Collection<ChangeItem> changeItems) {
        boolean modified = false;
        if (changeItems != null && !changeItems.isEmpty()) {
            for (ChangeItem change : changeItems) {
                if (!change.getArtId().equals(reqArt) || !change.getChangeType().isAttributeChange() || change.getNetChange().getModType() != ModificationType.MODIFIED) continue;
                modified = true;
            }
        }
        return modified;
    }

    public static boolean isChangeItemDeleted(ArtifactToken reqArt, Collection<ChangeItem> changeItems) {
        boolean deleted = false;
        if (changeItems != null && !changeItems.isEmpty()) {
            for (ChangeItem change : changeItems) {
                if (!change.getArtId().equals(reqArt) || !change.getChangeType().isAttributeChange() || change.getNetChange().getModType() != ModificationType.ARTIFACT_DELETED) continue;
                deleted = true;
            }
        }
        return deleted;
    }

    default public String getTaskName(AtsApi atsApi, String chgType, ArtifactToken art) {
        String safeName = String.format("Handle %s change to [%s]", chgType, atsApi.getStoreService().getSafeName(art));
        if (TaskChangeType.Deleted.name().equals(chgType)) {
            safeName = String.valueOf(safeName) + " (Deleted)";
        }
        return safeName;
    }

    default public ChangeReportModDelArts processModifiedDeletedArts(ChangeReportTaskData crtd, ChangeReportTaskTeamWfData crttwd, Map<ArtifactId, ArtifactToken> idToArtifact, AtsApi atsApi, boolean addTaskMatch) {
        List<ChangeItem> changeItems = crtd.getChangeItems();
        HashSet<ArtifactId> addArts = new HashSet<ArtifactId>();
        HashSet<ArtifactId> modArts = new HashSet<ArtifactId>();
        HashSet<ArtifactId> delArts = new HashSet<ArtifactId>();
        if (crtd.getWorkOrParentBranchId().isValid()) {
            BranchToken branch = atsApi.getBranchService().getBranch(crtd.getWorkOrParentBranchId());
            ChangeItemData data = this.getChangeItemData(changeItems, branch, atsApi);
            Collection rollups = data.getRollups().values();
            for (ChangeReportRollup rollup : rollups) {
                ArtifactIncluded result = this.isIncluded(crtd, crttwd, rollup, rollup.getArtType(), atsApi);
                if (!result.isIncluded()) continue;
                if (result.isDeleted()) {
                    delArts.add(rollup.getArtId());
                    this.logAndAddTaskName(crtd, crttwd, atsApi, rollup.getArtToken(), idToArtifact, TaskChangeType.Deleted.name(), addTaskMatch);
                    continue;
                }
                if (result.isAdded()) {
                    this.logAndAddTaskName(crtd, crttwd, atsApi, rollup.getArtToken(), idToArtifact, TaskChangeType.Add.name(), addTaskMatch);
                    addArts.add(rollup.getArtId());
                    continue;
                }
                if (!result.isModified()) continue;
                this.logAndAddTaskName(crtd, crttwd, atsApi, rollup.getArtToken(), idToArtifact, TaskChangeType.Mod.name(), addTaskMatch);
                modArts.add(rollup.getArtId());
            }
        }
        ChangeReportModDelArts modDel = new ChangeReportModDelArts();
        modDel.setAdded(addArts);
        modDel.setModified(modArts);
        modDel.setDeleted(delArts);
        return modDel;
    }

    default public ArtifactIncluded isIncluded(ChangeReportTaskData crtd, ChangeReportTaskTeamWfData crttwd, ChangeReportRollup rollup, ArtifactTypeToken artType, AtsApi atsApi) {
        Collection<ArtifactTypeToken> incArtTypes = crtd.getSetDef().getChgRptOptions().getArtifactTypes();
        Collection<ArtifactTypeToken> exclArtTypes = crtd.getSetDef().getChgRptOptions().getNotArtifactTypes();
        Collection<AttributeTypeToken> incAttrTypes = crtd.getSetDef().getChgRptOptions().getAttributeTypes();
        Collection<AttributeTypeToken> exclAttrTypes = crtd.getSetDef().getChgRptOptions().getNotAttributeTypes();
        boolean added = false;
        boolean modified = false;
        boolean included = false;
        boolean deleted = false;
        if (artType.inheritsFromAny(exclArtTypes)) {
            return new ArtifactIncluded(added, modified, included, deleted);
        }
        if (!incArtTypes.isEmpty() && !artType.inheritsFromAny(incArtTypes)) {
            return new ArtifactIncluded(added, modified, included, deleted);
        }
        for (ChangeItem item : rollup.getChangeItems()) {
            if (ChangeItemUtil.createdAndDeleted((ChangeItem)item)) continue;
            if (item.getChangeType() != ChangeType.Relation && ChangeItemUtil.isArtifactDeleted((ChangeVersion)item.getCurrentVersion())) {
                deleted = true;
            }
            if (item.getChangeType().isArtifactChange() && !item.isSynthetic()) {
                deleted = this.calculatedIfDeleted(rollup);
                if (ChangeItemUtil.isNew((ChangeVersion)item.getCurrentVersion())) {
                    return new ArtifactIncluded(true, modified, true, deleted);
                }
                return new ArtifactIncluded(added, true, true, deleted);
            }
            if (!item.getChangeType().isAttributeChange()) continue;
            Id typeId = item.getItemTypeId();
            AttributeTypeGeneric attrType = atsApi.tokenService().getAttributeType(typeId.getId());
            boolean incAttrType = incAttrTypes.isEmpty();
            if (!incAttrType) {
                incAttrType = incAttrTypes.contains(attrType);
            }
            if (incAttrType) {
                boolean bl = incAttrType = !exclAttrTypes.contains(attrType);
            }
            if (!incAttrType) continue;
            included = true;
            if (item.getNetChange().getModType() == ModificationType.MODIFIED) {
                modified = true;
                break;
            }
            if (item.getNetChange().getModType() == ModificationType.NEW) {
                added = true;
                continue;
            }
            included = false;
        }
        return new ArtifactIncluded(added, modified, included, deleted);
    }

    default public boolean calculatedIfDeleted(ChangeReportRollup rollup) {
        for (ChangeItem item : rollup.getChangeItems()) {
            if (!item.getChangeType().isArtifactChange() || !item.isDeleted()) continue;
            return true;
        }
        return false;
    }

    default public ChangeItemData getChangeItemData(Collection<ChangeItem> changes, BranchToken branchId, AtsApi atsApi) {
        ChangeItemData data = new ChangeItemData(changes);
        for (ChangeReportRollup rollup : data.getRollups().values()) {
            ArtifactId artId = rollup.getArtId();
            ArtifactTypeToken artType = atsApi.getStoreService().getArtifactType(artId, (BranchId)branchId);
            rollup.setArtType(artType);
            ArtifactToken tok = atsApi.getQueryService().getArtifact(artId, (BranchId)branchId, DeletionFlag.INCLUDE_DELETED);
            rollup.setArtToken(ArtifactToken.valueOf((long)tok.getId(), (String)tok.getName(), (BranchToken)branchId, (ArtifactTypeToken)tok.getArtifactType()));
        }
        return data;
    }

    default public Collection<ArtifactId> getRelArts(ChangeReportTaskData crtd, ChangeReportTaskTeamWfData crttwd, AtsApi atsApi) {
        Collection<RelationTypeToken> incRelTypes = crtd.getSetDef().getChgRptOptions().getRelationTypes();
        Collection<RelationTypeToken> exclRelTypes = crtd.getSetDef().getChgRptOptions().getNotRelationTypes();
        BranchToken branch = atsApi.getBranchService().getBranch(crtd.getWorkOrParentBranchId());
        HashSet<ArtifactId> arts = new HashSet<ArtifactId>();
        ChangeItemData data = this.getChangeItemData(crtd.getChangeItems(), branch, atsApi);
        for (ChangeReportRollup rollup : data.getRollups().values()) {
            List reqArtChangeItems = rollup.getChangeItems();
            for (ChangeItem item : reqArtChangeItems) {
                if (item.getChangeType().isNotRelationChange() || ChangeItemUtil.createdAndDeleted((ChangeItem)item) || exclRelTypes.contains(item.getItemTypeId()) || !incRelTypes.isEmpty() && !incRelTypes.contains(item.getItemTypeId())) continue;
                ArtifactTypeToken artAType = atsApi.getStoreService().getArtifactType(item.getArtId(), (BranchId)branch);
                ArtifactTypeToken artBType = atsApi.getStoreService().getArtifactType(item.getArtIdB(), (BranchId)branch);
                ArtifactIncluded artAInc = this.isIncluded(crtd, crttwd, rollup, artAType, atsApi);
                ArtifactIncluded artBInc = this.isIncluded(crtd, crttwd, rollup, artBType, atsApi);
                if ((!artAInc.isNotDeleted() || !artAInc.isIncluded()) && (!artBInc.isNotDeleted() || !artBInc.isIncluded())) continue;
                arts.add(item.getArtId());
                arts.add(item.getArtIdB());
            }
        }
        return arts;
    }
}

