/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.export;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.exchange.ExchangeUtil;
import org.eclipse.osee.orcs.db.internal.exchange.ExportImportSql;
import org.eclipse.osee.orcs.db.internal.exchange.export.AbstractExportItem;
import org.eclipse.osee.orcs.db.internal.exchange.handler.ExportItem;

public abstract class AbstractSqlExportItem
extends AbstractExportItem {
    private final String GET_COLUMN_NAMES = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = N'" + this.getSource() + "' ORDER BY ORDINAL_POSITION";
    protected final JdbcClient jdbcClient;

    public AbstractSqlExportItem(Log logger, ExportItem id, JdbcClient jdbcClient) {
        super(logger, id);
        this.jdbcClient = jdbcClient;
    }

    @Override
    public final void executeWork() throws Exception {
        block12: {
            this.checkForCancelled();
            Throwable throwable = null;
            Object var2_3 = null;
            try (Writer writer = ExchangeUtil.createSqlWriter(this.getWriteLocation(), this.getFileName(), this.getBufferSize());){
                if (writer == null) break block12;
                StringBuilder columnNames = new StringBuilder(256);
                this.jdbcClient.runQueryWithMaxFetchSize(stmt -> this.getColumnNames(columnNames, (JdbcStatement)stmt), this.GET_COLUMN_NAMES, new Object[0]);
                ExportImportSql.openSqlInsert(writer, this.getSource(), columnNames.toString());
                StringBuilder tableData = new StringBuilder(256);
                try {
                    this.checkForCancelled();
                    this.doWork(tableData);
                    writer.append(tableData.substring(1));
                }
                finally {
                    ExportImportSql.closeSqlInsert(writer);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void getColumnNames(Appendable appendable, JdbcStatement chStmt) {
        try {
            if (!appendable.toString().equals("")) {
                appendable.append(",");
            }
            appendable.append(chStmt.getString(1));
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex, "Failed to fetch column names for :%s", new Object[]{this.GET_COLUMN_NAMES});
        }
    }

    protected abstract void doWork(Appendable var1) throws Exception;
}

