/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeJoin;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.util.ArtifactSearchOptions;
import org.eclipse.osee.orcs.rest.model.AttributeEndpoint;
import org.eclipse.osee.orcs.rest.model.SwaggerCommonOrcsAnnotations;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchRequest;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResponse;
import org.eclipse.osee.orcs.search.ArtifactTable;

@Path(value="artifact")
public interface ArtifactEndpoint {
    @POST
    @Path(value="search/v1")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public SearchResponse getSearchWithMatrixParams(SearchRequest var1);

    @GET
    @Produces(value={"text/html"})
    public String getRootChildrenAsHtml();

    @GET
    @Path(value="{artifactId}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/html"})
    public String getArtifactAsHtml(@PathParam(value="artifactId") ArtifactId var1);

    @GET
    @Path(value="{artifactId}/token")
    @Produces(value={"application/json"})
    public ArtifactToken getArtifactToken(@PathParam(value="artifactId") ArtifactId var1);

    @Path(value="{artifactId}/attribute")
    public AttributeEndpoint getAttributes(@PathParam(value="artifactId") ArtifactId var1);

    @GET
    @Path(value="attType/{attributeType}/token")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getArtifactTokensByAttribute(@PathParam(value="attributeType") AttributeTypeToken var1, @QueryParam(value="value") String var2, @DefaultValue(value="true") @QueryParam(value="exists") boolean var3, @DefaultValue(value="-1") @QueryParam(value="artifactType") ArtifactTypeToken var4);

    @GET
    @Path(value="attType/{attributeType}/id")
    @Produces(value={"application/json"})
    public List<ArtifactId> getArtifactIdsByAttribute(@PathParam(value="attributeType") AttributeTypeToken var1, @QueryParam(value="value") String var2, @DefaultValue(value="true") @QueryParam(value="exists") boolean var3, @DefaultValue(value="-1") @QueryParam(value="artifactType") ArtifactTypeToken var4);

    @GET
    @Path(value="map")
    @Produces(value={"application/json"})
    public List<Map<String, Object>> getArtifactMaps(@DefaultValue(value="-1") @QueryParam(value="attributeType") AttributeTypeToken var1, @QueryParam(value="representation") String var2, @QueryParam(value="value") String var3, @DefaultValue(value="true") @QueryParam(value="exists") boolean var4, @DefaultValue(value="-1") @QueryParam(value="artifactType") ArtifactTypeToken var5, @DefaultValue(value="-1") @QueryParam(value="view") ArtifactId var6);

    @GET
    @Path(value="table")
    @Produces(value={"application/json"})
    public ArtifactTable getArtifactTable(@DefaultValue(value="-1") @QueryParam(value="attributeType") AttributeTypeToken var1, @QueryParam(value="attributeColumns") List<AttributeTypeToken> var2, @QueryParam(value="value") String var3, @DefaultValue(value="true") @QueryParam(value="exists") boolean var4, @DefaultValue(value="-1") @QueryParam(value="artifactType") ArtifactTypeToken var5, @DefaultValue(value="-1") @QueryParam(value="view") ArtifactId var6);

    @GET
    @Path(value="type/{artifactType}/token")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getArtifactTokensByType(@PathParam(value="artifactType") ArtifactTypeToken var1);

    @GET
    @Path(value="exp")
    @Produces(value={"application/json"})
    public List<ArtifactToken> expGetArtifactTokens(@DefaultValue(value="-1") @QueryParam(value="artifactType") ArtifactTypeToken var1, @DefaultValue(value="-1") @QueryParam(value="parent") ArtifactId var2, @DefaultValue(value="-1") @QueryParam(value="view") ArtifactId var3);

    @GET
    @Path(value="changed_artifacts/{attributeTypeJoin}/{commentPattern}")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getChangedArtifactTokens(@DefaultValue(value="-1") @QueryParam(value="view") ArtifactId var1, @PathParam(value="attributeTypeJoin") AttributeTypeJoin var2, @PathParam(value="commentPattern") String var3);

    @GET
    @Path(value="applicability/{id}")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getArtifactTokensByApplicability(@PathParam(value="id") ApplicabilityId var1);

    @GET
    @Path(value="type/{artifactType}/id")
    @Produces(value={"application/json"})
    public List<ArtifactId> getArtifactIdsByType(@PathParam(value="artifactType") ArtifactTypeToken var1);

    @POST
    @Path(value="type/{artifactType}/parent/{parent}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<ArtifactToken> createArtifacts(@PathParam(value="branch") BranchId var1, @PathParam(value="artifactType") ArtifactTypeToken var2, @DefaultValue(value="-1") @PathParam(value="parent") ArtifactId var3, List<String> var4);

    @POST
    @Path(value="type/{artifactType}/parent/{parent}/create")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public ArtifactToken createArtifact(@PathParam(value="branch") BranchId var1, @PathParam(value="artifactType") ArtifactTypeToken var2, @DefaultValue(value="-1") @PathParam(value="parent") ArtifactId var3, String var4);

    @POST
    @Path(value="old-type/{oldType}/new-type/{newType}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<ArtifactToken> changeArtifactType(@PathParam(value="branch") BranchId var1, @PathParam(value="oldType") ArtifactTypeToken var2, @PathParam(value="newType") ArtifactTypeToken var3, List<String> var4);

    @DELETE
    @Path(value="{artifact}")
    @Produces(value={"application/json"})
    public TransactionToken deleteArtifact(@PathParam(value="branch") BranchId var1, @PathParam(value="artifact") ArtifactId var2);

    @PUT
    @Path(value="{artifact}/attribute/type/{attributeType}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public TransactionToken setSoleAttributeValue(@PathParam(value="branch") BranchId var1, @PathParam(value="artifact") ArtifactId var2, @PathParam(value="attributeType") AttributeTypeToken var3, String var4);

    @POST
    @Path(value="search")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ArtifactId> findArtifactIds(ArtifactSearchOptions var1);

    @POST
    @Path(value="search/token")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ArtifactToken> findArtifactTokens(ArtifactSearchOptions var1);

    @GET
    @Path(value="{artifact}/related/maps")
    @Produces(value={"application/json"})
    @SwaggerCommonOrcsAnnotations
    @Operation(summary="Gets a hierarchy tree of Artifacts")
    @Tag(name="hierarchy")
    public List<ArtifactReadable> getRelatedArtifactsTree(@PathParam(value="branch") BranchId var1, @PathParam(value="artifact") ArtifactId var2);
}

