/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.mim.types.MimAttributeChange;
import org.eclipse.osee.mim.types.MimRelationChange;

public class MimDifferenceItem {
    private final ArtifactId artId;
    private final String name;
    private final Long artTypeId;
    private final String artTypeName;
    private boolean added = false;
    private boolean deleted = false;
    private final Map<Long, MimAttributeChange> attributeChanges;
    private final Map<ArtifactId, MimRelationChange> relationChanges;

    public MimDifferenceItem(ArtifactId artId, String name, Long artTypeId, String artTypeName) {
        this.artId = artId;
        this.name = name;
        this.artTypeId = artTypeId;
        this.artTypeName = artTypeName;
        this.attributeChanges = new HashMap<Long, MimAttributeChange>();
        this.relationChanges = new HashMap<ArtifactId, MimRelationChange>();
    }

    public ArtifactId getArtId() {
        return this.artId;
    }

    public String getName() {
        return this.name;
    }

    public Long getArtType() {
        return this.artTypeId;
    }

    public String getArtTypeName() {
        return this.artTypeName;
    }

    public Map<Long, MimAttributeChange> getAttributeChanges() {
        return this.attributeChanges;
    }

    public Map<ArtifactId, MimRelationChange> getRelationChanges() {
        return this.relationChanges;
    }

    public boolean isAdded() {
        return this.added;
    }

    public void setAdded(boolean added) {
        this.added = added;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void addAttributeChange(Long attrId, String attrName, String oldValue, String newValue) {
        this.attributeChanges.put(attrId, new MimAttributeChange(attrId, attrName, oldValue, newValue));
    }

    public void addRelationChange(Long relationTypeId, ArtifactId artIdA, ArtifactId artIdB, String artBName, boolean added) {
        this.relationChanges.put(this.artId, new MimRelationChange(relationTypeId, artIdA, artIdB, artBName, added));
    }
}

