/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.validator;

import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IValueProvider;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.WidgetStatus;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.core.validator.AtsXWidgetValidator;
import org.eclipse.osee.ats.core.validator.AttributeWidget;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class AtsXWidgetAttrValidator
extends AtsXWidgetValidator {
    private final List<AttributeWidget> widgets = Arrays.asList(new AttributeWidget("XReviewedWidget", new AttributeTypeToken[]{AtsAttributeTypes.ReviewedBy, AtsAttributeTypes.ReviewedByDate}));

    @Override
    public WidgetResult validateTransition(IAtsWorkItem workItem, IValueProvider provider, WidgetDefinition widgetDef, StateDefinition fromStateDef, StateDefinition toStateDef, AtsApi atsApi) {
        WidgetResult result = WidgetResult.Success;
        for (AttributeWidget sdWidget : this.widgets) {
            if (!sdWidget.getWidgetName().equals(widgetDef.getXWidgetName())) continue;
            result = this.validateWidgetIsRequired(provider, widgetDef, fromStateDef, toStateDef);
            if (!result.isSuccess()) {
                return result;
            }
            for (AttributeTypeToken attrType : sdWidget.getAttrTypes()) {
                if (atsApi.getAttributeResolver().getAttributeCount(workItem, attrType) != 0) continue;
                return new WidgetResult(WidgetStatus.Invalid_Incompleted, "[%s] is required for transition to [%s]", new Object[]{widgetDef.getName(), toStateDef.getName()});
            }
        }
        return result;
    }
}

