/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.orcs.search.ArtifactIdReportColumn;
import org.eclipse.osee.orcs.search.ArtifactTypeReportColumn;
import org.eclipse.osee.orcs.search.AttributeReportColumn;
import org.eclipse.osee.orcs.search.ReportColumn;

public class ArtifactTableOptions {
    private final List<AttributeReportColumn> attributeColumns;
    private final ArtifactIdReportColumn artifactIdColumn;
    private final ArtifactTypeReportColumn artifactTypeColumn;
    private final List<ReportColumn> columns = new ArrayList<ReportColumn>();
    private final List<AttributeTypeToken> attributeTypes;

    public ArtifactTableOptions(List<AttributeTypeToken> attributeTypes) {
        this.attributeTypes = attributeTypes;
        this.attributeColumns = new ArrayList<AttributeReportColumn>();
        this.artifactIdColumn = new ArtifactIdReportColumn();
        this.artifactTypeColumn = new ArtifactTypeReportColumn();
        attributeTypes.forEach(column -> {
            boolean bl = this.attributeColumns.add(new AttributeReportColumn((AttributeTypeToken)column));
        });
        this.columns.add(this.artifactIdColumn);
        this.columns.add(this.artifactTypeColumn);
        this.columns.addAll(this.attributeColumns);
    }

    @JsonIgnore
    public List<AttributeTypeToken> getAttributeColumns() {
        return this.attributeTypes;
    }

    public List<ReportColumn> getColumns() {
        return this.columns;
    }

    public String toString() {
        return this.attributeColumns.toString();
    }
}

