/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds.criteria;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;

public class CriteriaFollowSearch
extends Criteria {
    private final Collection<AttributeTypeId> attributeTypes;
    private final Collection<String> values;
    private final QueryOption[] options;
    private final boolean includeAllTypes;

    public CriteriaFollowSearch(boolean includeAllTypes, Collection<AttributeTypeId> attributeTypes, Collection<String> values, QueryOption ... options) {
        this.includeAllTypes = includeAllTypes;
        this.attributeTypes = attributeTypes;
        this.values = values;
        this.options = options;
    }

    public CriteriaFollowSearch(boolean includeAllTypes, Collection<AttributeTypeId> attributeTypes, String value, QueryOption ... options) {
        this(includeAllTypes, attributeTypes, java.util.Collections.singleton(value), options);
    }

    public boolean isIncludeAllTypes() {
        return this.includeAllTypes;
    }

    public Collection<AttributeTypeId> getTypes() {
        return this.attributeTypes;
    }

    public Collection<String> getValues() {
        return this.values;
    }

    public QueryOption[] getOptions() {
        return this.options;
    }

    @Override
    public void checkValid(Options options) {
        Conditions.checkNotNullOrEmpty(this.getValues(), (String)"search value");
        Conditions.checkNotNullOrEmpty(this.getTypes(), (String)"attribute types");
        this.checkMultipleValues();
    }

    @Override
    public String toString() {
        return String.format("CriteriaAttributeKeyword [attributeType=%s, value=%s, options=%s]", this.attributeTypes, Collections.toString((String)",", this.values), Collections.toString((String)",", Arrays.asList(this.options)));
    }

    private void checkMultipleValues() {
        if (this.getTypes().size() > 1 && this.getValues().size() > 1) {
            throw new OseeArgumentException("Multiple values is not valid with multiple types", new Object[0]);
        }
    }
}

