/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;

public class MinicomOutputThread
extends Thread {
    private final Writer output;
    private final BufferedReader input;
    private boolean resetFinished;

    public MinicomOutputThread(Writer output, BufferedReader input) {
        this.output = output;
        this.input = input;
        this.waitForWelcomScreen();
        this.resetFinished = false;
    }

    private void waitForWelcomScreen() {
        try {
            String welcomeLine = "Press CTRL-A Z for help on special keys";
            String outLine = null;
            while ((outLine = this.input.readLine()) != null) {
                this.output.write("\nWELCOME: " + outLine);
                if (!outLine.contains(welcomeLine)) {
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isResetFinished() {
        return this.resetFinished;
    }

    @Override
    public void run() {
        String outLine = null;
        try {
            try {
                while ((outLine = this.input.readLine()) != null) {
                    if (!outLine.contains("[")) {
                        this.output.write(String.valueOf(outLine) + "\n");
                    }
                    if (!outLine.contains("Start of wp_periodic_task")) continue;
                    this.output.write("Found end of reset\n");
                    this.resetFinished = true;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    this.input.close();
                    this.output.flush();
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                this.input.close();
                this.output.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void waitForReset() {
        try {
            String outLine;
            while ((outLine = this.input.readLine()) != null && !this.isResetFinished()) {
                if (!outLine.contains("[")) {
                    this.output.write(String.valueOf(outLine) + "\n");
                }
                if (!outLine.contains("Start of wp_periodic_task")) continue;
                this.output.write("Found end of reset\n");
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

