/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.osee.define.util.HierarchyTree;

class HierarchyTreeNode<K, V> {
    int childCount;
    HierarchyTreeNode<K, V> currChild;
    HierarchyTreeNode<K, V> firstChild;
    final K key;
    HierarchyTreeNode<K, V> lastChild;
    HierarchyTreeNode<K, V> nextSibling;
    HierarchyTreeNode<K, V> parent;
    HierarchyTreeNode<K, V> previousSibling;
    final HierarchyTree<K, V> tree;
    final V value;

    HierarchyTreeNode(HierarchyTree<K, V> tree, K key, V value) {
        this.tree = Objects.requireNonNull(tree, "HierarchyTreeNode::new, parameter \"tree\" cannot be null.");
        this.key = Objects.requireNonNull(key, "HierarchyTreeNode::new, parameter \"key\" cannot be null.");
        this.value = Objects.requireNonNull(value, "HierarchyTreeNode::new, parameter \"value\" cannot be null.");
        this.parent = null;
        this.firstChild = null;
        this.lastChild = null;
        this.currChild = null;
        this.childCount = 0;
        this.previousSibling = null;
        this.nextSibling = null;
    }

    HierarchyTreeNode<K, V> getCurrentChild() {
        return this.currChild;
    }

    HierarchyTreeNode<K, V> getFirstChild() {
        this.currChild = this.firstChild;
        return this.currChild;
    }

    K getKey() {
        return this.key;
    }

    HierarchyTreeNode<K, V> getLastChild() {
        this.currChild = this.lastChild;
        return this.currChild;
    }

    HierarchyTreeNode<K, V> getNext() {
        return this.nextSibling;
    }

    HierarchyTreeNode<K, V> getNextChild() {
        if (this.currChild == null || this.currChild.nextSibling == null) {
            return null;
        }
        this.currChild = this.currChild.nextSibling;
        return this.currChild;
    }

    HierarchyTreeNode<K, V> getParent() {
        return this.parent;
    }

    HierarchyTreeNode<K, V> getPrevious() {
        return this.previousSibling;
    }

    HierarchyTreeNode<K, V> getPreviousChild() {
        if (this.currChild == null || this.currChild.previousSibling == null) {
            return null;
        }
        this.currChild = this.currChild.previousSibling;
        return this.currChild;
    }

    HierarchyTree<K, V> getTree() {
        return this.tree;
    }

    V getValue() {
        return this.value;
    }

    boolean hasChild() {
        return this.firstChild != null;
    }

    boolean hasChildren() {
        return this.firstChild != null;
    }

    boolean hasNext() {
        return this.nextSibling != null;
    }

    boolean hasNextChild() {
        return this.currChild != null && this.currChild.nextSibling != null;
    }

    boolean hasParent() {
        return this.parent != null;
    }

    boolean hasPrevious() {
        return this.previousSibling != null;
    }

    boolean hasPreviousChild() {
        return this.currChild != null && this.currChild.previousSibling != null;
    }

    void insertAfter(K key, V value) {
        if (this.currChild == null || this.currChild == this.lastChild) {
            this.insertLast(key, value);
            if (this.currChild == null) {
                this.currChild = this.lastChild;
            }
            return;
        }
        HierarchyTreeNode<K, V> newChild = new HierarchyTreeNode<K, V>(this.tree, key, value);
        HierarchyTreeNode<K, V> formerNextSibling = this.currChild.nextSibling;
        newChild.parent = this;
        newChild.previousSibling = this.currChild;
        newChild.nextSibling = formerNextSibling;
        this.tree.put(key, newChild);
        this.currChild.nextSibling = newChild;
        formerNextSibling.previousSibling = newChild;
        ++this.childCount;
    }

    void insertBefore(K key, V value) {
        if (this.currChild == null || this.currChild == this.firstChild) {
            this.insertFirst(key, value);
            if (this.currChild == null) {
                this.currChild = this.firstChild;
            }
            return;
        }
        HierarchyTreeNode<K, V> newChild = new HierarchyTreeNode<K, V>(this.tree, key, value);
        HierarchyTreeNode<K, V> formerPreviousSibling = this.currChild.previousSibling;
        newChild.parent = this;
        newChild.previousSibling = formerPreviousSibling;
        newChild.nextSibling = this.currChild;
        this.tree.put(key, newChild);
        formerPreviousSibling.nextSibling = newChild;
        this.currChild.previousSibling = newChild;
        ++this.childCount;
    }

    void insertFirst(K key, V value) {
        HierarchyTreeNode<K, V> newChild = new HierarchyTreeNode<K, V>(this.tree, key, value);
        newChild.parent = this;
        this.tree.put(key, newChild);
        HierarchyTreeNode<K, V> formerFirstChild = this.firstChild;
        this.firstChild = newChild;
        if (formerFirstChild != null) {
            newChild.nextSibling = formerFirstChild;
            formerFirstChild.previousSibling = newChild;
        }
        if (this.lastChild == null) {
            this.lastChild = newChild;
        }
        ++this.childCount;
    }

    void insertLast(K key, V value) {
        HierarchyTreeNode<K, V> newChildNode = new HierarchyTreeNode<K, V>(this.tree, key, value);
        newChildNode.parent = this;
        this.tree.put(key, newChildNode);
        HierarchyTreeNode<K, V> formerLastChild = this.lastChild;
        this.lastChild = newChildNode;
        if (formerLastChild != null) {
            newChildNode.previousSibling = formerLastChild;
            formerLastChild.nextSibling = newChildNode;
        }
        if (this.firstChild == null) {
            this.firstChild = newChildNode;
        }
        if (this.currChild == null) {
            this.currChild = newChildNode;
        }
        ++this.childCount;
    }

    private Iterator<HierarchyTreeNode<K, V>> iterator() {
        return new Iterator<HierarchyTreeNode<K, V>>(){
            boolean first = true;

            @Override
            public boolean hasNext() {
                return this.first ? HierarchyTreeNode.this.hasChild() : HierarchyTreeNode.this.hasNextChild();
            }

            @Override
            public HierarchyTreeNode<K, V> next() {
                if (this.first) {
                    if (!HierarchyTreeNode.this.hasChild()) {
                        throw new NoSuchElementException();
                    }
                    this.first = false;
                    return HierarchyTreeNode.this.getFirstChild();
                }
                if (!HierarchyTreeNode.this.hasNextChild()) {
                    throw new NoSuchElementException();
                }
                return HierarchyTreeNode.this.getNextChild();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    Iterator<K> iteratorKeys() {
        return new Iterator<K>(){
            Iterator<HierarchyTreeNode<K, V>> iterator;
            {
                this.iterator = HierarchyTreeNode.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public K next() {
                return this.iterator.next().getKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    Iterator<V> iteratorValues() {
        return new Iterator<V>(){
            Iterator<HierarchyTreeNode<K, V>> iterator;
            {
                this.iterator = HierarchyTreeNode.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public V next() {
                return this.iterator.next().getValue();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    void setCurrent() {
        if (this.parent == null) {
            return;
        }
        this.parent.currChild = this;
    }

    public Spliterator<V> spliterator() {
        return new Spliterator<V>(){
            boolean first = true;
            int index = 0;

            @Override
            public int characteristics() {
                return 272;
            }

            @Override
            public long estimateSize() {
                return HierarchyTreeNode.this.childCount - this.index;
            }

            @Override
            public boolean tryAdvance(Consumer<? super V> action) {
                if (this.first) {
                    if (!HierarchyTreeNode.this.hasChild()) {
                        return false;
                    }
                    Object value = HierarchyTreeNode.this.getFirstChild().getValue();
                    action.accept(value);
                    this.first = false;
                    ++this.index;
                    return true;
                }
                if (!HierarchyTreeNode.this.hasNextChild()) {
                    return false;
                }
                Object value = HierarchyTreeNode.this.getNextChild().getValue();
                action.accept(value);
                ++this.index;
                return true;
            }

            @Override
            public Spliterator<V> trySplit() {
                return null;
            }
        };
    }

    public Spliterator<K> spliteratorChildKeys() {
        return new Spliterator<K>(){
            boolean first = true;
            int index = 0;

            @Override
            public int characteristics() {
                return 272;
            }

            @Override
            public long estimateSize() {
                return HierarchyTreeNode.this.childCount - this.index;
            }

            @Override
            public boolean tryAdvance(Consumer<? super K> action) {
                if (this.first) {
                    if (!HierarchyTreeNode.this.hasChild()) {
                        return false;
                    }
                    Object key = HierarchyTreeNode.this.getFirstChild().getKey();
                    action.accept(key);
                    this.first = false;
                    ++this.index;
                    return true;
                }
                if (!HierarchyTreeNode.this.hasNextChild()) {
                    return false;
                }
                Object key = HierarchyTreeNode.this.getNextChild().getKey();
                action.accept(key);
                ++this.index;
                return true;
            }

            @Override
            public Spliterator<K> trySplit() {
                return null;
            }
        };
    }

    public Spliterator<K> spliteratorChildKeysDeep() {
        return new Spliterator<K>(){
            Spliterator<K> childSpliteratorChildKeysDeep = null;
            boolean first = true;

            @Override
            public int characteristics() {
                return 256;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public boolean tryAdvance(Consumer<? super K> action) {
                if (this.first) {
                    if (!HierarchyTreeNode.this.hasChild()) {
                        return false;
                    }
                    HierarchyTreeNode child = HierarchyTreeNode.this.getFirstChild();
                    Object key = child.getKey();
                    this.childSpliteratorChildKeysDeep = child.spliteratorChildKeysDeep();
                    action.accept(key);
                    this.first = false;
                    return true;
                }
                if (this.childSpliteratorChildKeysDeep != null) {
                    if (this.childSpliteratorChildKeysDeep.tryAdvance(action)) {
                        return true;
                    }
                    this.childSpliteratorChildKeysDeep = null;
                }
                if (!HierarchyTreeNode.this.hasNextChild()) {
                    return false;
                }
                HierarchyTreeNode child = HierarchyTreeNode.this.getNextChild();
                Object key = child.getKey();
                this.childSpliteratorChildKeysDeep = child.spliteratorChildKeysDeep();
                action.accept(key);
                return true;
            }

            @Override
            public Spliterator<K> trySplit() {
                return null;
            }
        };
    }

    Stream<V> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    Stream<K> streamChildKeys() {
        return StreamSupport.stream(this.spliteratorChildKeys(), false);
    }

    Stream<K> streamChildKeysDeep() {
        return StreamSupport.stream(this.spliteratorChildKeysDeep(), false);
    }
}

