/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.publishing.datarights;

import java.util.List;
import java.util.Objects;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import org.eclipse.osee.define.api.DefineOperations;
import org.eclipse.osee.define.api.publishing.datarights.DataRightsEndpoint;
import org.eclipse.osee.define.operations.publishing.PublishingPermissions;
import org.eclipse.osee.define.operations.publishing.UserNotAuthorizedForPublishingException;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.publishing.DataRightResult;

public class DataRightsEndpointImpl
implements DataRightsEndpoint {
    private final DefineOperations defineOperations;

    public DataRightsEndpointImpl(DefineOperations defineOperations) {
        this.defineOperations = Objects.requireNonNull(defineOperations, "DataRightsEndpointImpl::new, parameter \"defineOperaions\" cannot be null.");
    }

    public void deleteCache() {
        try {
            PublishingPermissions.verify();
            this.defineOperations.getDataRightsOperations().deleteCache();
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public DataRightResult getDataRights(BranchId branchIdentifier, List<ArtifactId> artifactIdentifiers) {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.defineOperations.getDataRightsOperations().getDataRights(branchIdentifier, artifactIdentifiers);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }

    public DataRightResult getDataRights(BranchId branchIdentifier, String overrideClassification, List<ArtifactId> artifactIdentifiers) {
        try {
            PublishingPermissions.verifyNonGroup();
            return this.defineOperations.getDataRightsOperations().getDataRights(branchIdentifier, overrideClassification, artifactIdentifiers);
        }
        catch (UserNotAuthorizedForPublishingException e) {
            throw new NotAuthorizedException(e.getMessage(), Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw new BadRequestException(iae.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).build(), (Throwable)iae);
        }
        catch (Exception e) {
            throw new ServerErrorException(e.getMessage(), Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build(), (Throwable)e);
        }
    }
}

