/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing.datarights;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.publishing.DataRight;
import org.eclipse.osee.framework.core.publishing.DataRightAnchor;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

class DataRightAnchors
implements AutoCloseable,
ToMessage {
    private Map<ArtifactId, DataRightAnchor> dataRightAnchors = new LinkedHashMap<ArtifactId, DataRightAnchor>(128);
    private boolean isOpen = true;

    public DataRightAnchor add(ArtifactId artifactId, DataRight dataRight, boolean isSetDataRightFooter) {
        if (!this.isOpen) {
            throw new IllegalStateException("DataRightAnchor::add, attempt to add an entry after the \"DataRightAnchors\" object has been closed.");
        }
        DataRightAnchor dataRightAnchor = new DataRightAnchor(artifactId, dataRight, Boolean.valueOf(isSetDataRightFooter));
        this.dataRightAnchors.put(artifactId, dataRightAnchor);
        return dataRightAnchor;
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            throw new IllegalStateException("DataRightAnchor::close, attempt to close the \"DataRightAnchors\" object after it has been closed.");
        }
        this.dataRightAnchors = Collections.unmodifiableMap(this.dataRightAnchors);
        this.isOpen = false;
    }

    public Stream<DataRightAnchor> stream() {
        if (this.isOpen) {
            throw new IllegalStateException("DataRightAnchor::iterator, attempt to get a \"Stream\" for a \"DataRightAnchors\" object that is still open.");
        }
        return this.dataRightAnchors.values().stream();
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"DataRightAnchors").indentInc().segment((CharSequence)"isOpen", (Object)this.isOpen).segmentMap((CharSequence)"dataRightAncors", this.dataRightAnchors).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

