/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.ats.api.util.health.HealthCheckResults;
import org.eclipse.osee.ats.rest.internal.AtsApiServerImpl;
import org.eclipse.osee.ats.rest.internal.util.AtsOperationCache;
import org.eclipse.osee.ats.rest.internal.util.health.AtsHealthCheckOperation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.orcs.OrcsApi;

public class ConvertToStateAndAssigneeAttributes
implements IAtsDatabaseConversion {
    private final AtsApiServerImpl atsApiServer;
    private final boolean debug = false;
    private final String TITLE = "Convert Current State Attrs";

    public ConvertToStateAndAssigneeAttributes(AtsApiServerImpl atsApiServer) {
        this.atsApiServer = atsApiServer;
    }

    public void run(XResultData rd, boolean reportOnly, AtsApi atsApi) {
        OrcsApi orcsApi = this.atsApiServer.getOrcsApi();
        ElapsedTime time = new ElapsedTime("Convert Current State Attrs - Loading", true);
        List artIds = orcsApi.getQueryFactory().fromBranch((BranchId)atsApi.getAtsBranch()).andIsOfType(new ArtifactTypeToken[]{AtsArtifactTypes.AbstractWorkflowArtifact}).andNotExists((AttributeTypeToken)AtsAttributeTypes.CurrentStateName).asArtifactIds();
        List artIdLists = Collections.subDivide((List)artIds, (int)1000);
        time.end();
        AtsHealthCheckOperation.TestCurrentState testCurrentState = new AtsHealthCheckOperation.TestCurrentState();
        AtsHealthCheckOperation.TestAssignees testAssignees = new AtsHealthCheckOperation.TestAssignees();
        AtsOperationCache cache = new AtsOperationCache(atsApi, false);
        HealthCheckResults checks = new HealthCheckResults();
        IAtsChangeSet changes = null;
        int x = 1;
        for (Collection artIdList : artIdLists) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {}
            OseeLog.log(ConvertToStateAndAssigneeAttributes.class, (Level)Level.INFO, (String)String.format("Processing art set %s/%s", x++, artIdLists.size()));
            if (!reportOnly) {
                AtsUser systemUser = atsApi.getUserService().getUserById((ArtifactId)AtsCoreUsers.SYSTEM_USER);
                changes = atsApi.createChangeSet("Convert Current State Attrs", systemUser);
            }
            Collection allArtifacts = atsApi.getQueryService().getArtifacts(artIdList, (BranchId)atsApi.getAtsBranch());
            for (ArtifactToken artifact : allArtifacts) {
                IAtsWorkItem workItem = atsApi.getWorkItemService().getWorkItem(artifact);
                testCurrentState.check(artifact, workItem, checks, atsApi, changes, cache);
                testAssignees.check(artifact, workItem, checks, atsApi, changes, cache);
            }
            if (reportOnly || changes.isEmpty()) continue;
            TransactionToken tx = changes.execute();
            rd.logf("Transaction %s", new Object[]{tx.getIdString()});
        }
        rd.log("Complete");
    }

    public String getDescription() {
        StringBuffer data = new StringBuffer();
        data.append("Updates ATS workflows to new ats.Current State Name and ats.Assignee(required)\n\n");
        data.append("Necessary for upgrade from 0.26.9\n\n");
        data.append("This will create new attrs as needed.\nCan be run multiple times without corruption.\nShould be run periodically on 0.26.9\n");
        return data.toString();
    }

    public String getName() {
        return "Convert to ats.Current State Name and Assignees";
    }
}

