/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.writers;

import java.util.List;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.rs.security.oauth2.common.OAuthAuthorizationData;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;
import org.eclipse.osee.jaxrs.server.internal.resources.AbstractHtmlWriter;
import org.eclipse.osee.jaxrs.server.internal.security.util.HiddenFormFields;
import org.eclipse.osee.jaxrs.server.internal.security.util.InputFields;

@Provider
public class AuthorizationDataHtmlWriter
extends AbstractHtmlWriter<OAuthAuthorizationData> {
    private static final String AUTHORIZE_PAGE__TEMPLATE = "authorize_form.html";
    private static final String AUTHORIZE_PAGE__REPLY_TO_TAG = "replyTo";
    private static final String AUTHORIZE_PAGE__DECISION_KEY_TAG = "authorizationDecisionKey";
    private static final String AUTHORIZE_PAGE__DECISION_ALLOW_TAG = "authorizationDecisionAllow";
    private static final String AUTHORIZE_PAGE__DECISION_DENY_TAG = "authorizationDecisionDeny";
    private static final String AUTHORIZE_PAGE__APPLICATION_NAME_TAG = "applicationName";
    private static final String AUTHORIZE_PAGE__APPLICATION_DESCRIPTION_TAG = "applicationDescription";
    private static final String AUTHORIZE_PAGE__APPLICATION_LOGO_URI_TAG = "applicationLogoUri";
    private static final String AUTHORIZE_PAGE__APPLICATION_WEB_URI_TAG = "applicationWebUri";
    private static final String AUTHORIZE_PAGE__LOGGED_IN_AS_TAG = "loggedInAs";
    private static final String AUTHORIZE_PAGE__HIDDEN_FIELDS_SECTION_TAG = "hiddenFieldsSection";
    private static final String AUTHORIZE_PAGE__PERMISSIONS_SECTION_TAG = "permissionsSection";

    @Override
    public Class<OAuthAuthorizationData> getSupportedClass() {
        return OAuthAuthorizationData.class;
    }

    @Override
    public ViewModel asViewModel(OAuthAuthorizationData data) {
        ViewModel model = new ViewModel(AUTHORIZE_PAGE__TEMPLATE);
        model.param(AUTHORIZE_PAGE__LOGGED_IN_AS_TAG, (Object)JaxRsUtils.asTemplateValue(data.getEndUserName()));
        model.param(AUTHORIZE_PAGE__REPLY_TO_TAG, (Object)JaxRsUtils.asTemplateValue(data.getReplyTo()));
        model.param(AUTHORIZE_PAGE__APPLICATION_NAME_TAG, (Object)JaxRsUtils.asTemplateValue(data.getApplicationName()));
        model.param(AUTHORIZE_PAGE__APPLICATION_DESCRIPTION_TAG, (Object)JaxRsUtils.asTemplateValue(data.getApplicationDescription()));
        model.param(AUTHORIZE_PAGE__APPLICATION_LOGO_URI_TAG, (Object)JaxRsUtils.asTemplateValue(data.getApplicationLogoUri()));
        model.param(AUTHORIZE_PAGE__APPLICATION_WEB_URI_TAG, (Object)JaxRsUtils.asTemplateValue(data.getApplicationWebUri()));
        model.param(AUTHORIZE_PAGE__DECISION_KEY_TAG, (Object)"oauthDecision");
        model.param(AUTHORIZE_PAGE__DECISION_ALLOW_TAG, (Object)"allow");
        model.param(AUTHORIZE_PAGE__DECISION_DENY_TAG, (Object)"deny");
        model.param(AUTHORIZE_PAGE__HIDDEN_FIELDS_SECTION_TAG, (Object)HiddenFormFields.newForm().add("audience", data.getAudience()).add("session_authenticity_token", data.getAuthenticityToken()).add("client_id", data.getClientId()).add("scope", data.getProposedScope()).add("redirect_uri", data.getRedirectUri()).add("state", data.getState()).build());
        InputFields input = InputFields.newListGroupContainer();
        List permissions = data.getPermissions();
        if (permissions.isEmpty()) {
            OAuthPermission permission = new OAuthPermission("Full Data Access", "Application is able to read/write all data.");
            permission.setDefaultPermission(true);
            this.addItem(input, permission);
        } else {
            for (OAuthPermission permission : permissions) {
                this.addItem(input, permission);
            }
        }
        model.param(AUTHORIZE_PAGE__PERMISSIONS_SECTION_TAG, (Object)input.build());
        return model;
    }

    private void addItem(InputFields input, OAuthPermission perm) {
        String permissionName = perm.getPermission();
        String key = String.format("%s_status", permissionName);
        input.add(key, InputFields.InputType.checkbox, permissionName, perm.getDescription(), "", "allow", perm.isDefaultPermission());
    }
}

