/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.executors;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.db.internal.loader.LoadSqlContext;
import org.eclipse.osee.orcs.db.internal.loader.LoadUtil;
import org.eclipse.osee.orcs.db.internal.loader.SqlObjectLoader;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaOrcsLoad;
import org.eclipse.osee.orcs.db.internal.loader.executors.AbstractLoadExecutor;
import org.eclipse.osee.orcs.db.internal.sql.join.Id4JoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class LoadExecutor
extends AbstractLoadExecutor {
    private final SqlJoinFactory joinFactory;
    private final OrcsSession session;
    private final BranchId branch;
    private final Collection<ArtifactId> artifactIds;

    public LoadExecutor(SqlObjectLoader loader, JdbcClient jdbcClient, SqlJoinFactory joinFactory, OrcsSession session, BranchId branch, Collection<ArtifactId> artifactIds) {
        super(loader, jdbcClient);
        this.joinFactory = joinFactory;
        this.session = session;
        this.branch = branch;
        this.artifactIds = artifactIds;
    }

    @Override
    public void load(HasCancellation cancellation, LoadDataHandler handler, CriteriaOrcsLoad criteria, Options options) {
        this.checkCancelled(cancellation);
        Id4JoinQuery join = this.joinFactory.createId4JoinQuery();
        TransactionId transactionId = OptionsUtil.getFromTransaction((Options)options);
        for (ArtifactId artId : this.artifactIds) {
            join.add((Id)this.branch, (Id)artId, (Id)transactionId);
        }
        LoadSqlContext loadContext = new LoadSqlContext(this.session, options, this.branch);
        int fetchSize = LoadUtil.computeFetchSize(this.artifactIds.size());
        this.getLoader().loadArtifacts(cancellation, handler, join, criteria, loadContext, fetchSize);
    }
}

