/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.jaxrs2.Reader;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class AtsApiSwaggerGenerator {
    private static final String definitionPath = "../org.eclipse.osee.web.ui/src/swagger/definitions/";
    private static final String definitionFile = "org_eclipse_osee_ats_api.json";
    private static final String infoTitle = "ATS API Endpoint Definitions";
    private static final String infoDescription = "Allows interactive support for ATS API endpoints.";
    private static final String serverUrl = "/ats";
    private static final String serverDescription = "ATS";

    public static void main(String[] args) {
        Set allClasses = Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.agile");
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.agile.jira"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.config"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.country"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.ev"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.insertion"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.metrics"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.notify"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.program"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.task"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.util"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.util.health"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.workdef"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.workflow"));
        allClasses.addAll(Lib.getAllClassesUnderPackage((String)"org.eclipse.osee.ats.api.workflow.attr"));
        HashSet<Class> swaggerClasses = new HashSet<Class>();
        for (Class clazz : allClasses) {
            if (!clazz.isAnnotationPresent(Swagger.class)) continue;
            swaggerClasses.add(clazz);
        }
        System.out.println("Creating Swagger org_eclipse_osee_ats_api.json definitions file.  Please wait...");
        OpenAPI openAPI = new Reader(new OpenAPI()).read(swaggerClasses);
        Info info = new Info();
        info.setTitle(infoTitle);
        info.setDescription(infoDescription);
        openAPI.setInfo(info);
        Server server = new Server();
        server.setUrl(serverUrl);
        server.setDescription(serverDescription);
        openAPI.addServersItem(server);
        Map<String, PathItem> taggedPaths = openAPI.getPaths().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, PathItem>((String)entry.getKey(), AtsApiSwaggerGenerator.addTagsToPathItem((String)entry.getKey(), (PathItem)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Paths paths = new Paths();
        paths.putAll(taggedPaths);
        openAPI.setPaths(paths);
        try {
            Throwable throwable = null;
            Object var9_12 = null;
            try (FileWriter fr = new FileWriter("../org.eclipse.osee.web.ui/src/swagger/definitions/org_eclipse_osee_ats_api.json");){
                fr.write(Json.mapper().writeValueAsString((Object)openAPI));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Swagger org_eclipse_osee_ats_api.json definitions file created.");
        System.out.println("");
    }

    private static PathItem addTagsToPathItem(String path, PathItem pathItem) {
        String[] pathElements = path.split("/");
        if (pathItem.getGet() != null) {
            pathItem.getGet().addTagsItem(pathElements[1]);
        }
        if (pathItem.getDelete() != null) {
            pathItem.getDelete().addTagsItem(pathElements[1]);
        }
        if (pathItem.getHead() != null) {
            pathItem.getHead().addTagsItem(pathElements[1]);
        }
        if (pathItem.getPatch() != null) {
            pathItem.getPatch().addTagsItem(pathElements[1]);
        }
        if (pathItem.getPost() != null) {
            pathItem.getPost().addTagsItem(pathElements[1]);
        }
        if (pathItem.getPut() != null) {
            pathItem.getPut().addTagsItem(pathElements[1]);
        }
        if (pathItem.getTrace() != null) {
            pathItem.getTrace().addTagsItem(pathElements[1]);
        }
        if (pathItem.getOptions() != null) {
            pathItem.getOptions().addTagsItem(pathElements[1]);
        }
        return pathItem;
    }
}

