/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.validator;

import java.util.Date;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IValueProvider;
import org.eclipse.osee.ats.api.workdef.WidgetOption;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.WidgetStatus;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workflow.transition.IAtsXWidgetValidator;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AtsXWidgetValidator
implements IAtsXWidgetValidator {
    public boolean isTransitionToComplete(StateDefinition toStateDef) {
        return toStateDef.isCompleted();
    }

    public boolean isRequiredForTransition(WidgetDefinition widgetDef) {
        return widgetDef.getOptions().contains(WidgetOption.REQUIRED_FOR_TRANSITION);
    }

    public boolean isRequiredForCompletion(WidgetDefinition widgetDef) {
        return widgetDef.getOptions().contains(WidgetOption.REQUIRED_FOR_COMPLETION);
    }

    public boolean isEmptyValue(IValueProvider provider) {
        return provider.isEmpty();
    }

    public WidgetResult validateWidgetIsRequired(IValueProvider provider, WidgetDefinition widgetDef, StateDefinition fromStateDef, StateDefinition toStateDef) {
        if (this.isRequiredForTransition(widgetDef) && this.isEmptyValue(provider)) {
            return new WidgetResult(WidgetStatus.Invalid_Incompleted, "[%s] is required for transition", new Object[]{widgetDef.getName()});
        }
        if (this.isTransitionToComplete(toStateDef) && this.isRequiredForCompletion(widgetDef) && this.isEmptyValue(provider)) {
            return new WidgetResult(WidgetStatus.Invalid_Incompleted, "[%s] is required for transition to [%s]", new Object[]{widgetDef.getName(), toStateDef.getName()});
        }
        return WidgetResult.Success;
    }

    public abstract WidgetResult validateTransition(IAtsWorkItem var1, IValueProvider var2, WidgetDefinition var3, StateDefinition var4, StateDefinition var5, AtsApi var6);

    public WidgetResult isValidDate(IValueProvider valueProvider, WidgetDefinition widgetDef) {
        if (valueProvider.getDateValues() == null) {
            return new WidgetResult(WidgetStatus.Exception, "Date Values is null", new Object[0]);
        }
        for (Date date : valueProvider.getDateValues()) {
            if (!widgetDef.is(WidgetOption.FUTURE_DATE_REQUIRED) || !date.before(new Date())) continue;
            return new WidgetResult(WidgetStatus.Invalid_Range, "[%s] value [%s] must be in future", new Object[]{valueProvider.getName(), DateUtil.get((Date)date, (String)"MM/dd/yyyy hh:mm a")});
        }
        return WidgetResult.Success;
    }

    public WidgetResult isValidFloat(IValueProvider valueProvider, WidgetDefinition widgetDef) {
        for (Object obj : valueProvider.getValues()) {
            if (obj instanceof Double) {
                return WidgetResult.Success;
            }
            if (!(obj instanceof String)) continue;
            String attrStr = (String)obj;
            if (attrStr.matches("[-+]?\\d*\\.?\\d*")) {
                WidgetResult result = this.checkValid(widgetDef, Double.parseDouble(attrStr), valueProvider.getName());
                if (result.isSuccess()) continue;
                return result;
            }
            return new WidgetResult(WidgetStatus.Invalid_Type, "[%s] value [%s] is not a valid float", new Object[]{valueProvider.getName(), attrStr});
        }
        return WidgetResult.Success;
    }

    public WidgetResult isValidInteger(IValueProvider valueProvider, WidgetDefinition widgetDef) {
        for (Object obj : valueProvider.getValues()) {
            if (obj instanceof Integer) {
                return WidgetResult.Success;
            }
            if (!(obj instanceof String)) continue;
            String attrStr = (String)obj;
            if (Strings.isValid((String)attrStr)) {
                WidgetResult result = this.checkValid(widgetDef, Integer.parseInt(attrStr), valueProvider.getName());
                if (result.isSuccess()) continue;
                return result;
            }
            return new WidgetResult(WidgetStatus.Invalid_Type, "[%s] value [%s] is not a valid integer", new Object[]{valueProvider.getName(), attrStr});
        }
        return WidgetResult.Success;
    }

    private WidgetResult checkValid(WidgetDefinition widgetDef, double value, String valueProviderName) {
        Double minValue = widgetDef.getMin();
        Double maxValue = widgetDef.getMax();
        if (minValue != null && Lib.lessThan((double)value, (double)minValue)) {
            return new WidgetResult(WidgetStatus.Invalid_Range, "[%s] value [%s] must be >= [%s]", new Object[]{valueProviderName, value, minValue});
        }
        if (maxValue != null && Lib.greaterThan((double)value, (double)maxValue)) {
            return new WidgetResult(WidgetStatus.Invalid_Range, "[%s] value [%s] must be <= [%s]", new Object[]{valueProviderName, value, minValue, maxValue});
        }
        return WidgetResult.Success;
    }

    public WidgetResult isValidList(IValueProvider valueProvider, WidgetDefinition widgetDef) {
        return this.checkValid(widgetDef, valueProvider.getValues().size(), valueProvider.getName());
    }
}

