/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.review;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.core.workflow.WorkItem;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.logger.Log;

public abstract class AbstractReview
extends WorkItem
implements IAtsAbstractReview {
    public AbstractReview(Log logger, AtsApi atsApi, ArtifactToken artifact, ArtifactTypeToken artifactType) {
        super(logger, atsApi, artifact, artifactType);
    }

    public Set<IAtsActionableItem> getActionableItems() {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        Collection artifactIds = this.atsApi.getAttributeResolver().getAttributeValues((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference);
        for (ArtifactId aiId : artifactIds) {
            IAtsActionableItem ai = (IAtsActionableItem)this.atsApi.getConfigService().getConfigurations().getIdToAi().get(aiId.getId());
            if (ai == null) {
                ArtifactId aiArt = (ArtifactId)this.atsApi.getQueryService().getConfigItem(aiId);
                ai = this.atsApi.getActionableItemService().getActionableItemById(aiArt);
            }
            ais.add(ai);
        }
        return ais;
    }

    public boolean isStandAloneReview() {
        return !this.getActionableItems().isEmpty();
    }

    public String getRelatedToState() {
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.RelatedToState, (Object)"");
    }
}

