/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.ds.DynamicObject;

public class DynamicData
extends BaseIdentity<String>
implements Named {
    private static final String FIELD_NAME = "field.name";
    private static final String IS_HIDDEN = "is.hidden";
    private static final String IS_PRIMARY = "is.primary";
    private static String LEVEL = "field.level";
    private final String alias;
    private DynamicObject parent;
    private Map<String, Object> properties;

    public DynamicData(String uid, String alias) {
        super((Object)uid);
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isAliasValid() {
        return Strings.isValid((String)this.getAlias());
    }

    public String getName() {
        return this.isAliasValid() ? this.getAlias() : this.getFieldName();
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void setParent(DynamicObject parent) {
        Conditions.checkExpressionFailOnTrue((this == parent ? 1 : 0) != 0, (String)"Cannot assign self as parent - parent [%s] child [%s]", (Object[])new Object[]{this, parent});
        this.parent = parent;
    }

    public DynamicObject getParent() {
        return this.parent;
    }

    public <T> T getObject(String key) {
        return (T)(this.properties != null ? this.properties.get(key) : null);
    }

    public void put(String key, Object value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        this.properties.put(key, value);
    }

    public boolean isHidden() {
        return (Boolean)this.getObject(IS_HIDDEN);
    }

    public boolean isPrimaryKey() {
        return (Boolean)this.getObject(IS_PRIMARY);
    }

    public void setHidden(boolean hidden) {
        this.put(IS_HIDDEN, hidden);
    }

    public void setPrimaryKey(boolean primary) {
        this.put(IS_PRIMARY, primary);
    }

    public String getFieldName() {
        return (String)this.getObject(FIELD_NAME);
    }

    public void setFieldName(String fieldName) {
        this.put(FIELD_NAME, fieldName);
    }

    public Integer getLevel() {
        return (Integer)this.getObject(LEVEL);
    }

    public void setLevel(int level) {
        this.put(LEVEL, level);
    }

    public String toString() {
        return "DynamicData [name=" + this.getName() + ", parent=" + (Object)((Object)this.parent) + ", props=" + this.properties + "]";
    }
}

