/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.dto;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;

public class HelpPageDto {
    private ArtifactId id = ArtifactId.SENTINEL;
    private String name = "";
    private String markdownContent = "";
    private String appName = "";
    private boolean isHeader = false;
    private boolean isTraining = false;
    private List<HelpPageDto> children = new LinkedList<HelpPageDto>();

    public HelpPageDto() {
    }

    public HelpPageDto(ArtifactReadable art) {
        if (art.isValid()) {
            this.setId(ArtifactId.valueOf((Long)art.getId()));
            this.setName(art.getName());
            this.setMarkdownContent(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.MarkdownContent, ""));
            this.setAppName(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ApplicationName, ""));
            this.setHeader((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.IsHelpPageHeader, (Object)false));
            this.setTraining((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.IsTrainingPage, (Object)false));
            if (this.isHeader()) {
                this.setChildren(art.getRelated(CoreRelationTypes.HelpToHelp_Child).getList().stream().map(a -> new HelpPageDto((ArtifactReadable)a)).collect(Collectors.toList()));
            }
        }
    }

    public ArtifactId getId() {
        return this.id;
    }

    public void setId(ArtifactId id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMarkdownContent() {
        return this.markdownContent;
    }

    public void setMarkdownContent(String markdownContent) {
        this.markdownContent = markdownContent;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public void setHeader(boolean isHeader) {
        this.isHeader = isHeader;
    }

    public boolean isTraining() {
        return this.isTraining;
    }

    public void setTraining(boolean isTraining) {
        this.isTraining = isTraining;
    }

    public List<HelpPageDto> getChildren() {
        return this.children;
    }

    public void setChildren(List<HelpPageDto> children) {
        this.children = children;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HelpPageDto) {
            return this.getId().equals(((HelpPageDto)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

