/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.regex;

import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.util.regex.TokenMatcher;

public class TokenPattern {
    private static final int regexOptions = 42;
    private final Boolean prefixSuffixRequired;
    private final Pattern prefixPattern;
    private final Pattern coreTokenPattern;
    private final Pattern suffixPattern;

    private TokenPattern(Boolean prefixSuffixRequired, Pattern prefixPattern, Pattern coreTokenPattern, Pattern suffixPattern) {
        this.prefixSuffixRequired = prefixSuffixRequired;
        this.prefixPattern = prefixPattern;
        this.coreTokenPattern = coreTokenPattern;
        this.suffixPattern = suffixPattern;
    }

    public static TokenPattern compile(Boolean prefixSuffixRequired, String prefixRegexp, String coreTokenRegexp, String suffixRegexp) {
        Objects.requireNonNull(prefixSuffixRequired, "TokenMatcher::new, parameter \"prefixSuffixRequired\" cannot be null.");
        Objects.requireNonNull(prefixRegexp, "TokenMatcher::new, parameter \"prefixRegexp\" cannot be null.");
        Objects.requireNonNull(coreTokenRegexp, "TokenMatcher::new, parameter \"coreTokenRegexp\" cannot be null.");
        Objects.requireNonNull(suffixRegexp, "TokenMatcher::new, parameter \"suffixRegexp\" cannot be null.");
        Pattern prefixPattern = TokenPattern.compilePattern(prefixRegexp);
        Pattern coreTokenPattern = TokenPattern.compilePattern(coreTokenRegexp);
        Pattern suffixPattern = TokenPattern.compilePattern(suffixRegexp);
        return new TokenPattern(prefixSuffixRequired, prefixPattern, coreTokenPattern, suffixPattern);
    }

    private static Pattern compilePattern(String regexp) {
        return Pattern.compile(regexp, 42);
    }

    public TokenMatcher tokenMatcher(CharSequence input) {
        return new TokenMatcher(input, this.prefixSuffixRequired, new Function<CharSequence, Matcher>(){

            @Override
            public Matcher apply(CharSequence charSequence) {
                return TokenPattern.this.prefixPattern.matcher(charSequence);
            }
        }, new Function<CharSequence, Matcher>(){

            @Override
            public Matcher apply(CharSequence charSequence) {
                return TokenPattern.this.coreTokenPattern.matcher(charSequence);
            }
        }, new Function<CharSequence, Matcher>(){

            @Override
            public Matcher apply(CharSequence charSequence) {
                return TokenPattern.this.suffixPattern.matcher(charSequence);
            }
        });
    }
}

