/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.shell;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.felix.gogo.shell.Builtin;
import org.apache.felix.gogo.shell.Converters;
import org.apache.felix.gogo.shell.Posix;
import org.apache.felix.gogo.shell.Procedural;
import org.apache.felix.gogo.shell.Shell;
import org.apache.felix.gogo.shell.Telnet;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Converter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private BundleContext context;
    private ServiceTracker commandProcessorTracker;
    private Set<ServiceRegistration> regs = new HashSet<ServiceRegistration>();
    private volatile ExecutorService executor;
    private volatile StartShellJob shellJob;

    public void start(BundleContext context) {
        this.context = context;
        this.commandProcessorTracker = this.createCommandProcessorTracker();
        this.commandProcessorTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) {
        HashSet<ServiceRegistration> currentRegs;
        Set<ServiceRegistration> set = this.regs;
        synchronized (set) {
            currentRegs = new HashSet<ServiceRegistration>(this.regs);
            this.regs.clear();
        }
        for (ServiceRegistration reg : currentRegs) {
            reg.unregister();
        }
        this.commandProcessorTracker.close();
        this.stopShell();
    }

    private ServiceTracker<CommandProcessor, CommandProcessor> createCommandProcessorTracker() {
        return new ServiceTracker<CommandProcessor, CommandProcessor>(this.context, CommandProcessor.class, null){

            public CommandProcessor addingService(ServiceReference<CommandProcessor> reference) {
                CommandProcessor processor = (CommandProcessor)super.addingService(reference);
                Activator.this.startShell(this.context, processor);
                return processor;
            }

            public void removedService(ServiceReference<CommandProcessor> reference, CommandProcessor service) {
                Activator.this.stopShell();
                super.removedService(reference, (Object)service);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startShell(BundleContext context, CommandProcessor processor) {
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("osgi.command.scope", "gogo");
        HashSet<ServiceRegistration> currentRegs = new HashSet<ServiceRegistration>();
        currentRegs.add(context.registerService(Converter.class.getName(), (Object)new Converters(context.getBundle(0L).getBundleContext()), null));
        ((Dictionary)dict).put("osgi.command.function", Builtin.functions);
        currentRegs.add(context.registerService(Builtin.class.getName(), (Object)new Builtin(), dict));
        ((Dictionary)dict).put("osgi.command.function", Procedural.functions);
        currentRegs.add(context.registerService(Procedural.class.getName(), (Object)new Procedural(), dict));
        ((Dictionary)dict).put("osgi.command.function", Posix.functions);
        currentRegs.add(context.registerService(Posix.class.getName(), (Object)new Posix(), dict));
        ((Dictionary)dict).put("osgi.command.function", Telnet.functions);
        currentRegs.add(context.registerService(Telnet.class.getName(), (Object)new Telnet(processor), dict));
        Shell shell = new Shell(context, processor);
        ((Dictionary)dict).put("osgi.command.function", Shell.functions);
        currentRegs.add(context.registerService(Shell.class.getName(), (Object)shell, dict));
        Set<ServiceRegistration> set = this.regs;
        synchronized (set) {
            this.regs.addAll(currentRegs);
            currentRegs.clear();
        }
        this.executor = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "Gogo shell"));
        this.shellJob = new StartShellJob(context, processor);
        this.executor.submit(this.shellJob);
    }

    private void stopShell() {
        if (this.executor != null && !this.executor.isShutdown() && !this.executor.isTerminated()) {
            if (this.shellJob != null) {
                this.shellJob.terminate();
            }
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    System.err.println("!!! FAILED TO STOP EXECUTOR !!!");
                    Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
                    for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
                        Thread t = entry.getKey();
                        System.err.printf("Thread: %s (%s): %s\n", new Object[]{t.getName(), t.getState(), Arrays.toString(entry.getValue())});
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.executor = null;
        }
    }

    private static class StartShellJob
    implements Runnable {
        private final BundleContext context;
        private final CommandProcessor processor;
        private volatile CommandSession session;

        public StartShellJob(BundleContext context, CommandProcessor processor) {
            this.context = context;
            this.processor = processor;
        }

        @Override
        public void run() {
            this.session = this.processor.createSession((InputStream)new FileInputStream(FileDescriptor.in), (OutputStream)new FileOutputStream(FileDescriptor.out), (OutputStream)new FileOutputStream(FileDescriptor.err));
            try {
                for (int i = 0; i < 100 && this.session.get("gogo:gosh") == null; ++i) {
                    TimeUnit.MILLISECONDS.sleep(10L);
                }
                String args = this.context.getProperty("gosh.args");
                args = args == null ? "" : args;
                this.session.execute((CharSequence)("gosh --login " + args));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                Object loc = this.session.get(".location");
                if (null == loc || !loc.toString().contains(":")) {
                    loc = "gogo";
                }
                System.err.println(loc + ": " + e.getClass().getSimpleName() + ": " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                this.terminate();
            }
        }

        public void terminate() {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            Thread.currentThread().interrupt();
        }
    }
}

