/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.reqifsynchronizationartifactbuilder;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.ForeignThingFamily;
import org.eclipse.osee.define.operations.synchronization.SimpleForeignThingFamily;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.reqifsynchronizationartifactbuilder.ReqIFSynchronizationArtifactBuilder;
import org.eclipse.osee.define.operations.synchronization.reqifsynchronizationartifactbuilder.SpecTypeUtils;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeDefinitionDate;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinitionBoolean;

public class AttributeDefinitionUtils {
    private AttributeDefinitionUtils() {
    }

    public static Optional<String> getDatatypeDefinitionIdentifier(AttributeDefinition attributeDefinition) {
        DatatypeDefinitionBoolean datatypeDefinition = attributeDefinition instanceof AttributeDefinitionBoolean ? ((AttributeDefinitionBoolean)attributeDefinition).getType() : (attributeDefinition instanceof AttributeDefinitionDate ? ((AttributeDefinitionDate)attributeDefinition).getType() : (attributeDefinition instanceof AttributeDefinitionEnumeration ? ((AttributeDefinitionEnumeration)attributeDefinition).getType() : (attributeDefinition instanceof AttributeDefinitionInteger ? ((AttributeDefinitionInteger)attributeDefinition).getType() : (attributeDefinition instanceof AttributeDefinitionReal ? ((AttributeDefinitionReal)attributeDefinition).getType() : (attributeDefinition instanceof AttributeDefinitionString ? ((AttributeDefinitionString)attributeDefinition).getType() : (attributeDefinition instanceof AttributeDefinitionXHTML ? ((AttributeDefinitionXHTML)attributeDefinition).getType() : null))))));
        return Objects.nonNull(datatypeDefinition) ? Optional.ofNullable(datatypeDefinition.getIdentifier()) : Optional.empty();
    }

    static Stream<ForeignThingFamily> extract(ReqIFSynchronizationArtifactBuilder builder) {
        return builder.reqIf.getCoreContent().getSpecTypes().stream().flatMap(specType -> {
            IdentifierType specTypeIdentifierType = SpecTypeUtils.getIdentifierType(specType).orElseThrow();
            return specType.getSpecAttributes().stream().map(specAttribute -> new SimpleForeignThingFamily(specAttribute, new String[]{specType.getIdentifier(), specAttribute.getIdentifier()}, new IdentifierType[]{specTypeIdentifierType, IdentifierType.ATTRIBUTE_DEFINITION}));
        });
    }
}

