/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.cr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstDefinition;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstUtil;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class CreateSiblingOffTaskEstOperation {
    private final IAtsTeamWorkflow teamWf;
    private final AtsApi atsApi;
    private final Collection<TaskEstDefinition> taskEstDefs;
    private boolean debug = false;

    public CreateSiblingOffTaskEstOperation(IAtsTeamWorkflow teamWf, Collection<TaskEstDefinition> taskEstDefs) {
        this.teamWf = teamWf;
        this.taskEstDefs = taskEstDefs;
        this.atsApi = AtsApiService.get();
    }

    public XResultData run() {
        XResultData rd = new XResultData();
        try {
            ArrayList<TaskEstDefinition> teds = new ArrayList<TaskEstDefinition>();
            teds.addAll(this.taskEstDefs);
            for (TaskEstDefinition ted : new CopyOnWriteArrayList(teds)) {
                IAtsTask task;
                if (!TaskEstUtil.hasTask((IAtsTeamWorkflow)this.teamWf, (TaskEstDefinition)ted, (AtsApi)this.atsApi)) {
                    teds.remove(ted);
                    if (this.isDebug()) {
                        rd.logf("Task Est Def [%s] has no estimating task\n", new Object[]{ted.toStringWithId()});
                    }
                }
                if (!(task = TaskEstUtil.getTask((IAtsTeamWorkflow)this.teamWf, (TaskEstDefinition)ted, (AtsApi)this.atsApi)).isValid()) continue;
                if (task.isCancelled()) {
                    teds.remove(ted);
                    continue;
                }
                String ptsStr = this.atsApi.getAgileService().getPointsStr((IAtsWorkItem)task);
                if (!Strings.isValid((String)ptsStr)) {
                    rd.errorf("No estimated points for task %s\n", new Object[]{task.toStringWithId()});
                    teds.remove(ted);
                    continue;
                }
                if (!Strings.isNumeric((String)ptsStr)) {
                    rd.errorf("Estimated points non-numeric for task %s\n", new Object[]{task.toStringWithId()});
                    teds.remove(ted);
                    continue;
                }
                Double pts = Double.valueOf(ptsStr);
                if (pts > 0.0) {
                    if (!TaskEstUtil.hasWorkflow((IAtsTeamWorkflow)this.teamWf, (TaskEstDefinition)ted, (AtsApi)this.atsApi)) continue;
                    if (this.isDebug()) {
                        rd.logf("Workflow exists for task %s; skipping\n", new Object[]{task.toStringWithId()});
                    }
                    teds.remove(ted);
                    continue;
                }
                if (this.isDebug()) {
                    rd.logf("Estimate 0 for task %s; skipping\n", new Object[]{task.toStringWithId()});
                }
                teds.remove(ted);
            }
            for (TaskEstDefinition ted : new CopyOnWriteArrayList(teds)) {
                ArtifactToken aiTok = ted.getActionableItem();
                if (aiTok != null && !aiTok.isInvalid()) continue;
                rd.errorf("Configured AI invalid for Task Def [%s]\n", new Object[]{ted.toStringWithId()});
                teds.remove(ted);
            }
            if (teds.isEmpty()) {
                rd.errorf("No Workflows To Create\n", new Object[0]);
                return rd;
            }
            this.createWorkflowsOfTeds(teds, rd);
        }
        catch (Exception ex) {
            rd.error("Error Creating Sibling workflows " + Lib.exceptionToString((Exception)ex));
        }
        return rd;
    }

    private void createWorkflowsOfTeds(List<TaskEstDefinition> teds, XResultData rd) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Create Workflows off CR");
        Date createdDate = new Date();
        ArrayList<IAtsTeamWorkflow> workflows = new ArrayList<IAtsTeamWorkflow>();
        for (TaskEstDefinition ted : teds) {
            IAtsTask task = TaskEstUtil.getTask((IAtsTeamWorkflow)this.teamWf, (TaskEstDefinition)ted, (AtsApi)this.atsApi);
            ArtifactToken aiTok = ted.getActionableItem();
            ActionableItem ai = this.atsApi.getActionableItemService().getActionableItemById((ArtifactId)aiTok);
            IAtsTeamDefinition teamDef = this.atsApi.getActionableItemService().getTeamDefinitionInherited((IAtsActionableItem)ai);
            List assignees = task.getImplementers();
            IAtsTeamWorkflow newTeamWf = CreateSiblingOffTaskEstOperation.createTaskEstSiblingWorkflow(rd, changes, createdDate, task, (IAtsActionableItem)ai, teamDef, assignees, this.teamWf.getParentAction(), this.atsApi);
            workflows.add(newTeamWf);
        }
        changes.executeIfNeeded();
    }

    public static IAtsTeamWorkflow createTaskEstSiblingWorkflow(XResultData rd, IAtsChangeSet changes, Date createdDate, IAtsTask task, IAtsActionableItem ai, IAtsTeamDefinition teamDef, List<AtsUser> assignees, IAtsAction action, AtsApi atsApi) {
        IAtsTeamWorkflow newTeamWf = AtsApiService.get().getActionService().createTeamWorkflow(action, teamDef, Arrays.asList(ai), new LinkedList<AtsUser>(assignees), changes, createdDate, atsApi.getUserService().getCurrentUser(), null, new CreateTeamOption[]{CreateTeamOption.Duplicate_If_Exists});
        rd.logf("Created new Team Workflow for task %s\n", new Object[]{task.toStringWithId()});
        AttributeTypeToken pointsAttrType = atsApi.getAgileService().getPointsAttrType((IAtsWorkItem)newTeamWf);
        String ptsStr = atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)task, pointsAttrType, "");
        if (pointsAttrType.isDouble()) {
            changes.setSoleAttributeValue((IAtsObject)newTeamWf, pointsAttrType, (Object)Double.valueOf(ptsStr));
        } else {
            changes.setSoleAttributeValue((IAtsWorkItem)newTeamWf, pointsAttrType, ptsStr);
        }
        changes.relate((Object)task, AtsRelationTypes.Derive_To, (Object)newTeamWf);
        changes.addAttribute((IAtsObject)task, (AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)TaskEstUtil.TASK_EST_STATIC_ID);
        return newTeamWf;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

