/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.model;

import java.util.Date;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.ev.AtsWorkPackageType;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.core.model.impl.AtsConfigObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.logger.Log;

public class WorkPackage
extends AtsConfigObject
implements IAtsWorkPackage {
    private ArtifactToken artifact;
    private final AtsApi atsApi;

    public WorkPackage(Log logger, AtsApi atsApi, ArtifactToken artifact) {
        super(logger, atsApi, artifact, AtsArtifactTypes.WorkPackage);
        this.artifact = artifact;
        this.atsApi = atsApi;
    }

    public String getActivityId() {
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.ActivityId, (Object)"");
    }

    public String getActivityName() {
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.ActivityName, (Object)"");
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getWorkPackageId() {
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.WorkPackageId, (Object)"");
    }

    public String getWorkPackageProgram() {
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.WorkPackageProgram, (Object)"");
    }

    public AtsWorkPackageType getWorkPackageType() {
        String value = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.WorkPackageType, (Object)"");
        AtsWorkPackageType type = AtsWorkPackageType.None;
        if (Strings.isValid((String)value)) {
            try {
                type = AtsWorkPackageType.valueOf((String)value);
                return type;
            }
            catch (Exception exception) {}
        }
        return type;
    }

    @Override
    public boolean isActive() {
        return (Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.Active, (Object)true);
    }

    public Date getStartDate() {
        return (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.StartDate, null);
    }

    public Date getEndDate() {
        return (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.EndDate, null);
    }

    public int getWorkPackagePercent() {
        return (Integer)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.PercentComplete, (Object)0);
    }

    public String toString() {
        try {
            StringBuilder builder = new StringBuilder(this.getActivityId());
            this.addWithHypen(builder, this.getActivityName());
            this.addWithHypen(builder, this.getWorkPackageId());
            this.addWithHypen(builder, this.getName());
            return builder.toString();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(WorkPackage.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return String.format("%s - Exception (see log file)", this.getName());
        }
    }

    private void addWithHypen(StringBuilder builder, String value) {
        if (Strings.isValid((String)value)) {
            builder.append(" - ");
            builder.append(value);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        super.equals(obj);
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IAtsWorkPackage other = (IAtsWorkPackage)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Override
    public Long getId() {
        return this.artifact.getId();
    }

    @Override
    public ArtifactToken getStoreObject() {
        return this.artifact;
    }

    @Override
    public void setStoreObject(ArtifactToken artifact) {
        this.artifact = artifact;
    }

    public int compareTo(Named other) {
        return this.artifact.compareTo(other);
    }
}

