/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.commit.operations;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.commit.CommitOverride;
import org.eclipse.osee.ats.api.commit.CommitOverrideOperations;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.util.Result;

public class CommitOverrideOperationsImpl
implements CommitOverrideOperations {
    private final AtsApi atsApi;
    private ObjectMapper mapper;

    public CommitOverrideOperationsImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public CommitOverride getCommitOverride(IAtsTeamWorkflow teamWf, BranchId branch) {
        for (CommitOverride override : this.getCommitOverrides(teamWf)) {
            if (!override.getBranchId().equals(branch.getIdString())) continue;
            return override;
        }
        return null;
    }

    public Collection<CommitOverride> getCommitOverrides(IAtsTeamWorkflow teamWf) {
        ObjectMapper mapper = this.getObjectMapper();
        LinkedList<CommitOverride> overrides = new LinkedList<CommitOverride>();
        for (String overrideAttr : this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.CommitOverride)) {
            try {
                CommitOverride override = (CommitOverride)mapper.readValue(overrideAttr, CommitOverride.class);
                overrides.add(override);
            }
            catch (Exception ex) {
                this.atsApi.getLogger().error("Error reading json Commit Override for %s.  Value: [%s] Exception %s", new Object[]{teamWf.toStringWithId(), overrideAttr, ex.getMessage()});
            }
        }
        return overrides;
    }

    protected ObjectMapper getObjectMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
        return this.mapper;
    }

    public Result setCommitOverride(IAtsTeamWorkflow teamWf, BranchId branch, String reason) {
        this.atsApi.getStoreService().reload(Collections.singleton(teamWf));
        if (this.getCommitOverride(teamWf, branch) != null) {
            return new Result(false, String.format("Commit Override already set for branch [%s]", branch.getIdString()));
        }
        CommitOverride override = CommitOverride.valueOf((UserId)UserId.valueOf((Long)this.atsApi.getUserService().getCurrentUser().getStoreObject().getId()), (BranchId)branch, (String)reason);
        ObjectMapper mapper = this.getObjectMapper();
        try {
            IAtsChangeSet changes = this.atsApi.createChangeSet("Set Commit Override");
            String jsonStr = mapper.writeValueAsString((Object)override);
            changes.addAttribute((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.CommitOverride, (Object)jsonStr);
            changes.execute();
        }
        catch (Exception ex) {
            return new Result(false, String.format("Commit Override failed for [%s].  Exception %s", branch.getIdString(), ex.getMessage()));
        }
        return Result.TrueResult;
    }

    public Result removeCommitOverride(IAtsTeamWorkflow teamWf, BranchId branch) {
        this.atsApi.getStoreService().reload(Collections.singleton(teamWf));
        CommitOverride override = this.getCommitOverride(teamWf, branch);
        if (override == null) {
            return new Result(false, String.format("Commit Override not set for branch [%s]", branch.getIdString()));
        }
        try {
            IAtsChangeSet changes = this.atsApi.createChangeSet("Remove Commit Override");
            for (IAttribute attr : this.atsApi.getAttributeResolver().getAttributes((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.CommitOverride)) {
                String jsonValue = (String)attr.getValue();
                CommitOverride or = (CommitOverride)this.mapper.readValue(jsonValue, CommitOverride.class);
                if (!or.getBranchId().equals(branch.getIdString())) continue;
                changes.deleteAttribute((IAtsWorkItem)teamWf, attr);
            }
            changes.execute();
        }
        catch (Exception ex) {
            return new Result(false, String.format("Commit Override failed for branch [%s].  Exception %s", branch.getIdString(), ex.getMessage()));
        }
        return Result.TrueResult;
    }
}

