/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workflow.transition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TransitionWorkItemResult {
    private ArtifactToken workItemId;
    private String workItemType;
    private String atsId;
    private List<TransitionResult> transitionResults = new ArrayList<TransitionResult>();

    public void addResult(TransitionResult result) {
        this.transitionResults.add(result);
    }

    @JsonIgnore
    public void clear() {
        this.transitionResults.clear();
    }

    public boolean isEmpty() {
        return this.transitionResults.isEmpty();
    }

    public boolean contains(String string) {
        return this.toString().contains(string);
    }

    public boolean contains(TransitionResult transitionResult) {
        return this.transitionResults.contains(transitionResult);
    }

    @JsonIgnore
    public boolean isErrors() {
        return !this.isEmpty();
    }

    @JsonIgnore
    public boolean isSuccess() {
        return this.isEmpty();
    }

    @JsonIgnore
    public String getResultString() {
        if (this.transitionResults.isEmpty()) {
            return "<Empty>";
        }
        StringBuffer sb = new StringBuffer();
        if (Strings.isValid((String)this.workItemType)) {
            sb.append(this.workItemType);
        } else {
            sb.append("Work Item");
        }
        sb.append(" [");
        sb.append(this.atsId);
        sb.append("] Titled [");
        sb.append(this.workItemId.getName());
        sb.append("]\n\n");
        this.appendResultsString(sb, this.transitionResults);
        return sb.toString();
    }

    public void appendResultsString(StringBuffer sb, List<TransitionResult> results) {
        for (TransitionResult result : results) {
            sb.append("    - ");
            sb.append(result.getDetails());
            if (result.getException() != null && Strings.isValid((String)result.getException())) {
                sb.append(" - Exception [");
                sb.append(result.getException());
                sb.append("] (see log for details)");
            }
            sb.append("\n");
        }
    }

    public String toString() {
        return this.getResultString();
    }

    public List<TransitionResult> getResults() {
        return this.transitionResults;
    }

    void setResults(List<TransitionResult> transitionResults) {
        this.transitionResults = transitionResults;
    }

    public void setWorkItem(IAtsWorkItem workItem) {
        this.workItemType = workItem.getArtifactTypeName();
        this.atsId = workItem.getAtsId();
        this.workItemId = ArtifactToken.valueOf((long)workItem.getId(), (String)workItem.getName());
    }

    public ArtifactToken getWorkItemId() {
        return this.workItemId;
    }

    public void setWorkItemId(ArtifactToken workItemId) {
        this.workItemId = workItemId;
    }

    public String getWorkItemType() {
        return this.workItemType;
    }

    public void setWorkItemType(String workItemType) {
        this.workItemType = workItemType;
    }

    public String getAtsId() {
        return this.atsId;
    }

    public void setAtsId(String atsId) {
        this.atsId = atsId;
    }
}

