/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workflow;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.framework.jdk.core.type.NamedBase;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class WorkState
extends NamedBase {
    private String name;
    private final List<AtsUser> assignees = new LinkedList<AtsUser>();
    private double hoursSpent = 0.0;
    private int percentComplete = 0;

    private WorkState(String name, List<? extends AtsUser> assignees, double hoursSpent, int percentComplete) {
        this.name = name;
        this.assignees.addAll(assignees);
        this.hoursSpent = hoursSpent;
        this.percentComplete = percentComplete;
    }

    public void setHoursSpent(double hoursSpent) {
        this.hoursSpent = hoursSpent;
    }

    public void setPercentComplete(int percentComplete) {
        this.percentComplete = percentComplete;
    }

    public String getName() {
        return this.name;
    }

    public List<AtsUser> getAssignees() {
        return this.assignees;
    }

    public double getHoursSpent() {
        return this.hoursSpent;
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public void addAssignee(AtsUser user) {
        Conditions.checkNotNull((Object)user, (String)"user");
        if (!this.assignees.contains(user)) {
            this.assignees.add(user);
        }
    }

    public void setAssignees(List<? extends AtsUser> users) {
        this.assignees.clear();
        for (AtsUser atsUser : users) {
            this.addAssignee(atsUser);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void removeAssignee(AtsUser assignee) {
        this.assignees.remove(assignee);
    }

    public static WorkState create(String name, List<? extends AtsUser> assignees, double hoursSpent, int percentComplete) {
        return new WorkState(name, assignees, hoursSpent, percentComplete);
    }

    public static WorkState create(String name) {
        return new WorkState(name, Collections.emptyList(), 0.0, 0);
    }

    public static WorkState create(String name, List<? extends AtsUser> assignees) {
        Conditions.checkNotNullOrContainNull(assignees, (String)"assignees");
        return new WorkState(name, assignees, 0.0, 0);
    }
}

