/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;

public class ResultSetIterable<T>
implements ResultSet<T> {
    private Iterable<T> data;

    protected ResultSetIterable(Iterable<T> iterable) {
        this.data = iterable;
    }

    @Override
    public T getOneOrDefault(T defaultVal) {
        int size = this.size();
        if (size > 0) {
            defaultVal = this.iterator().next();
        }
        return defaultVal;
    }

    @Override
    public T getAtMostOneOrDefault(T defaultVal) {
        int size = this.size();
        if (size > 1) {
            throw this.createManyExistException(size);
        }
        if (size == 1) {
            defaultVal = this.iterator().next();
        }
        return defaultVal;
    }

    private Iterable<T> getData() {
        return this.data;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getData().iterator();
    }

    @Override
    public int size() {
        Iterable<T> it = this.getData();
        int count = 0;
        if (it instanceof Collection) {
            count = ((Collection)it).size();
        } else {
            count = 0;
            Iterator<T> iterator = it.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        Iterable<T> it = this.getData();
        return it == null || !it.iterator().hasNext();
    }

    protected OseeCoreException createManyExistException(int count) {
        return new MultipleItemsExist("Multiple items found - total [%s]", count);
    }

    protected OseeCoreException createDoesNotExistException() {
        return new ItemDoesNotExist("No item found", new Object[0]);
    }

    @Override
    public ResultSet<T> sort(Comparator<T> comparator) {
        List<T> list = this.getList();
        Collections.sort(list, comparator);
        this.data = list;
        return this;
    }

    @Override
    public List<T> getList() {
        LinkedList<T> items = new LinkedList<T>();
        for (T obj : this.data) {
            items.add(obj);
        }
        return items;
    }

    @Override
    public T getOneOrNull() {
        T result = null;
        int size = this.size();
        if (size > 0) {
            result = this.iterator().next();
        }
        return result;
    }

    @Override
    public T getExactlyOne() {
        T result = this.getAtMostOneOrNull();
        if (result == null) {
            throw this.createDoesNotExistException();
        }
        return result;
    }

    @Override
    public T getAtMostOneOrNull() {
        T result = null;
        int size = this.size();
        if (size > 1) {
            throw this.createManyExistException(size);
        }
        if (size == 1) {
            result = this.iterator().next();
        }
        return result;
    }
}

