/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health;

import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.health.HealthLinks;
import org.eclipse.osee.orcs.health.ServerStatus;
import org.eclipse.osee.orcs.rest.internal.health.operations.BuildServerStatusOperation;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerHealthActiveMq;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerHealthBalancers;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerHealthExec;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerHealthLinks;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerHealthLogs;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerHealthMain;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerHealthOverview;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerHealthOverviewDetails;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerHealthProcesses;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerHealthTypes;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerHealthUsage;

@Path(value="/health")
public final class ServerHealthEndpointImpl {
    private final IApplicationServerManager applicationServerManager;
    private final IAuthenticationManager authManager;
    private final ActivityLog activityLog;
    private final OrcsApi orcsApi;
    private final Map<String, JdbcService> jdbcServices;

    public ServerHealthEndpointImpl(OrcsApi orcsApi, IApplicationServerManager applicationServerManager, Map<String, JdbcService> jdbcServices, IAuthenticationManager authManager, ActivityLog activityLog) {
        this.orcsApi = orcsApi;
        this.applicationServerManager = applicationServerManager;
        this.jdbcServices = jdbcServices;
        this.authManager = authManager;
        this.activityLog = activityLog;
    }

    @GET
    @Produces(value={"text/html"})
    public String get() {
        ServerHealthMain main = new ServerHealthMain(this.orcsApi, this.getJdbcClient());
        return main.getHtml();
    }

    @GET
    @Path(value="usage")
    @Produces(value={"text/html"})
    public String getUsage(@Context UriInfo uriInfo) {
        ServerHealthUsage ops = new ServerHealthUsage(uriInfo, this.orcsApi, this.getJdbcClient());
        return ops.getHtml();
    }

    @GET
    @Path(value="links")
    @Produces(value={"application/json"})
    public HealthLinks getLinks() {
        ServerHealthLinks links = new ServerHealthLinks(this.orcsApi);
        return links.getLinks();
    }

    @GET
    @Path(value="headers")
    @Produces(value={"text/html"})
    public String getAllHeaders(@Context HttpHeaders headers) {
        MultivaluedMap rh = headers.getRequestHeaders();
        return rh.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + " = " + e.getValue()).collect(Collectors.joining("<br/>"));
    }

    @GET
    @Path(value="activemq")
    @Produces(value={"text/html"})
    public String getActiveMq() {
        ServerHealthActiveMq amq = new ServerHealthActiveMq(this.applicationServerManager, this.getJdbcClient());
        return amq.getHtml();
    }

    @GET
    @Path(value="overview")
    @Produces(value={"text/html"})
    public String getServerHealthOverview() {
        ServerHealthOverview overview = new ServerHealthOverview(this.getJdbcClient());
        return overview.getHtml();
    }

    @Path(value="overview/details")
    @GET
    @Produces(value={"text/html"})
    public String getServerHealthDetails() {
        ServerHealthOverviewDetails details = new ServerHealthOverviewDetails(this.getJdbcClient(), false);
        return details.getHtml();
    }

    @Path(value="overview/details/all")
    @GET
    @Produces(value={"text/html"})
    public String getServerHealthDetailsAll() {
        ServerHealthOverviewDetails detailsAll = new ServerHealthOverviewDetails(this.getJdbcClient(), true);
        return detailsAll.getHtml();
    }

    @GET
    @Path(value="balancer")
    @Produces(value={"text/html"})
    public String getBalancerStatus() {
        return new ServerHealthBalancers(this.getJdbcClient()).getHtml();
    }

    @GET
    @Path(value="logs")
    @Produces(value={"text/html"})
    public String getServerLogs() {
        return new ServerHealthLogs(this.getJdbcClient()).getHtml();
    }

    @GET
    @Path(value="types")
    @Produces(value={"text/html"})
    public String getServerTypesHealth() {
        return new ServerHealthTypes(this.getJdbcClient()).getHtml();
    }

    @Path(value="top")
    @GET
    @Produces(value={"text/html"})
    public String getTop() throws Exception {
        Scanner s = new Scanner(Runtime.getRuntime().exec(new String[]{"bash", "-c", "top -n 1"}).getInputStream()).useDelimiter("\\A");
        String results = s.hasNext() ? s.next() : "";
        s.close();
        return AHTML.simplePage((String)results);
    }

    @Path(value="status")
    @GET
    @Produces(value={"application/json"})
    public ServerStatus serverStatus() {
        return new BuildServerStatusOperation(this.applicationServerManager, this.authManager, this.activityLog).get();
    }

    @Path(value="exec")
    @GET
    @Produces(value={"text/html"})
    public String exec(@Context UriInfo uriInfo) {
        ServerHealthExec exec = new ServerHealthExec(uriInfo);
        return exec.getHtml();
    }

    @Path(value="processes")
    @GET
    @Produces(value={"text/html"})
    public String serverProcesses() {
        ServerHealthProcesses proc = new ServerHealthProcesses(this.getJdbcClient());
        return proc.getHtml();
    }

    private JdbcClient getJdbcClient() {
        return this.jdbcServices.values().iterator().next().getClient();
    }
}

