/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer.callable.producer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexingTaskConsumer;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.TagQueueJoinQuery;
import org.eclipse.osee.orcs.search.IndexerCollector;

public abstract class AbstractIndexerTxDatabaseCallable
extends AbstractDatastoreTxCallable<List<Future<?>>> {
    private final SqlJoinFactory joinFactory;
    private final OrcsTokenService tokenService;
    private final IndexerCollector collector;
    private final int cacheLimit;
    private final boolean isCacheAll;
    private final List<Long> queryIds;
    private final IndexingTaskConsumer consumer;
    private TagQueueJoinQuery currentJoinQuery;
    private boolean isOkToDispatch;
    private long totalGammas;
    private List<Future<?>> futures;

    protected AbstractIndexerTxDatabaseCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, SqlJoinFactory joinFactory, OrcsTokenService tokenService, IndexingTaskConsumer consumer, IndexerCollector collector, boolean isCacheAll, int cacheLimit) {
        super(logger, session, jdbcClient);
        this.joinFactory = joinFactory;
        this.tokenService = tokenService;
        this.consumer = consumer;
        this.collector = collector;
        this.cacheLimit = cacheLimit;
        this.isCacheAll = isCacheAll;
        this.queryIds = new ArrayList<Long>();
        this.isOkToDispatch = false;
        this.currentJoinQuery = null;
    }

    @Override
    protected List<Future<?>> handleTxWork(JdbcConnection connection) {
        this.totalGammas = 0L;
        try {
            this.convertInput(connection);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        this.storeQueryIds(connection);
        if (this.collector != null) {
            this.collector.onIndexTaskTotalToProcess(this.queryIds.size());
            this.collector.onIndexTotalTaskItems(this.totalGammas);
        }
        this.isOkToDispatch = true;
        this.futures = new LinkedList();
        return this.futures;
    }

    @Override
    protected void handleTxException(Exception ex) {
        this.isOkToDispatch = false;
        if (this.collector != null) {
            if (this.queryIds.isEmpty()) {
                this.collector.onIndexTaskError(Long.valueOf(-2L), (Throwable)ex);
            } else {
                for (Long queryId : this.queryIds) {
                    this.collector.onIndexTaskError(queryId, (Throwable)ex);
                }
            }
        }
    }

    @Override
    protected void handleTxFinally() {
        super.handleTxFinally();
        if (this.isOkToDispatch && !this.queryIds.isEmpty()) {
            for (Long queryId : this.queryIds) {
                try {
                    Future<?> future = this.consumer.submitTaskId(this.getSession(), this.tokenService, this.collector, queryId);
                    this.futures.add(future);
                }
                catch (Exception ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
            }
        }
    }

    protected void addEntry(JdbcConnection connection, long gammaId) {
        if (this.currentJoinQuery == null) {
            this.currentJoinQuery = this.joinFactory.createTagQueueJoinQuery(connection);
        }
        this.currentJoinQuery.add(gammaId);
        if (this.isStorageNeeded()) {
            this.storeQueryIds(connection);
        }
    }

    private boolean isStorageNeeded() {
        return !this.isCacheAll && this.currentJoinQuery != null && this.currentJoinQuery.size() > this.cacheLimit;
    }

    private void storeQueryIds(JdbcConnection connection) {
        if (this.currentJoinQuery != null && !this.currentJoinQuery.isEmpty()) {
            this.currentJoinQuery.store();
            this.queryIds.add(this.currentJoinQuery.getQueryId());
            this.totalGammas += (long)this.currentJoinQuery.size();
        }
        this.currentJoinQuery = null;
    }

    protected abstract void convertInput(JdbcConnection var1) throws Exception;
}

