/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.commit;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.Named;

public class CommitConfigItem
implements Named {
    private IAtsTeamDefinition teamDef = null;
    private final AtsApi atsApi;
    private IAtsVersion version = null;

    public CommitConfigItem(IAtsTeamDefinition teamDef, AtsApi atsApi) {
        this.teamDef = teamDef;
        this.atsApi = atsApi;
    }

    public CommitConfigItem(IAtsVersion version, AtsApi atsApi) {
        this.version = version;
        this.atsApi = atsApi;
    }

    public BranchId getBaselineBranchId() {
        if (this.teamDef == null) {
            return this.version.getBaselineBranch();
        }
        return this.atsApi.getTeamDefinitionService().getBaselineBranchId(this.teamDef);
    }

    public Result isAllowCommitBranchInherited() {
        if (this.teamDef == null) {
            return this.atsApi.getVersionService().isAllowCommitBranchInherited(this.version);
        }
        return this.atsApi.getTeamDefinitionService().isAllowCommitBranchInherited(this.teamDef);
    }

    public Result isAllowCreateBranchInherited() {
        if (this.teamDef == null) {
            return this.atsApi.getVersionService().isAllowCreateBranchInherited(this.version);
        }
        return this.atsApi.getTeamDefinitionService().isAllowCreateBranchInherited(this.teamDef);
    }

    public IAtsConfigObject getConfigObject() {
        if (this.teamDef == null) {
            return this.version;
        }
        return this.teamDef;
    }

    public String getCommitFullDisplayName() {
        if (this.teamDef == null) {
            return this.version.getName();
        }
        return this.teamDef.getName();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.teamDef == null ? 0 : this.teamDef.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommitConfigItem other = (CommitConfigItem)obj;
        if (this.teamDef == null ? other.teamDef != null : !this.teamDef.equals(other.teamDef)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        String teamOrVersion = this.version == null ? "Team Def" : "Version";
        String name = this.version == null ? this.teamDef.getName() : this.version.getName();
        return String.format("%s - %s", teamOrVersion, name);
    }
}

