/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.NetRCCredentialsProvider;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.eclipse.osee.define.api.DefineTupleTypes;
import org.eclipse.osee.define.api.GitOperations;
import org.eclipse.osee.define.rest.FastHistoryStrategy;
import org.eclipse.osee.define.rest.HistoryImportStrategy;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.SystemProperties;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public final class GitOperationsImpl
implements GitOperations {
    private final OrcsApi orcsApi;
    private final QueryFactory queryFactory;
    private final SystemProperties systemPrefs;
    private final Map<String, ArtifactId> pathToCodeunitReferenceMap = new HashMap<String, ArtifactId>();
    private static final Pattern changeIdPattern = Pattern.compile("\\s+Change-Id: (I\\w{40})");
    private final Matcher changeIdMatcher = changeIdPattern.matcher("");

    public GitOperationsImpl(OrcsApi orcsApi, SystemProperties systemPrefs) {
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.systemPrefs = systemPrefs;
    }

    public ArtifactToken getCommitArtifactId(BranchId branch, String changeId) {
        List commits = this.queryFactory.fromBranch(branch).andAttributeIs((AttributeTypeId)CoreAttributeTypes.GitChangeId, changeId).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.GitCommit}).getResults().getList();
        ArtifactToken latestCommit = ArtifactToken.SENTINEL;
        Date lastestAuthorDate = new Date(0L);
        for (ArtifactReadable commit : commits) {
            try {
                Date authorDate = new SimpleDateFormat().parse((String)commit.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.GitCommitAuthorDate));
                if (!authorDate.after(lastestAuthorDate)) continue;
                lastestAuthorDate = authorDate;
                latestCommit = commit;
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
        }
        return latestCommit;
    }

    public ArtifactReadable getRepoArtifact(BranchId branch, String repositoryName) {
        return this.queryFactory.fromBranch(branch).andNameEquals(repositoryName).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.GitRepository}).getArtifact();
    }

    private Repository getLocalRepoReference(String repoPath) {
        File gitDirPath = new File(String.valueOf(repoPath) + File.separator + ".git");
        try {
            return ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDirPath)).readEnvironment()).findGitDir()).setMustExist(true)).build();
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public void fetch(ArtifactReadable repoArtifact, String passphrase) {
        Repository jgitRepo = this.getLocalRepoReference((String)repoArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FileSystemPath));
        this.fetch(jgitRepo, passphrase);
    }

    private void fetch(Repository localRepo, String passphrase) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Git git = new Git(localRepo);){
                FetchCommand fetchCommand = git.fetch().setCheckFetchedObjects(true).setTagOpt(TagOpt.FETCH_TAGS);
                this.configurateAuthentication(localRepo, (TransportCommand<?, ?>)fetchCommand, passphrase);
                fetchCommand.call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private void configurateAuthentication(Repository repo, TransportCommand<?, ?> transportCommand, String passphrase) {
        String gitRepoUrl = repo.getConfig().getString("remote", "origin", "url");
        this.configurateAuthentication(gitRepoUrl, transportCommand, passphrase);
    }

    private void configurateAuthentication(String gitRepoUrl, TransportCommand<?, ?> transportCommand, String passphrase) {
        if (gitRepoUrl.startsWith("ssh")) {
            this.configureSsh(transportCommand, passphrase);
        } else {
            transportCommand.setCredentialsProvider((CredentialsProvider)new NetRCCredentialsProvider());
        }
    }

    private void configureSsh(TransportCommand<?, ?> transportCommand, final String passphrase) {
        final JschConfigSessionFactory sessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host hc, Session session) {
                CredentialsProvider provider = new CredentialsProvider(){

                    public boolean isInteractive() {
                        return false;
                    }

                    public boolean supports(CredentialItem ... items) {
                        return true;
                    }

                    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
                        CredentialItem[] credentialItemArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CredentialItem item = credentialItemArray[n2];
                            ((CredentialItem.StringType)item).setValue(passphrase);
                            ++n2;
                        }
                        return true;
                    }
                };
                CredentialsProviderUserInfo userInfo = new CredentialsProviderUserInfo(session, provider);
                session.setUserInfo((UserInfo)userInfo);
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                File serverApplicDir;
                String serverDataPath = System.getProperty("osee.application.server.data");
                if (serverDataPath == null) {
                    serverDataPath = System.getProperty("user.home");
                }
                if (!(serverApplicDir = new File(String.format("%s%s.ssh", serverDataPath, File.separator))).exists()) {
                    serverApplicDir.mkdirs();
                }
                JSch defaultJSch = super.createDefaultJSch(fs);
                defaultJSch.addIdentity(String.format("%s%sid_rsa", serverApplicDir.getPath(), File.separator));
                return defaultJSch;
            }
        };
        SshSessionFactory.setInstance((SshSessionFactory)sessionFactory);
        transportCommand.setTransportConfigCallback(new TransportConfigCallback(){

            public void configure(Transport transport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory((SshSessionFactory)sessionFactory);
            }
        });
    }

    public ArtifactId trackGitBranch(String gitRepoUrl, BranchId branch, String gitBranchName, boolean clone, String passphrase) {
        ArtifactReadable repoArtifact = this.clone(gitRepoUrl, branch, gitBranchName, clone, passphrase);
        return this.updateGitTrackingBranch(branch, repoArtifact, gitBranchName, !clone, passphrase, true, false);
    }

    public ArtifactId updateGitTrackingBranch(BranchId branch, ArtifactReadable repoArtifact, String gitBranchName, boolean fetch, String passphrase, boolean initialImport, boolean shallowImport) {
        Repository jgitRepo = this.getLocalRepoReference((String)repoArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FileSystemPath));
        if (fetch) {
            this.fetch(jgitRepo, passphrase);
        }
        if (gitBranchName == null) {
            gitBranchName = (String)repoArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.DefaultTrackingBranch);
        }
        try {
            String latestImportedSHA;
            String fromString = "remotes/origin/" + gitBranchName;
            ObjectId from = jgitRepo.resolve(fromString);
            if (from == null) {
                throw new OseeStateException("Failed to resolve commit [%s]", new Object[]{fromString});
            }
            ObjectId to = null;
            ArtifactReadable latestCommit = (ArtifactReadable)repoArtifact.getRelated(CoreRelationTypes.GitRepositoryCommit_GitCommit).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
            if (latestCommit.isValid() && (to = ObjectId.fromString((String)(latestImportedSHA = (String)latestCommit.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.GitCommitSha)))) == null) {
                throw new OseeStateException("Failed to resolve commit [%s]", new Object[]{latestImportedSHA});
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)repoArtifact.getBranch(), "updateGitTrackingBranch repo [" + repoArtifact + "]");
            List currentCommits = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.CodeUnit}).andRelatedRecursive(CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)repoArtifact).asArtifacts();
            for (ArtifactReadable singleCommit : currentCommits) {
                String fullPathName = "";
                try {
                    fullPathName = singleCommit.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FileSystemPath);
                }
                catch (Exception exception) {
                    fullPathName = this.setFullPathName(branch, singleCommit, repoArtifact);
                    tx.setSoleAttributeFromString((ArtifactId)singleCommit, (AttributeTypeToken)CoreAttributeTypes.FileSystemPath, fullPathName);
                }
                if (fullPathName.isEmpty()) {
                    throw new OseeArgumentException("Attribute FileSystemPath on code unit %s - art id [%d] is missing and cannot be determined", new Object[]{singleCommit.getName(), singleCommit.getId()});
                }
                this.pathToCodeunitReferenceMap.put(fullPathName, (ArtifactId)singleCommit);
            }
            FastHistoryStrategy importStrategy = new FastHistoryStrategy(repoArtifact, this.orcsApi, tx, initialImport, shallowImport, this.pathToCodeunitReferenceMap);
            this.walkTree(repoArtifact, jgitRepo, to, from, branch, importStrategy, shallowImport);
        }
        catch (IOException | RevisionSyntaxException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return repoArtifact;
    }

    public List<String> getChangeIdBetweenTags(BranchId branch, ArtifactReadable repoArtifact, String startTag, String endTag) {
        Repository jgitRepo = this.getLocalRepoReference((String)repoArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FileSystemPath));
        this.fetch(jgitRepo, "");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Git git = new Git(jgitRepo);){
                Ref tag1 = git.getRepository().exactRef("refs/tags/" + startTag);
                Ref tag2 = git.getRepository().exactRef("refs/tags/" + endTag);
                Iterable commits = git.log().addRange((AnyObjectId)tag1.getPeeledObjectId(), (AnyObjectId)tag2.getPeeledObjectId()).call();
                ArrayList<String> changeIdList = new ArrayList<String>();
                for (RevCommit revCommit : commits) {
                    if (revCommit.getShortMessage() == "") continue;
                    String commitSHA = revCommit.getId().name();
                    if (this.changeIdMatcher.reset(revCommit.getFullMessage()).find()) {
                        String changeId = this.changeIdMatcher.group(1);
                        changeIdList.add(changeId);
                        continue;
                    }
                    changeIdList.add(commitSHA);
                }
                return changeIdList;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public List<String> getRemoteBranches(BranchId branch, ArtifactReadable repoArtifact) {
        Repository jgitRepo = this.getLocalRepoReference((String)repoArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FileSystemPath));
        ArrayList<String> allGitBranches = new ArrayList<String>();
        this.fetch(jgitRepo, "");
        try {
            List refs = new Git(jgitRepo).branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            for (Ref ref : refs) {
                allGitBranches.add(ref.getName().substring(ref.getName().lastIndexOf("/") + 1, ref.getName().length()));
            }
        }
        catch (GitAPIException ex) {
            ex.printStackTrace();
        }
        return allGitBranches;
    }

    public ArtifactReadable clone(String gitRepoUrl, BranchId branch, String gitBranchName, boolean clone, String passphrase) {
        String serverDataLocation = this.systemPrefs.getValue("osee.application.server.data");
        String repoName = gitRepoUrl.substring(gitRepoUrl.lastIndexOf(47) + 1).replaceAll("\\.git$", "");
        File localPath = new File(String.valueOf(serverDataLocation) + File.separator + "git", repoName);
        String branchToClone = "refs/heads/" + gitBranchName;
        if (clone) {
            CloneCommand jgitClone = Git.cloneRepository().setURI(gitRepoUrl).setDirectory(localPath).setBranchesToClone(Arrays.asList(branchToClone)).setBranch(branchToClone).setNoCheckout(true);
            this.configurateAuthentication(gitRepoUrl, (TransportCommand<?, ?>)jgitClone, passphrase);
            try {
                jgitClone.call();
            }
            catch (GitAPIException ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
        }
        if (this.queryFactory.fromBranch(branch).andNameEquals(repoName).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.GitRepository}).exists()) {
            throw new OseeStateException("A repository named %s already exists on branch %s", new Object[]{repoName, branch});
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "GitOperationsImpl.createGitRepository()");
        if (!this.queryFactory.fromBranch(branch).andNameEquals("Git Repositories").andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.Folder}).exists()) {
            tx.createArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.GitRepoFolder);
        }
        ArtifactToken repoArtifact = tx.createArtifact((ArtifactId)CoreArtifactTokens.GitRepoFolder, CoreArtifactTypes.GitRepository, repoName);
        tx.setSoleAttributeValue((ArtifactId)repoArtifact, (AttributeTypeToken)CoreAttributeTypes.RepositoryUrl, (Object)gitRepoUrl);
        try {
            tx.setSoleAttributeValue((ArtifactId)repoArtifact, (AttributeTypeToken)CoreAttributeTypes.FileSystemPath, (Object)localPath.getCanonicalPath());
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        tx.commit();
        return this.queryFactory.fromBranch(branch).andId((ArtifactId)repoArtifact).getArtifact();
    }

    private TransactionToken walkTree(ArtifactReadable repoArtifact, Repository jgitRepo, ObjectId to, ObjectId from, BranchId branch, HistoryImportStrategy importStrategy, boolean shallowImport) {
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (RevWalk revWalk = new RevWalk(jgitRepo);){
                revWalk.markStart(revWalk.parseCommit((AnyObjectId)from));
                if (to != null) {
                    RevCommit toRev = revWalk.parseCommit((AnyObjectId)to);
                    revWalk.markUninteresting(toRev);
                }
                revWalk.sort(RevSort.TOPO, true);
                revWalk.sort(RevSort.REVERSE, true);
                DiffFormatter df = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
                df.setRepository(jgitRepo);
                df.setDiffComparator(RawTextComparator.DEFAULT);
                df.setDetectRenames(true);
                this.setPathFilter(repoArtifact, df);
                ArtifactId lastValidCommit = ArtifactId.SENTINEL;
                ObjectReader objectReader = revWalk.getObjectReader();
                for (RevCommit revCommit : revWalk) {
                    ArtifactId lastCommit = this.parseGitCommit(objectReader, df, repoArtifact, revCommit, branch, importStrategy, shallowImport);
                    if (!lastCommit.isValid()) continue;
                    lastValidCommit = lastCommit;
                }
                if (lastValidCommit.isValid() && !shallowImport) {
                    TransactionBuilder tx = importStrategy.getTransactionBuilder(this.orcsApi, branch);
                    tx.unrelateFromAll(CoreRelationTypes.GitRepositoryCommit_GitCommit.getOpposite(), (ArtifactId)repoArtifact);
                    tx.relate((ArtifactId)repoArtifact, (RelationTypeToken)CoreRelationTypes.GitRepositoryCommit_GitCommit, lastValidCommit);
                    importStrategy.finishGitCommit(tx);
                }
                return importStrategy.finishImport();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private void setPathFilter(ArtifactReadable repoArtifact, DiffFormatter df) {
        List paths = repoArtifact.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.ExcludePath);
        if (!paths.isEmpty()) {
            ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
            for (String path : paths) {
                filters.add(PathFilter.create((String)path));
            }
            if (filters.size() > 1) {
                df.setPathFilter(AndTreeFilter.create(filters).negate());
            } else {
                df.setPathFilter(((TreeFilter)filters.get(0)).negate());
            }
        }
    }

    private ArtifactId createCommitArtifact(RevCommit revCommit, TransactionBuilder tx, BranchId branch) {
        String changeId;
        String commitSHA = revCommit.getId().name();
        String commitId = this.changeIdMatcher.reset(revCommit.getFullMessage()).find() ? (changeId = this.changeIdMatcher.group(1)) : commitSHA;
        try {
            return this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GitCommit}).andNameEquals(revCommit.getShortMessage()).asArtifact();
        }
        catch (Exception exception) {
            ArtifactToken commitArtifact = tx.createArtifact(CoreArtifactTypes.GitCommit, revCommit.getShortMessage());
            tx.setSoleAttributeValue((ArtifactId)commitArtifact, (AttributeTypeToken)CoreAttributeTypes.GitCommitSha, (Object)commitSHA);
            tx.setSoleAttributeValue((ArtifactId)commitArtifact, (AttributeTypeToken)CoreAttributeTypes.UserArtifactId, (Object)SystemUser.OseeSystem);
            tx.setSoleAttributeValue((ArtifactId)commitArtifact, (AttributeTypeToken)CoreAttributeTypes.GitCommitAuthorDate, (Object)revCommit.getAuthorIdent().getWhen());
            tx.setSoleAttributeValue((ArtifactId)commitArtifact, (AttributeTypeToken)CoreAttributeTypes.GitCommitMessage, (Object)revCommit.getFullMessage());
            tx.setSoleAttributeValue((ArtifactId)commitArtifact, (AttributeTypeToken)CoreAttributeTypes.GitChangeId, (Object)commitId);
            return commitArtifact;
        }
    }

    private ArtifactId parseGitCommit(ObjectReader objectReader, DiffFormatter df, ArtifactReadable repoArtifact, RevCommit revCommit, BranchId branch, HistoryImportStrategy importStrategy, boolean shallowImport) {
        try {
            TransactionBuilder tx = importStrategy.getTransactionBuilder(this.orcsApi, branch);
            ArtifactId commitArtifact = ArtifactId.SENTINEL;
            if (!shallowImport) {
                commitArtifact = this.createCommitArtifact(revCommit, tx, branch);
            }
            this.importFileChanges(objectReader, df, (ArtifactId)repoArtifact, revCommit, revCommit.getId().name(), commitArtifact, branch, tx, importStrategy);
            importStrategy.finishGitCommit(tx);
            ArtifactId artifactId = commitArtifact;
            return artifactId;
        }
        finally {
            revCommit.disposeBody();
        }
    }

    private void importFileChanges(ObjectReader objectReader, DiffFormatter df, ArtifactId repoArtifact, RevCommit revCommit, String commitSHA, ArtifactId commitArtifact, BranchId branch, TransactionBuilder tx, HistoryImportStrategy importStrategy) {
        if (revCommit.getParents().length > 1) {
            return;
        }
        RevTree parentTree = revCommit.getParentCount() > 0 ? revCommit.getParent(0).getTree() : null;
        List diffs = null;
        try {
            diffs = df.scan(parentTree, revCommit.getTree());
            for (DiffEntry entry : diffs) {
                DiffEntry.ChangeType changeType = entry.getChangeType();
                String path = entry.getOldPath();
                String newPath = entry.getNewPath();
                ArtifactId codeUnit = importStrategy.getCodeUnit(branch, tx, commitSHA, changeType, path, newPath);
                if (!commitArtifact.isValid()) continue;
                if (codeUnit.isValid()) {
                    importStrategy.handleCodeUnit(branch, codeUnit, tx, repoArtifact, commitArtifact, changeType, newPath);
                    continue;
                }
                ArtifactId[] commitWraper = new ArtifactId[]{ArtifactId.SENTINEL};
                codeUnit = importStrategy.findCodeUnit(repoArtifact, newPath);
                this.orcsApi.getQueryFactory().tupleQuery().getTuple4E3E4FromE1E2(DefineTupleTypes.GitLatest, branch, (Object)repoArtifact, (Object)codeUnit, (changeCommit, ignore) -> {
                    ArtifactId artifactId = changeCommit;
                });
                if (commitWraper[0].isValid() || !codeUnit.isValid()) continue;
                importStrategy.handleCodeUnit(branch, codeUnit, tx, repoArtifact, commitArtifact, changeType, newPath);
            }
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private String setFullPathName(BranchId branch, ArtifactReadable singleCommit, ArtifactReadable repoArtifact) {
        ArtifactReadable art = singleCommit;
        String wholePath = art.getName();
        while (!art.getParent().equals(repoArtifact)) {
            art = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Folder}).andId((ArtifactId)art.getParent()).asArtifact();
            wholePath = String.valueOf(art.getName()) + "/" + wholePath;
        }
        return wholePath;
    }
}

