/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.transition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsReviewService;
import org.eclipse.osee.ats.api.task.IAtsTaskService;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.util.AtsTopicEvent;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsStoreService;
import org.eclipse.osee.ats.api.util.IExecuteListener;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionService;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.IAtsWorkItemService;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.task.CreateTasksRuleRunner;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class TransitionManager
implements IExecuteListener {
    private final ITransitionHelper helper;
    private Date transitionOnDate;
    private final IAtsUserService userService;
    private final IAtsReviewService reviewService;
    private final IAtsWorkItemService workItemService;
    private final IAtsTaskService taskService;
    private final IAtsWorkDefinitionService workDefService;
    private final IAttributeResolver attrResolver;
    private final Map<IAtsWorkItem, String> workItemFromStateMap;
    private final IAtsStoreService storeService;

    public TransitionManager(ITransitionHelper helper) {
        this(helper, false);
    }

    public TransitionManager(ITransitionHelper helper, boolean overrideClientCheck) {
        this.helper = helper;
        this.userService = helper.getServices().getUserService();
        this.reviewService = helper.getServices().getReviewService();
        this.workItemService = helper.getServices().getWorkItemService();
        this.workDefService = helper.getServices().getWorkDefinitionService();
        this.attrResolver = helper.getServices().getAttributeResolver();
        this.taskService = helper.getServices().getTaskService();
        this.storeService = helper.getServices().getStoreService();
        this.workItemFromStateMap = new HashMap<IAtsWorkItem, String>();
        if (helper.getServices().isIde() && !overrideClientCheck && !AtsUtil.isInTest()) {
            try {
                throw new OseeArgumentException("TransitionManager should NOT be used on client.  Use AtsApiService.get().getWorkItemServiceClient().transition() instead.", new Object[0]);
            }
            catch (Exception ex) {
                OseeLog.log(TransitionManager.class, (Level)Level.WARNING, (String)("Exception: " + Lib.exceptionToString((Exception)ex)));
            }
        }
    }

    public TransitionResults handleAll() {
        this.loadWorkItems();
        IAtsWorkItem workItem = (IAtsWorkItem)this.helper.getWorkItems().iterator().next();
        TransitionResults results = new TransitionResults();
        if (this.storeService.isIdeClient() && this.storeService.isInDb(workItem)) {
            this.handleWorkflowReload(results);
            if (results.isCancelled() || !results.isEmpty()) {
                return results;
            }
        }
        this.handleTransitionValidation(results);
        if (results.isCancelled() || !results.isEmpty()) {
            return results;
        }
        this.handleTransition(results);
        return results;
    }

    private void loadWorkItems() {
        if (this.helper.getTransData().getWorkItems().isEmpty()) {
            for (ArtifactToken art : this.helper.getServices().getQueryService().getArtifacts((Collection)Collections.castAll((Collection)this.helper.getTransData().getWorkItemIds()), (BranchId)this.helper.getServices().getAtsBranch())) {
                this.helper.getTransData().getWorkItems().add(this.helper.getServices().getWorkItemService().getWorkItem(art));
            }
        }
    }

    private void handleWorkflowReload(TransitionResults results) {
        if (this.helper.isReload()) {
            this.helper.handleWorkflowReload(results);
        }
    }

    public TransitionResults handleTransitionValidation(TransitionResults results) {
        this.loadWorkItems();
        boolean overrideAssigneeCheck = this.helper.isOverrideAssigneeCheck();
        try {
            if (this.helper.getWorkItems().isEmpty()) {
                results.addResult(TransitionResult.NO_WORKFLOWS_PROVIDED_FOR_TRANSITION);
                return results;
            }
            if (this.helper.getToStateName() == null) {
                results.addResult(TransitionResult.TO_STATE_CANT_BE_NULL);
                return results;
            }
            if (!overrideAssigneeCheck && this.helper.isSystemUser()) {
                results.addResult(TransitionResult.CAN_NOT_TRANSITION_AS_SYSTEM_USER);
                return results;
            }
        }
        catch (OseeCoreException ex) {
            results.addResult(new TransitionResult(String.format("Exception while validating transition [%s]", this.helper.getName()), (Exception)((Object)ex)));
        }
        for (IAtsWorkItem workItem : this.helper.getWorkItems()) {
            try {
                boolean currentlyUnAssignedOrCompletedOrCancelled;
                StateDefinition fromStateDef;
                if (this.helper.getChangeSet() != null) {
                    this.helper.getChangeSet().add((Object)workItem);
                }
                if ((fromStateDef = workItem.getStateDefinition()) == null) {
                    OseeLog.log(TransitionManager.class, (Level)Level.SEVERE, (String)String.format("from state for workItem %s is null", workItem.getName()));
                    continue;
                }
                StateDefinition toStateDef = workItem.getWorkDefinition().getStateByName(this.helper.getToStateName());
                if (toStateDef == null) {
                    results.addResult(workItem, new TransitionResult(String.format("Transition-To State [%s] does not exist for Work Definition [%s]", this.helper.getToStateName(), workItem.getWorkDefinition().getName())));
                    continue;
                }
                if (fromStateDef.equals((Object)toStateDef)) continue;
                List toStatesWithReturnStates = this.workItemService.getAllToStates(workItem);
                if (!(this.helper.isOverrideTransitionValidityCheck() || toStatesWithReturnStates.contains(toStateDef) || fromStateDef.getStateType().isCompletedOrCancelledState())) {
                    String errStr = String.format("Work Definition [%s] is not configured to transition from \"[%s]\" to \"[%s]\"", fromStateDef.getWorkDefinition().getName(), fromStateDef.getName(), toStateDef.getName());
                    OseeLog.log(TransitionManager.class, (Level)Level.SEVERE, (String)errStr);
                    results.addResult(workItem, new TransitionResult(errStr));
                    continue;
                }
                boolean isEditable = AtsApiService.get().getAtsAccessService().isWorkflowEditable(workItem);
                boolean bl = currentlyUnAssignedOrCompletedOrCancelled = workItem.isCompletedOrCancelled() || workItem.getStateMgr().getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER);
                if (workItem.isTask() && workItem.getParentTeamWorkflow().getCurrentStateType().isCompletedOrCancelled()) {
                    results.addResult(workItem, TransitionResult.TASK_CANT_TRANSITION_IF_PARENT_COMPLETED);
                    continue;
                }
                if (!(workItem.isTask() || isEditable || currentlyUnAssignedOrCompletedOrCancelled || overrideAssigneeCheck)) {
                    results.addResult(workItem, TransitionResult.UNABLE_TO_ASSIGN);
                    continue;
                }
                if (!this.helper.isOverrideWorkingBranchCheck()) {
                    this.isWorkingBranchTransitionable(results, workItem, toStateDef);
                    if (results.isCancelled()) continue;
                }
                if (!overrideAssigneeCheck && !toStateDef.getStateType().isCancelledState() && this.helper.isSystemUserAssingee(workItem)) {
                    results.addResult(workItem, TransitionResult.CAN_NOT_TRANSITION_WITH_SYSTEM_USER_ASSIGNED);
                    continue;
                }
                this.isStateTransitionable(results, workItem, toStateDef);
                if (results.isCancelled()) continue;
                this.isTransitionValidForExtensions(results, workItem, fromStateDef, toStateDef);
                if (!results.isCancelled()) continue;
            }
            catch (OseeCoreException ex) {
                results.addResult(workItem, new TransitionResult(String.format("Exception while validating transition [%s]", this.helper.getName()), (Exception)((Object)ex)));
            }
        }
        return results;
    }

    public void isTransitionValidForExtensions(TransitionResults results, IAtsWorkItem workItem, StateDefinition fromStateDef, StateDefinition toStateDef) {
        for (IAtsTransitionHook listener : this.helper.getTransitionHooks()) {
            try {
                listener.transitioning(results, workItem, (IStateToken)fromStateDef, (IStateToken)toStateDef, this.getToAssignees(workItem, toStateDef), this.helper.getTransitionUser());
                if (results.isCancelled() || results.isEmpty()) continue;
            }
            catch (OseeCoreException ex) {
                results.addResult(workItem, new TransitionResult(String.format("Exception [%s] while validating transition extensions 1 [%s]", ex.getMessage(), this.helper.getName()), (Exception)((Object)ex)));
            }
        }
        if (results.isEmpty()) {
            for (IAtsTransitionHook listener : this.helper.getTransitionHooks()) {
                try {
                    listener.transitioning(results, workItem, (IStateToken)fromStateDef, (IStateToken)toStateDef, this.getToAssignees(workItem, toStateDef), AtsApiService.get().getUserService().getCurrentUser());
                    if (results.isCancelled() || results.isEmpty()) continue;
                }
                catch (OseeCoreException ex) {
                    results.addResult(workItem, new TransitionResult(String.format("Exception [%s] while validating transition extensions 2 [%s]", ex.getMessage(), this.helper.getName()), (Exception)((Object)ex)));
                }
            }
        }
    }

    public void handleTransition(TransitionResults results) {
        try {
            IAtsChangeSet changes = this.helper.getChangeSet();
            if (changes != null) {
                changes.addExecuteListener((IExecuteListener)this);
            }
            for (IAtsWorkItem workItem : this.helper.getWorkItems()) {
                try {
                    StateDefinition fromState = workItem.getStateDefinition();
                    StateDefinition toState = workItem.getWorkDefinition().getStateByName(this.helper.getToStateName());
                    if (!fromState.equals((Object)toState)) {
                        IAtsDecisionReview review;
                        Date transitionDate = this.getTransitionOnDate();
                        AtsUser transitionUser = this.getTransitionAsUser();
                        if (fromState.getStateType().isCancelledState()) {
                            this.logWorkflowUnCancelledEvent(workItem, toState, changes, this.attrResolver);
                        } else if (fromState.getStateType().isCompletedState()) {
                            this.logWorkflowUnCompletedEvent(workItem, toState, changes, this.attrResolver);
                        }
                        if (toState.getStateType().isCancelledState()) {
                            this.logWorkflowCancelledEvent(workItem, fromState, toState, transitionDate, transitionUser, changes, this.attrResolver);
                        } else if (toState.getStateType().isCompletedState()) {
                            this.logWorkflowCompletedEvent(workItem, fromState, toState, transitionDate, transitionUser, changes);
                        } else {
                            this.updatePercentComplete(workItem, toState, changes);
                            this.logStateCompletedEvent(workItem, workItem.getCurrentStateName(), transitionDate, transitionUser);
                        }
                        TransitionManager.logStateStartedEvent(workItem, (IStateToken)toState, transitionDate, transitionUser);
                        List<? extends AtsUser> updatedAssigees = this.getToAssignees(workItem, toState);
                        workItem.getStateMgr().transitionHelper(updatedAssigees, (IStateToken)fromState, (IStateToken)toState);
                        if (this.reviewService.isValidationReviewRequired(workItem) && workItem.isTeamWorkflow() && (review = this.reviewService.createValidateReview((IAtsTeamWorkflow)workItem, false, transitionDate, transitionUser, changes)) != null) {
                            changes.add((Object)review);
                        }
                        if (workItem.isTeamWorkflow()) {
                            CreateTasksRuleRunner taskRunner = new CreateTasksRuleRunner((IAtsTeamWorkflow)workItem, workItem.getWorkDefinition().getCreateTasksDefs(), this.helper.getServices());
                            XResultData result = taskRunner.run();
                            if (result.isErrors()) {
                                results.addResult(new TransitionResult(result.toString()));
                            } else {
                                result.getIds().isEmpty();
                            }
                        }
                        for (IAtsTransitionHook listener : this.helper.getTransitionHooks()) {
                            listener.transitioned(workItem, (IStateToken)fromState, (IStateToken)toState, updatedAssigees, this.helper.getTransitionUser(), changes);
                        }
                        for (IAtsTransitionHook listener : toState.getTransitionListeners()) {
                            listener.transitioned(workItem, (IStateToken)fromState, (IStateToken)toState, updatedAssigees, this.helper.getTransitionUser(), changes);
                        }
                        if (toState.getStateType().isCompletedOrCancelledState()) {
                            this.workItemService.clearImplementersCache(workItem);
                        }
                        changes.add((Object)workItem);
                        this.workItemFromStateMap.put(workItem, fromState.getName());
                    }
                }
                catch (Exception ex) {
                    results.addResult(workItem, new TransitionResult(String.format("Exception while transitioning [%s]", this.helper.getName()), ex));
                }
                results.getWorkItemIds().add(ArtifactToken.valueOf((long)workItem.getId(), (String)workItem.getName(), (BranchToken)this.helper.getServices().getAtsBranch()));
            }
        }
        catch (Exception ex) {
            results.addResult(new TransitionResult(String.format("Exception while transitioning [%s]", this.helper.getName()), ex));
        }
    }

    private void isWorkingBranchTransitionable(TransitionResults results, IAtsWorkItem workItem, StateDefinition toStateDef) {
        if (workItem.isTeamWorkflow() && this.helper.isWorkingBranchInWork((IAtsTeamWorkflow)workItem)) {
            if (toStateDef.getName().equals(TeamState.Cancelled.getName())) {
                results.addResult(workItem, TransitionResult.DELETE_WORKING_BRANCH_BEFORE_CANCEL);
            } else if (this.helper.isBranchInCommit((IAtsTeamWorkflow)workItem)) {
                results.addResult(workItem, TransitionResult.WORKING_BRANCH_BEING_COMMITTED);
            } else if (!toStateDef.hasRule(RuleDefinitionOption.AllowTransitionWithWorkingBranch.name())) {
                results.addResult(workItem, TransitionResult.WORKING_BRANCH_EXISTS);
            }
        }
    }

    private boolean isOverrideAttributeValidationState(IAtsWorkItem workItem, StateDefinition toStateDef) {
        List visitedStateNames = workItem.getStateMgr().getVisitedStateNames();
        if (visitedStateNames.contains(toStateDef.getName())) {
            StateDefinition currState = workItem.getStateDefinition();
            for (StateDefinition stateDef : toStateDef.getWorkDefinition().getStates()) {
                if (!stateDef.getName().equals(toStateDef.getName()) || toStateDef.getOrdinal() >= currState.getOrdinal()) continue;
                return true;
            }
        }
        return false;
    }

    private void isStateTransitionable(TransitionResults results, IAtsWorkItem workItem, StateDefinition toStateDef) {
        boolean isOverrideAttributeValidationState;
        boolean bl = isOverrideAttributeValidationState = this.helper.isOverrideTransitionValidityCheck() || this.isOverrideAttributeValidationState(workItem, toStateDef);
        if (toStateDef.getStateType().isCancelledState()) {
            TransitionManager.validateTaskCompletion(results, workItem, toStateDef, this.taskService);
            this.validateReviewsCancelled(results, workItem, toStateDef);
        } else if (!toStateDef.getStateType().isCancelledState() && !isOverrideAttributeValidationState) {
            Collection widgetResults = this.workItemService.validateWidgetTransition(workItem, toStateDef);
            for (WidgetResult widgetResult : widgetResults) {
                if (widgetResult.isSuccess()) continue;
                results.addResult(workItem, (TransitionResult)widgetResult);
            }
            TransitionManager.validateTaskCompletion(results, workItem, toStateDef, this.taskService);
            boolean teamDefRequiresTargetedVersion = this.workDefService.teamDefHasRule(workItem, RuleDefinitionOption.RequireTargetedVersion);
            boolean pageRequiresTargetedVersion = workItem.getStateDefinition().hasRule(RuleDefinitionOption.RequireTargetedVersion.name());
            if (workItem.isTeamWorkflow() && (teamDefRequiresTargetedVersion || pageRequiresTargetedVersion) && !this.helper.getServices().getVersionService().hasTargetedVersion(workItem) && !toStateDef.getStateType().isCancelledState()) {
                results.addResult(workItem, TransitionResult.MUST_BE_TARGETED_FOR_VERSION);
            }
            if (workItem.isTeamWorkflow()) {
                for (IAtsAbstractReview review : this.reviewService.getReviewsFromCurrentState((IAtsTeamWorkflow)workItem)) {
                    if (this.reviewService.getReviewBlockType(review) != ReviewBlockType.Transition || review.getCurrentStateType().isCompletedOrCancelled()) continue;
                    results.addResult(workItem, TransitionResult.COMPLETE_BLOCKING_REVIEWS);
                }
            }
        }
    }

    private void validateReviewsCancelled(TransitionResults results, IAtsWorkItem workItem, StateDefinition toStateDef) {
        if (workItem.isTeamWorkflow() && toStateDef.getStateType().isCancelledState()) {
            for (IAtsAbstractReview review : this.reviewService.getReviewsFromCurrentState((IAtsTeamWorkflow)workItem)) {
                ReviewBlockType reviewBlockType = this.reviewService.getReviewBlockType(review);
                boolean completedOrCancelled = review.getCurrentStateType().isCompletedOrCancelled();
                if (reviewBlockType != ReviewBlockType.Transition || completedOrCancelled) continue;
                results.addResult(workItem, TransitionResult.CANCEL_REVIEWS_BEFORE_CANCEL);
                break;
            }
        }
    }

    public static void validateTaskCompletion(TransitionResults results, IAtsWorkItem workItem, StateDefinition toStateDef, IAtsTaskService taskService) {
        if (!workItem.isTeamWorkflow()) {
            return;
        }
        boolean checkTasksCompletedForState = true;
        if (workItem.getStateDefinition().hasRule(RuleDefinitionOption.AllowTransitionWithoutTaskCompletion.name()) && toStateDef.getStateType().isWorkingState()) {
            checkTasksCompletedForState = false;
        }
        if (checkTasksCompletedForState && workItem.getCurrentStateType().isInWork()) {
            HashSet tasksToCheck = new HashSet();
            if (toStateDef.getStateType().isCompletedOrCancelledState()) {
                tasksToCheck.addAll(taskService.getTask(workItem));
            } else {
                tasksToCheck.addAll(taskService.getTasks(workItem, (IStateToken)workItem.getStateDefinition()));
            }
            for (IAtsTask task : tasksToCheck) {
                if (!task.getCurrentStateType().isInWork()) continue;
                results.addResult(workItem, TransitionResult.TASKS_NOT_COMPLETED);
                break;
            }
        }
    }

    private void logWorkflowCancelledEvent(IAtsWorkItem workItem, StateDefinition fromState, StateDefinition toState, Date cancelDate, AtsUser cancelBy, IAtsChangeSet changes, IAttributeResolver attrResolver) {
        TransitionManager.logWorkflowCancelledEvent(workItem, fromState, toState, cancelDate, this.helper.getCancellationReason(), this.helper.getCancellationReasonAttrType(), this.helper.getCancellationReasonDetails(), cancelBy, changes, attrResolver);
    }

    public static void logWorkflowCancelledEvent(IAtsWorkItem workItem, StateDefinition fromState, StateDefinition toState, Date cancelDate, String cancelReason, AttributeTypeToken cancelReasonAttrType, String cancelReasonDetails, AtsUser cancelBy, IAtsChangeSet changes, IAttributeResolver attrResolver) {
        workItem.getLog().addLog(LogType.StateCancelled, fromState.getName(), cancelReason, cancelDate, cancelBy.getUserId());
        if (attrResolver.isAttributeTypeValid(workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy)) {
            attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledBy, (Object)cancelBy.getUserId(), changes);
            attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledDate, (Object)cancelDate, changes);
            if (Strings.isValid((String)cancelReason)) {
                Conditions.assertTrue((boolean)cancelReasonAttrType.isValid(), (String)"Cancel Attr Type must be valid", (Object[])new Object[0]);
                attrResolver.setSoleAttributeValue((IAtsObject)workItem, cancelReasonAttrType, (Object)cancelReason, changes);
            }
            if (Strings.isValid((String)cancelReasonDetails)) {
                attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledReasonDetails, (Object)cancelReasonDetails, changes);
            }
            attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledFromState, (Object)fromState.getName(), changes);
        }
        TransitionManager.validateUpdatePercentComplete(workItem, toState, changes);
    }

    private void logWorkflowUnCancelledEvent(IAtsWorkItem workItem, StateDefinition toState, IAtsChangeSet changes, IAttributeResolver attrResolver) {
        if (attrResolver.isAttributeTypeValid(workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy)) {
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledBy, changes);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledDate, changes);
            changes.deleteAttributes((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledReason);
            changes.deleteAttributes((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledReasonEnum);
            changes.deleteAttributes((ArtifactId)workItem.getStoreObject(), (AttributeTypeToken)AtsAttributeTypes.CancelledReasonDetails);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.CancelledFromState, changes);
        }
        TransitionManager.validateUpdatePercentComplete(workItem, toState, changes);
    }

    private void logWorkflowCompletedEvent(IAtsWorkItem workItem, StateDefinition fromState, StateDefinition toState, Date cancelDate, AtsUser cancelBy, IAtsChangeSet changes) {
        workItem.getLog().addLog(LogType.StateComplete, fromState.getName(), "", cancelDate, cancelBy.getUserId());
        if (this.attrResolver.isAttributeTypeValid(workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy)) {
            this.attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CompletedBy, (Object)cancelBy.getUserId(), changes);
            this.attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CompletedDate, (Object)cancelDate, changes);
            this.attrResolver.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.CompletedFromState, (Object)fromState.getName(), changes);
        }
        TransitionManager.validateUpdatePercentComplete(workItem, toState, changes);
    }

    private void logWorkflowUnCompletedEvent(IAtsWorkItem workItem, StateDefinition toState, IAtsChangeSet changes, IAttributeResolver attrResolver) {
        if (attrResolver.isAttributeTypeValid(workItem, (AttributeTypeToken)AtsAttributeTypes.CreatedBy)) {
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.CompletedBy, changes);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.CompletedDate, changes);
            attrResolver.deleteSoleAttribute(workItem, (AttributeTypeToken)AtsAttributeTypes.CompletedFromState, changes);
        }
        TransitionManager.validateUpdatePercentComplete(workItem, toState, changes);
    }

    private void updatePercentComplete(IAtsWorkItem workItem, StateDefinition toState, IAtsChangeSet changes) {
        workItem.getStateMgr();
        Integer percent = AtsApiService.get().getWorkItemMetricsService().getPercentComplete(workItem);
        if (percent == null) {
            percent = 0;
        }
        if (toState.getStateType().isWorkingState()) {
            Integer recPercent = toState.getRecommendedPercentComplete();
            if (recPercent != null && recPercent > 0) {
                AtsApiService.get().getWorkItemMetricsService().setPercentComplete(workItem, recPercent, changes);
            }
            changes.add((Object)workItem);
        }
    }

    private static void validateUpdatePercentComplete(IAtsWorkItem workItem, StateDefinition toState, IAtsChangeSet changes) {
        Integer percent = AtsApiService.get().getWorkItemMetricsService().getPercentComplete(workItem);
        if (percent == null) {
            percent = 0;
        }
        if (toState.getStateType().isCompletedOrCancelledState() && percent != 100) {
            AtsApiService.get().getWorkItemMetricsService().setPercentComplete(workItem, Integer.valueOf(100), changes);
            changes.add((Object)workItem);
        } else if (toState.getStateType().isWorkingState() && percent == 100) {
            AtsApiService.get().getWorkItemMetricsService().setPercentComplete(workItem, Integer.valueOf(0), changes);
            changes.add((Object)workItem);
        }
    }

    private void logStateCompletedEvent(IAtsWorkItem workItem, String fromStateName, Date date, AtsUser user) {
        workItem.getLog().addLog(LogType.StateComplete, fromStateName, "", date, user.getUserId());
    }

    public static void logStateStartedEvent(IAtsWorkItem workItem, IStateToken state, Date date, AtsUser user) {
        workItem.getLog().addLog(LogType.StateEntered, state.getName(), "", date, user.getUserId());
    }

    public AtsUser getTransitionAsUser() {
        AtsUser user = this.helper.getTransitionUser();
        if (user == null) {
            user = this.userService.getCurrentUser();
        }
        return user;
    }

    public Date getTransitionOnDate() {
        if (this.transitionOnDate == null) {
            return new Date();
        }
        return this.transitionOnDate;
    }

    public void setTransitionOnDate(Date transitionOnDate) {
        this.transitionOnDate = transitionOnDate;
    }

    public List<? extends AtsUser> getToAssignees(IAtsWorkItem workItem, StateDefinition toState) {
        ArrayList<AtsUser> toAssignees = new ArrayList<AtsUser>();
        if (toState.getStateType().isWorkingState()) {
            Collection requestedAssignees = this.helper.getToAssignees(workItem);
            if (requestedAssignees != null) {
                for (AtsUser user : requestedAssignees) {
                    toAssignees.add(user);
                }
            }
            if (toAssignees.contains(AtsCoreUsers.UNASSIGNED_USER)) {
                toAssignees.remove(AtsCoreUsers.UNASSIGNED_USER);
                toAssignees.add(this.getTransitionAsUser());
            }
            if (toAssignees.isEmpty()) {
                if (this.helper.isSystemUser()) {
                    toAssignees.add(AtsCoreUsers.UNASSIGNED_USER);
                } else {
                    toAssignees.add(this.getTransitionAsUser());
                }
            }
        }
        return toAssignees;
    }

    public TransitionResults handleAllAndPersist() {
        TransitionResults result = this.handleAll();
        if (result.isEmpty()) {
            if (this.helper.getChangeSet() != null) {
                TransactionToken transactionId = this.helper.getChangeSet().execute();
                result.setTransaction((TransactionId)transactionId);
            }
            if (this.helper.getServices().getEventService() != null) {
                this.helper.getServices().getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_TRANSITIONED, this.helper.getWorkItems(), result.getTransaction());
            }
        } else if (this.helper.getServices().getEventService() != null) {
            this.helper.getServices().getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_TRANSITION_FAILED, this.helper.getWorkItems(), (TransactionId)TransactionToken.SENTINEL);
        }
        return result;
    }

    public void changesStored(IAtsChangeSet changes) {
        for (IAtsTransitionHook listener : this.helper.getTransitionHooks()) {
            listener.transitionPersisted(this.helper.getWorkItems(), this.workItemFromStateMap, this.helper.getToStateName(), this.helper.getTransitionUser());
        }
    }
}

