/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.state;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IExecuteListener;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.api.workflow.state.IAtsWorkStateFactory;
import org.eclipse.osee.ats.core.internal.state.StateManager;
import org.eclipse.osee.ats.core.internal.state.StateManagerReader;
import org.eclipse.osee.ats.core.internal.state.StateManagerWriter;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;

public class StateManagerStore {
    public static void writeToStore(AtsUser asUser, IAtsWorkItem workItem, StateManager stateMgr, IAttributeResolver attrResolver, IAtsChangeSet changes, IAtsWorkStateFactory workStateFactory) {
        StateManagerWriter writer = new StateManagerWriter(workItem, stateMgr, attrResolver, changes, workStateFactory);
        Collection assigneesAdded = stateMgr.getAssigneesAdded();
        writer.writeToStore();
        changes.addExecuteListener(StateManagerStore.getPostPersistExecutionListener(asUser, workItem, stateMgr, (List<AtsUser>)assigneesAdded, attrResolver, workStateFactory, changes));
    }

    protected static void postPersistNotifyReset(AtsUser asUser, IAtsWorkItem workItem, IAtsStateManager stateMgr, List<AtsUser> assigneesAdded, IAttributeResolver attrResolver, IAtsWorkStateFactory workStateFactory, IAtsChangeSet changes) {
        try {
            if (!assigneesAdded.isEmpty()) {
                changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((AtsUser)asUser, (IAtsWorkItem)workItem, assigneesAdded, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.Assigned}));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(StateManagerStore.class, (Level)Level.SEVERE, (String)"Error adding ATS Notification Event", (Throwable)ex);
        }
        StateManagerStore.load(workItem, stateMgr, attrResolver, workStateFactory);
    }

    protected static IExecuteListener getPostPersistExecutionListener(final AtsUser asUser, final IAtsWorkItem workItem, final IAtsStateManager stateMgr, final List<AtsUser> assigneesAdded, final IAttributeResolver attrResolver, final IAtsWorkStateFactory workStateFactory, IAtsChangeSet changes) {
        return new IExecuteListener(){

            public void changesStored(IAtsChangeSet changes) {
                try {
                    StateManagerStore.postPersistNotifyReset(asUser, workItem, stateMgr, assigneesAdded, attrResolver, workStateFactory, changes);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(StateManagerStore.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        };
    }

    public static void load(IAtsWorkItem workItem, IAtsStateManager stateMgr, IAttributeResolver attrResolver, IAtsWorkStateFactory workStateFactory) {
        try {
            StateManager stateManager = (StateManager)stateMgr;
            stateManager.clear();
            StateManagerReader reader = new StateManagerReader(workItem, stateManager, attrResolver, workStateFactory);
            reader.load();
        }
        catch (Exception ex) {
            OseeLog.log(StateManagerStore.class, (Level)Level.SEVERE, (String)String.format("Exception loading state manager work work item %s", workItem.toStringWithId()), (Throwable)ex);
            throw ex;
        }
    }
}

