/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.vcast;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.util.Result;

public class VCastValidateDatFileSyntax {
    private static final Pattern threeNumbersPattern = Pattern.compile("\\s*([0-9]+)\\s+([0-9]+)\\s+([0-9]+)");
    private static final Pattern threeNumbersPlusTokenPattern = Pattern.compile("\\s*([0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s+(T|F)");

    public static Result validateDatFileSyntax(String line) {
        Matcher threeNumberPlusTokenMatcher;
        Matcher threeNumbersMatcher;
        StringTokenizer st = new StringTokenizer(line);
        int count = st.countTokens();
        if (count != 3 && count != 4 && count != 5) {
            return new Result(false, "VCastVerifyDatFileSyntax.validateDatFileSyntax() - WARNING: DAT file line has to many parameters: [" + line + "]");
        }
        if (count == 3 && (threeNumbersMatcher = threeNumbersPattern.matcher(line)).groupCount() != 3) {
            return new Result(false, "VCastVerifyDatFileSyntax.validateDatFileSyntax() - WARNING: DAT file line has 1 or more parameters that are not numeric: [" + line + "]");
        }
        if (count == 4 && (threeNumberPlusTokenMatcher = threeNumbersPlusTokenPattern.matcher(line)).groupCount() != 4) {
            return new Result(false, "VCastVerifyDatFileSyntax.validateDatFileSyntax() - WARNING: DAT file line has 1 or more parameters that are not numeric + token: [" + line + "]");
        }
        if (count == 5 && (threeNumbersMatcher = threeNumbersPattern.matcher(line)).groupCount() != 3) {
            return new Result(false, "VCastVerifyDatFileSyntax.validateDatFileSyntax() - WARNING: DAT file line has 1 or more parameters that are not numeric: [" + line + "]");
        }
        return Result.TrueResult;
    }
}

